/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapUrlOptions;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.net.MalformedURLException;
import java.net.URL;

public class GoogleCodeSitemapUrl
extends WebSitemapUrl {
    private final String fileType;
    private final String license;
    private final String fileName;
    private final URL packageUrl;
    private final String packageMap;

    public GoogleCodeSitemapUrl(URL url, FileType fileType) {
        this(new Options(url, fileType));
    }

    public GoogleCodeSitemapUrl(String url, FileType fileType) throws MalformedURLException {
        this(new Options(url, fileType));
    }

    public GoogleCodeSitemapUrl(URL url, String fileType) {
        this(new Options(url, fileType));
    }

    public GoogleCodeSitemapUrl(String url, String fileType) throws MalformedURLException {
        this(new Options(url, fileType));
    }

    public GoogleCodeSitemapUrl(Options options) {
        super(options);
        this.fileType = options.fileType;
        this.license = options.license;
        this.fileName = options.fileName;
        this.packageUrl = options.packageUrl;
        this.packageMap = options.packageMap;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getLicense() {
        return this.license;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URL getPackageUrl() {
        return this.packageUrl;
    }

    public String getPackageMap() {
        return this.packageMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Options
    extends AbstractSitemapUrlOptions<GoogleCodeSitemapUrl, Options> {
        private String fileType;
        private String license;
        private String fileName;
        private URL packageUrl;
        private String packageMap;

        public Options(String url, FileType fileType) throws MalformedURLException {
            super(url, GoogleCodeSitemapUrl.class);
            this.fileType = fileType.toString();
        }

        public Options(URL url, FileType fileType) {
            super(url, GoogleCodeSitemapUrl.class);
            this.fileType = fileType.toString();
        }

        public Options(String url, String fileType) throws MalformedURLException {
            super(url, GoogleCodeSitemapUrl.class);
            this.fileType = fileType;
        }

        public Options(URL url, String fileType) {
            super(url, GoogleCodeSitemapUrl.class);
            this.fileType = fileType;
        }

        public Options license(License license) {
            this.license = license.toString();
            return this;
        }

        public Options license(String license) {
            this.license = license;
            return this;
        }

        public Options fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Options packageUrl(URL packageUrl) {
            this.packageUrl = packageUrl;
            return this;
        }

        public Options packageUrl(String packageUrl) throws MalformedURLException {
            this.packageUrl = new URL(packageUrl);
            return this;
        }

        public Options packageMap(String packageMap) {
            if (!FileType.ARCHIVE.toString().equals(this.fileType)) {
                throw new IllegalArgumentException("You can only specify a packageMap when the fileType is 'archive'");
            }
            this.packageMap = packageMap;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum License {
        ALADDIN("Aladdin Public License"),
        ARTISTIC("Artistic License"),
        APACHE("Apache License"),
        APPLE("Apple Public Source License"),
        BSD("BSD License"),
        CPL("Common Public License"),
        GPL("GNU General Public License"),
        LGPL("GNU Lesser General Public License"),
        DISCLAIMER("Historical Permission Notice and Disclaimer"),
        IBM("IBM Public License"),
        LUCENT("Lucent Public License"),
        MIT("MIT License"),
        MOZILLA("Mozilla Public License"),
        NASA("NASA Open Source Agreement"),
        PYTHON("Python Software Foundation License"),
        QPL("Q Public License"),
        SLEEPYCAT("Sleepycat License"),
        ZOPE("Zope Public License");

        private final String longName;

        private License(String longName) {
            this.longName = longName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        ARCHIVE("Archive"),
        ADA("Ada"),
        APPLESCRIPT("AppleScript"),
        ASP("ASP"),
        ASSEMBLY("Assembly"),
        AUTOCONF("Autoconf"),
        AUTOMAKE("Automake"),
        AWK("Awk"),
        BASIC("Basic/Visual Basic"),
        BAT("batch file"),
        C("C"),
        CPP("C++"),
        CSHARP("C#"),
        COBOL("COBOL"),
        COLDFUSION("ColdFusion"),
        CONFIGURE("configure script"),
        CPUDESCGCC("GCC machine description"),
        CPUDESCLCC("LCC machine description"),
        CPUDESCMONO("Mono machine description"),
        CPUDESCVCODE("VCODE machine description"),
        CSS("CSS"),
        CSV("CSV"),
        D("D"),
        EIFFEL("Eiffel"),
        ERLANG("Erlang"),
        FORTRAN("Fortran"),
        HASKELL("Haskell"),
        HTML("HTML"),
        JAVA("Java"),
        JAVASCRIPT("JavaScript"),
        JSP("JSP"),
        LEX("Lex"),
        LIMBO("Limbo"),
        LISP("Lisp"),
        LUA("Lua"),
        M4("m4"),
        MAKEFILE("Makefile"),
        MATHEMATICA("Mathematica"),
        MATLAB("Matlab"),
        MODULA2("Modula-2"),
        MODULA3("Modula-3"),
        OBJECTIVEC("Objective C"),
        OCAML("OCaml"),
        PASCAL("Pascal/Delphi"),
        PATCH("diff file"),
        PERL("Perl"),
        PHP("PHP"),
        POD("Plain Old Documentation"),
        MESSAGECATALOG("message catalog"),
        POSTSCRIPT("PostScript"),
        PROLOG("Prolog"),
        PYTHON("Python"),
        R("R"),
        REBOL("REBOL"),
        RUBY("Ruby"),
        SCHEME("Scheme"),
        SHELL("Shell"),
        SGML("SGML"),
        SMALLTALK("Smalltalk"),
        SQL("SQL"),
        SML("Standard ML"),
        SVG("SVG"),
        TCL("Tcl"),
        TEX("TeX/LaTeX"),
        TEXINFO("Texinfo"),
        TROFF("Troff"),
        VHDL("VHDL"),
        VIM("Vim script"),
        XML("XML"),
        XPM("XPM"),
        XSLT("XSLT"),
        XSUB("XSUB"),
        XUL("XUL"),
        YACC("Yacc");

        private final String longName;

        private FileType(String longName) {
            this.longName = longName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String toString() {
            if (this == CPP) {
                return "c++";
            }
            if (this == CSHARP) {
                return "c#";
            }
            return this.name().toLowerCase();
        }
    }
}

