/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.SitemapIndexUrl;
import com.redfin.sitemapgenerator.SitemapValidator;
import com.redfin.sitemapgenerator.UrlUtils;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitemapIndexGenerator {
    private final URL baseUrl;
    private final File outFile;
    private final ArrayList<SitemapIndexUrl> urls = new ArrayList();
    private final int maxUrls;
    private final W3CDateFormat dateFormat;
    private final Date defaultLastMod;
    private final boolean autoValidate;
    public static final int MAX_SITEMAPS_PER_INDEX = 50000;

    public SitemapIndexGenerator(URL baseUrl, File outFile) {
        this(new Options(baseUrl, outFile));
    }

    public SitemapIndexGenerator(String baseUrl, File outFile) throws MalformedURLException {
        this(new Options(baseUrl, outFile));
    }

    private SitemapIndexGenerator(Options options) {
        this.baseUrl = options.baseUrl;
        this.outFile = options.outFile;
        this.maxUrls = options.maxUrls;
        W3CDateFormat dateFormat = options.dateFormat;
        if (dateFormat == null) {
            dateFormat = new W3CDateFormat();
        }
        this.dateFormat = dateFormat;
        this.defaultLastMod = options.defaultLastMod;
        this.autoValidate = options.autoValidate;
    }

    public SitemapIndexGenerator addUrl(SitemapIndexUrl url) {
        UrlUtils.checkUrl(url.url, this.baseUrl);
        if (this.urls.size() >= this.maxUrls) {
            throw new RuntimeException("More than " + this.maxUrls + " urls");
        }
        this.urls.add(url);
        return this;
    }

    public SitemapIndexGenerator addUrls(Iterable<? extends SitemapIndexUrl> urls) {
        for (SitemapIndexUrl sitemapIndexUrl : urls) {
            this.addUrl(sitemapIndexUrl);
        }
        return this;
    }

    public SitemapIndexGenerator addUrls(SitemapIndexUrl ... urls) {
        for (SitemapIndexUrl url : urls) {
            this.addUrl(url);
        }
        return this;
    }

    public SitemapIndexGenerator addUrls(String ... urls) throws MalformedURLException {
        for (String url : urls) {
            this.addUrl(url);
        }
        return this;
    }

    public SitemapIndexGenerator addUrl(String url) throws MalformedURLException {
        return this.addUrl(new SitemapIndexUrl(url));
    }

    public SitemapIndexGenerator addUrls(URL ... urls) {
        for (URL url : urls) {
            this.addUrl(url);
        }
        return this;
    }

    public SitemapIndexGenerator addUrl(URL url) {
        return this.addUrl(new SitemapIndexUrl(url));
    }

    public SitemapIndexGenerator addUrl(URL url, Date lastMod) {
        return this.addUrl(new SitemapIndexUrl(url, lastMod));
    }

    public SitemapIndexGenerator addUrl(String url, Date lastMod) throws MalformedURLException {
        return this.addUrl(new SitemapIndexUrl(url, lastMod));
    }

    public SitemapIndexGenerator addUrls(String prefix, String suffix, int count) {
        if (count == 0) {
            try {
                this.addUrl(new URL(this.baseUrl, prefix + suffix));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                String fileName = prefix + i + suffix;
                try {
                    this.addUrl(new URL(this.baseUrl, fileName));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this;
    }

    public void write() {
        if (this.urls.size() == 0) {
            throw new RuntimeException("No URLs added, sitemap index would be empty; you must add some URLs with addUrls");
        }
        try {
            FileWriter out = new FileWriter(this.outFile);
            this.writeSiteMap(out);
            if (this.autoValidate) {
                SitemapValidator.validateSitemapIndex(this.outFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem writing sitemap index file " + this.outFile, e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Problem validating sitemap index file (bug?)", e);
        }
    }

    private void writeSiteMap(OutputStreamWriter out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n");
        for (SitemapIndexUrl url : this.urls) {
            out.write("  <sitemap>\n");
            out.write("    <loc>");
            out.write(UrlUtils.escapeXml(url.url.toString()));
            out.write("</loc>\n");
            Date lastMod = url.lastMod;
            if (lastMod == null) {
                lastMod = this.defaultLastMod;
            }
            if (lastMod != null) {
                out.write("    <lastmod>");
                out.write(this.dateFormat.format(lastMod));
                out.write("</lastmod>\n");
            }
            out.write("  </sitemap>\n");
        }
        out.write("</sitemapindex>");
        out.close();
    }

    public static class Options {
        private URL baseUrl;
        private File outFile;
        private W3CDateFormat dateFormat = null;
        private int maxUrls = 50000;
        private Date defaultLastMod = new Date();
        private boolean autoValidate = false;

        public Options(URL baseUrl, File outFile) {
            this.baseUrl = baseUrl;
            this.outFile = outFile;
        }

        public Options(String baseUrl, File outFile) throws MalformedURLException {
            this(new URL(baseUrl), outFile);
        }

        public Options dateFormat(W3CDateFormat dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        Options maxUrls(int maxUrls) {
            if (maxUrls > 50000) {
                throw new RuntimeException("You can't have more than 1000 sitemaps per index");
            }
            this.maxUrls = maxUrls;
            return this;
        }

        public Options defaultLastMod(Date defaultLastMod) {
            this.defaultLastMod = defaultLastMod;
            return this;
        }

        public Options autoValidate(boolean autoValidate) {
            this.autoValidate = autoValidate;
            return this;
        }

        public SitemapIndexGenerator build() {
            return new SitemapIndexGenerator(this);
        }
    }
}

