/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleCodeSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCodeSitemapGenerator
extends SitemapGenerator<GoogleCodeSitemapUrl, GoogleCodeSitemapGenerator> {
    GoogleCodeSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
    }

    public GoogleCodeSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleCodeSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleCodeSitemapGenerator(String baseUrl) throws MalformedURLException {
        this(new SitemapGeneratorOptions(new URL(baseUrl)));
    }

    public GoogleCodeSitemapGenerator(URL baseUrl) {
        this(new SitemapGeneratorOptions(baseUrl));
    }

    public static SitemapGeneratorBuilder<GoogleCodeSitemapGenerator> builder(URL baseUrl, File baseDir) {
        return new SitemapGeneratorBuilder<GoogleCodeSitemapGenerator>(baseUrl, baseDir, GoogleCodeSitemapGenerator.class);
    }

    public static SitemapGeneratorBuilder<GoogleCodeSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        return new SitemapGeneratorBuilder<GoogleCodeSitemapGenerator>(baseUrl, baseDir, GoogleCodeSitemapGenerator.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleCodeSitemapUrl>
    implements ISitemapUrlRenderer<GoogleCodeSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleCodeSitemapUrl> getUrlClass() {
            return GoogleCodeSitemapUrl.class;
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:codesearch=\"http://www.google.com/codesearch/schemas/sitemap/1.0\"";
        }

        @Override
        public void render(GoogleCodeSitemapUrl url, StringBuilder sb, W3CDateFormat dateFormat) {
            StringBuilder tagSb = new StringBuilder();
            tagSb.append("    <codesearch:codesearch>\n");
            this.renderTag(tagSb, "codesearch", "filetype", url.getFileType());
            this.renderTag(tagSb, "codesearch", "license", url.getLicense());
            this.renderTag(tagSb, "codesearch", "filename", url.getFileName());
            this.renderTag(tagSb, "codesearch", "packageurl", url.getPackageUrl());
            this.renderTag(tagSb, "codesearch", "packagemap", url.getPackageMap());
            tagSb.append("    </codesearch:codesearch>\n");
            super.render(url, sb, dateFormat, tagSb.toString());
        }
    }
}

