/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleImageSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.Image;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleImageSitemapGenerator
extends SitemapGenerator<GoogleImageSitemapUrl, GoogleImageSitemapGenerator> {
    GoogleImageSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
    }

    public GoogleImageSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleImageSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleImageSitemapGenerator(String baseUrl) throws MalformedURLException {
        this(new SitemapGeneratorOptions(new URL(baseUrl)));
    }

    public GoogleImageSitemapGenerator(URL baseUrl) {
        this(new SitemapGeneratorOptions(baseUrl));
    }

    public static SitemapGeneratorBuilder<GoogleImageSitemapGenerator> builder(URL baseUrl, File baseDir) {
        return new SitemapGeneratorBuilder<GoogleImageSitemapGenerator>(baseUrl, baseDir, GoogleImageSitemapGenerator.class);
    }

    public static SitemapGeneratorBuilder<GoogleImageSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        return new SitemapGeneratorBuilder<GoogleImageSitemapGenerator>(baseUrl, baseDir, GoogleImageSitemapGenerator.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleImageSitemapUrl>
    implements ISitemapUrlRenderer<GoogleImageSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleImageSitemapUrl> getUrlClass() {
            return GoogleImageSitemapUrl.class;
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\"";
        }

        @Override
        public void render(GoogleImageSitemapUrl url, StringBuilder sb, W3CDateFormat dateFormat) {
            StringBuilder tagSb = new StringBuilder();
            for (Image image : url.getImages()) {
                tagSb.append("    <image:image>\n");
                this.renderTag(tagSb, "image", "loc", image.getUrl());
                this.renderTag(tagSb, "image", "caption", image.getCaption());
                this.renderTag(tagSb, "image", "title", image.getTitle());
                this.renderTag(tagSb, "image", "geo_location", image.getGeoLocation());
                this.renderTag(tagSb, "image", "license", image.getLicense());
                tagSb.append("    </image:image>\n");
            }
            super.render(url, sb, dateFormat, tagSb.toString());
        }
    }
}

