/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleVideoSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleVideoSitemapGenerator
extends SitemapGenerator<GoogleVideoSitemapUrl, GoogleVideoSitemapGenerator> {
    public static SitemapGeneratorBuilder<GoogleVideoSitemapGenerator> builder(URL baseUrl, File baseDir) {
        return new SitemapGeneratorBuilder<GoogleVideoSitemapGenerator>(baseUrl, baseDir, GoogleVideoSitemapGenerator.class);
    }

    public static SitemapGeneratorBuilder<GoogleVideoSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        return new SitemapGeneratorBuilder<GoogleVideoSitemapGenerator>(baseUrl, baseDir, GoogleVideoSitemapGenerator.class);
    }

    GoogleVideoSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
    }

    public GoogleVideoSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleVideoSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleVideoSitemapGenerator(String baseUrl) throws MalformedURLException {
        this(new SitemapGeneratorOptions(new URL(baseUrl)));
    }

    public GoogleVideoSitemapGenerator(URL baseUrl) {
        this(new SitemapGeneratorOptions(baseUrl));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleVideoSitemapUrl>
    implements ISitemapUrlRenderer<GoogleVideoSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleVideoSitemapUrl> getUrlClass() {
            return GoogleVideoSitemapUrl.class;
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:video=\"http://www.google.com/schemas/sitemap-video/1.1\"";
        }

        @Override
        public void render(GoogleVideoSitemapUrl url, StringBuilder sb, W3CDateFormat dateFormat) {
            StringBuilder tagSb = new StringBuilder();
            tagSb.append("    <video:video>\n");
            this.renderTag(tagSb, "video", "content_loc", url.getContentUrl());
            if (url.getPlayerUrl() != null) {
                tagSb.append("      <video:player_loc allow_embed=\"");
                tagSb.append(url.getAllowEmbed());
                tagSb.append("\">");
                tagSb.append(url.getPlayerUrl());
                tagSb.append("</video:player_loc>\n");
            }
            this.renderTag(tagSb, "video", "thumbnail_loc", url.getThumbnailUrl());
            this.renderTag(tagSb, "video", "title", url.getTitle());
            this.renderTag(tagSb, "video", "description", url.getDescription());
            this.renderTag(tagSb, "video", "rating", url.getRating());
            this.renderTag(tagSb, "video", "view_count", url.getViewCount());
            if (url.getPublicationDate() != null) {
                this.renderTag(tagSb, "video", "publication_date", dateFormat.format(url.getPublicationDate()));
            }
            if (url.getTags() != null) {
                for (String tag : url.getTags()) {
                    this.renderTag(tagSb, "video", "tag", tag);
                }
            }
            this.renderTag(tagSb, "video", "category", url.getCategory());
            this.renderTag(tagSb, "video", "family_friendly", url.getFamilyFriendly());
            this.renderTag(tagSb, "video", "duration", url.getDurationInSeconds());
            tagSb.append("    </video:video>\n");
            super.render(url, sb, dateFormat, tagSb.toString());
        }
    }
}

