/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Paragraph;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.VerticalAlignment;
import be.quodlibet.boxable.line.LineStyle;
import be.quodlibet.boxable.text.WrappingFunction;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class Cell<T extends PDPage> {
    private float width;
    private Float height;
    private String text;
    private PDFont font = PDType1Font.HELVETICA;
    private PDFont fontBold = PDType1Font.HELVETICA_BOLD;
    private float fontSize = 8.0f;
    private Color fillColor;
    private Color textColor = Color.BLACK;
    private final Row<T> row;
    private WrappingFunction wrappingFunction;
    private boolean isHeaderCell = false;
    private float leftPadding = 5.0f;
    private float rightPadding = 5.0f;
    private float topPadding = 5.0f;
    private float bottomPadding = 5.0f;
    private LineStyle leftBorderStyle = new LineStyle(Color.BLACK, 1.0f);
    private LineStyle rightBorderStyle = new LineStyle(Color.BLACK, 1.0f);
    private LineStyle topBorderStyle = new LineStyle(Color.BLACK, 1.0f);
    private LineStyle bottomBorderStyle = new LineStyle(Color.BLACK, 1.0f);
    private Paragraph paragraph = null;
    private boolean textRotated = false;
    private final HorizontalAlignment align;
    private final VerticalAlignment valign;
    float horizontalFreeSpace = 0.0f;
    float verticalFreeSpace = 0.0f;

    Cell(Row<T> row, float width, String text, boolean isCalculated) {
        this(row, width, text, isCalculated, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    Cell(Row<T> row, float width, String text, boolean isCalculated, HorizontalAlignment align, VerticalAlignment valign) {
        this.row = row;
        if (isCalculated) {
            double calclulatedWidth = row.getWidth() * width / 100.0f;
            this.width = (float)calclulatedWidth;
        } else {
            this.width = width;
        }
        if (this.getWidth() > row.getWidth()) {
            throw new IllegalArgumentException("Cell Width=" + this.getWidth() + " can't be bigger than row width=" + row.getWidth());
        }
        this.text = text == null ? "" : text;
        this.align = align;
        this.valign = valign;
        this.wrappingFunction = null;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public float getWidth() {
        return this.width;
    }

    public float getInnerWidth() {
        return this.getWidth() - this.getLeftPadding() - this.getRightPadding() - (this.leftBorderStyle == null ? 0.0f : this.leftBorderStyle.getWidth()) - (this.rightBorderStyle == null ? 0.0f : this.rightBorderStyle.getWidth());
    }

    public float getInnerHeight() {
        return this.getHeight() - this.getBottomPadding() - this.getTopPadding() - (this.topBorderStyle == null ? 0.0f : this.topBorderStyle.getWidth()) - (this.bottomBorderStyle == null ? 0.0f : this.bottomBorderStyle.getWidth());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.paragraph = null;
    }

    public PDFont getFont() {
        if (this.font == null) {
            throw new IllegalArgumentException("Font not set.");
        }
        if (this.isHeaderCell) {
            return this.fontBold;
        }
        return this.font;
    }

    public void setFont(PDFont font) {
        this.font = font;
        this.paragraph = null;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
        this.paragraph = null;
    }

    public Paragraph getParagraph() {
        if (this.paragraph == null) {
            this.paragraph = this.isHeaderCell ? (this.isTextRotated() ? new Paragraph(this.text, this.fontBold, this.fontSize, this.getInnerHeight(), this.align, this.textColor, null, this.wrappingFunction) : new Paragraph(this.text, this.fontBold, this.fontSize, this.getInnerWidth(), this.align, this.textColor, null, this.wrappingFunction)) : (this.isTextRotated() ? new Paragraph(this.text, this.font, this.fontSize, this.getInnerHeight(), this.align, this.textColor, null, this.wrappingFunction) : new Paragraph(this.text, this.font, this.fontSize, this.getInnerWidth(), this.align, this.textColor, null, this.wrappingFunction));
        }
        return this.paragraph;
    }

    public float getExtraWidth() {
        return this.row.getLastCellExtraWidth() + this.getWidth();
    }

    public float getHeight() {
        return this.row.getHeight();
    }

    public float getCellHeight() {
        if (this.height != null) {
            return this.height.floatValue();
        }
        if (this.isTextRotated()) {
            try {
                return this.getFont().getStringWidth(this.getText()) / 1000.0f * this.getFontSize() + this.getTopPadding() + (this.getTopBorder() == null ? 0.0f : this.getTopBorder().getWidth()) + this.getBottomPadding() + (this.getBottomBorder() == null ? 0.0f : this.getBottomBorder().getWidth());
            }
            catch (IOException e) {
                throw new IllegalStateException("Font not set.", e);
            }
        }
        return this.getTextHeight() + this.getTopPadding() + this.getBottomPadding() + (this.getTopBorder() == null ? 0.0f : this.getTopBorder().getWidth()) + (this.getBottomBorder() == null ? 0.0f : this.getBottomBorder().getWidth());
    }

    public void setHeight(Float height) {
        this.height = height;
    }

    public float getTextHeight() {
        return this.getParagraph().getHeight();
    }

    public float getTextWidth() {
        return this.getParagraph().getWidth();
    }

    public float getLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(float cellLeftPadding) {
        this.leftPadding = cellLeftPadding;
        this.paragraph = null;
    }

    public float getRightPadding() {
        return this.rightPadding;
    }

    public void setRightPadding(float cellRightPadding) {
        this.rightPadding = cellRightPadding;
        this.paragraph = null;
    }

    public float getTopPadding() {
        return this.topPadding;
    }

    public void setTopPadding(float cellTopPadding) {
        this.topPadding = cellTopPadding;
    }

    public float getBottomPadding() {
        return this.bottomPadding;
    }

    public void setBottomPadding(float cellBottomPadding) {
        this.bottomPadding = cellBottomPadding;
    }

    public float getVerticalFreeSpace() {
        if (this.isTextRotated()) {
            float tw = 0.0f;
            try {
                for (String line : this.getParagraph().getLines()) {
                    tw = Math.max(tw, this.getFont().getStringWidth(line.trim()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            tw = tw / 1000.0f * this.getFontSize();
            return this.getInnerHeight() - tw;
        }
        return this.getInnerHeight() - this.getTextHeight();
    }

    public float getHorizontalFreeSpace() {
        float tw = 0.0f;
        try {
            for (String line : this.getParagraph().getLines()) {
                tw = Math.max(tw, this.getFont().getStringWidth(line.trim()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tw = tw / 1000.0f * this.getFontSize();
        if (this.isTextRotated()) {
            return this.getInnerWidth() - this.getTextHeight();
        }
        return this.getInnerWidth() - tw;
    }

    public HorizontalAlignment getAlign() {
        return this.align;
    }

    public VerticalAlignment getValign() {
        return this.valign;
    }

    public boolean isHeaderCell() {
        return this.isHeaderCell;
    }

    public void setHeaderCell(boolean isHeaderCell) {
        this.isHeaderCell = isHeaderCell;
    }

    public WrappingFunction getWrappingFunction() {
        return this.getParagraph().getWrappingFunction();
    }

    public void setWrappingFunction(WrappingFunction wrappingFunction) {
        this.wrappingFunction = wrappingFunction;
        this.paragraph = null;
    }

    public LineStyle getLeftBorder() {
        return this.leftBorderStyle;
    }

    public LineStyle getRightBorder() {
        return this.rightBorderStyle;
    }

    public LineStyle getTopBorder() {
        return this.topBorderStyle;
    }

    public LineStyle getBottomBorder() {
        return this.bottomBorderStyle;
    }

    public void setLeftBorderStyle(LineStyle leftBorder) {
        this.leftBorderStyle = leftBorder;
    }

    public void setRightBorderStyle(LineStyle rightBorder) {
        this.rightBorderStyle = rightBorder;
    }

    public void setTopBorderStyle(LineStyle topBorder) {
        this.topBorderStyle = topBorder;
    }

    public void setBottomBorderStyle(LineStyle bottomBorder) {
        this.bottomBorderStyle = bottomBorder;
    }

    public void setBorderStyle(LineStyle border) {
        this.leftBorderStyle = border;
        this.rightBorderStyle = border;
        this.topBorderStyle = border;
        this.bottomBorderStyle = border;
    }

    public boolean isTextRotated() {
        return this.textRotated;
    }

    public void setTextRotated(boolean textRotated) {
        this.textRotated = textRotated;
    }

    public PDFont getFontBold() {
        return this.fontBold;
    }

    public void setFontBold(PDFont fontBold) {
        this.fontBold = fontBold;
    }
}

