/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.TextType;
import be.quodlibet.boxable.text.WrappingFunction;
import be.quodlibet.boxable.utils.FontUtils;
import be.quodlibet.boxable.utils.PDStreamUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class Paragraph {
    private float width = 500.0f;
    private String text;
    private float fontSize;
    private PDFont font;
    private final WrappingFunction wrappingFunction;
    private HorizontalAlignment align;
    private TextType textType;
    private Color color;
    private boolean drawDebug;
    private static final WrappingFunction DEFAULT_WRAP_FUNC = new WrappingFunction(){

        @Override
        public String[] getLines(String t) {
            return t.split("(?<=\\s|-|@|,|\\.|:|;)");
        }
    };

    public Paragraph(String text, PDFont font, float fontSize, float width, HorizontalAlignment align) {
        this(text, font, fontSize, width, align, null);
    }

    public Paragraph(String text, PDFont font, int fontSize, int width) {
        this(text, font, fontSize, width, HorizontalAlignment.LEFT, null);
    }

    public Paragraph(String text, PDFont font, float fontSize, float width, HorizontalAlignment align, WrappingFunction wrappingFunction) {
        this(text, font, fontSize, width, align, Color.BLACK, null, wrappingFunction);
    }

    public Paragraph(String text, PDFont font, float fontSize, float width, HorizontalAlignment align, Color color, TextType textType, WrappingFunction wrappingFunction) {
        this.color = color;
        this.text = text;
        this.font = font;
        this.fontSize = fontSize;
        this.width = width;
        this.textType = textType;
        this.setAlign(align);
        this.wrappingFunction = wrappingFunction == null ? DEFAULT_WRAP_FUNC : wrappingFunction;
    }

    public List<String> getLines() {
        ArrayList<String> result = new ArrayList<String>();
        String[] split = this.wrappingFunction.getLines(this.text);
        int[] possibleWrapPoints = new int[split.length];
        possibleWrapPoints[0] = split[0].length();
        for (int i = 1; i < split.length; ++i) {
            possibleWrapPoints[i] = possibleWrapPoints[i - 1] + split[i].length();
        }
        int start = 0;
        int end = 0;
        for (int i : possibleWrapPoints) {
            float width = 0.0f;
            try {
                width = this.font.getStringWidth(this.text.substring(start, i)) / 1000.0f * this.fontSize;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            if (start < end && width > this.width) {
                result.add(this.text.substring(start, end));
                start = end;
            }
            end = i;
        }
        result.add(this.text.substring(start));
        return result;
    }

    public float write(PDPageContentStream stream, float cursorX, float cursorY) {
        if (this.drawDebug) {
            PDStreamUtils.rectFontMetrics(stream, cursorX, cursorY, this.font, this.fontSize);
            PDStreamUtils.rect(stream, cursorX, cursorY, this.width, 1.0f, Color.RED);
        }
        for (String line : this.getLines()) {
            line = line.trim();
            float textX = cursorX;
            switch (this.align) {
                case CENTER: {
                    textX += this.getHorizontalFreeSpace(line) / 2.0f;
                    break;
                }
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    textX += this.getHorizontalFreeSpace(line);
                }
            }
            PDStreamUtils.write(stream, line, this.font, this.fontSize, textX, cursorY, this.color);
            if (this.textType != null) {
                switch (this.textType) {
                    case HIGHLIGHT: 
                    case SQUIGGLY: 
                    case STRIKEOUT: {
                        throw new UnsupportedOperationException("Not implemented.");
                    }
                    case UNDERLINE: {
                        float y = (float)((double)(cursorY - FontUtils.getHeight(this.font, this.fontSize) - FontUtils.getDescent(this.font, this.fontSize)) - 1.5);
                        try {
                            float titleWidth = this.font.getStringWidth(line) / 1000.0f * this.fontSize;
                            stream.moveTo(textX, y);
                            stream.lineTo(textX + titleWidth, y);
                            stream.stroke();
                            break;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Unable to underline text", e);
                        }
                    }
                }
            }
            cursorY -= this.getFontHeight();
        }
        return cursorY;
    }

    public float getHeight() {
        return (float)this.getLines().size() * this.getFontHeight();
    }

    public float getFontHeight() {
        return FontUtils.getHeight(this.font, this.fontSize);
    }

    @Deprecated
    public float getFontWidth() {
        return this.font.getFontDescriptor().getFontBoundingBox().getWidth() / 1000.0f * this.fontSize;
    }

    @Deprecated
    public Paragraph withWidth(int width) {
        this.width = width;
        return this;
    }

    @Deprecated
    public Paragraph withFont(PDFont font, int fontSize) {
        this.font = font;
        this.fontSize = fontSize;
        return this;
    }

    @Deprecated
    public Paragraph withColor(int color) {
        this.color = new Color(color);
        return this;
    }

    @Deprecated
    public int getColor() {
        return this.color.getRGB();
    }

    private float getHorizontalFreeSpace(String text) {
        try {
            float tw = this.font.getStringWidth(text.trim()) / 1000.0f * this.fontSize;
            return this.width - tw;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to calculate text width", e);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public String getText() {
        return this.text;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public PDFont getFont() {
        return this.font;
    }

    public HorizontalAlignment getAlign() {
        return this.align;
    }

    public void setAlign(HorizontalAlignment align) {
        this.align = align;
    }

    public boolean isDrawDebug() {
        return this.drawDebug;
    }

    public void setDrawDebug(boolean drawDebug) {
        this.drawDebug = drawDebug;
    }

    public WrappingFunction getWrappingFunction() {
        return this.wrappingFunction;
    }
}

