/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.ImageCell;
import be.quodlibet.boxable.Paragraph;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.line.LineStyle;
import be.quodlibet.boxable.page.PageProvider;
import be.quodlibet.boxable.text.WrappingFunction;
import be.quodlibet.boxable.utils.FontUtils;
import be.quodlibet.boxable.utils.PDStreamUtils;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.util.Matrix;

public abstract class Table<T extends PDPage> {
    public final PDDocument document;
    private float margin;
    private T currentPage;
    private PDPageContentStream tableContentStream;
    private List<PDOutlineItem> bookmarks;
    private List<Row<T>> header = new ArrayList<Row<T>>();
    private boolean removeTopBorders = false;
    private List<Row<T>> rows = new ArrayList<Row<T>>();
    private final float yStartNewPage;
    private float yStart;
    private final float width;
    private final boolean drawLines;
    private final boolean drawContent;
    private float headerBottomMargin = 4.0f;
    private boolean tableIsBroken = false;
    private PageProvider<T> pageProvider;
    private final float pageTopMargin;
    private final float pageBottomMargin;
    private boolean drawDebug;

    @Deprecated
    public Table(float yStart, float yStartNewPage, float pageBottomMargin, float width, float margin, PDDocument document, T currentPage, boolean drawLines, boolean drawContent) throws IOException {
        this(yStart, yStartNewPage, 0.0f, pageBottomMargin, width, margin, document, currentPage, drawLines, drawContent, null);
    }

    @Deprecated
    public Table(float yStartNewPage, float pageBottomMargin, float width, float margin, PDDocument document, boolean drawLines, boolean drawContent) throws IOException {
        this(yStartNewPage, 0.0f, pageBottomMargin, width, margin, document, drawLines, drawContent, null);
    }

    public Table(float yStart, float yStartNewPage, float pageTopMargin, float pageBottomMargin, float width, float margin, PDDocument document, T currentPage, boolean drawLines, boolean drawContent, PageProvider<T> pageProvider) throws IOException {
        this.pageTopMargin = pageTopMargin;
        this.document = document;
        this.drawLines = drawLines;
        this.drawContent = drawContent;
        this.yStartNewPage = yStartNewPage;
        this.margin = margin;
        this.width = width;
        this.yStart = yStart;
        this.pageBottomMargin = pageBottomMargin;
        this.currentPage = currentPage;
        this.pageProvider = pageProvider;
        this.loadFonts();
    }

    public Table(float yStartNewPage, float pageTopMargin, float pageBottomMargin, float width, float margin, PDDocument document, boolean drawLines, boolean drawContent, PageProvider<T> pageProvider) throws IOException {
        this.pageTopMargin = pageTopMargin;
        this.document = document;
        this.drawLines = drawLines;
        this.drawContent = drawContent;
        this.yStartNewPage = yStartNewPage;
        this.margin = margin;
        this.width = width;
        this.pageProvider = pageProvider;
        this.pageBottomMargin = pageBottomMargin;
        this.loadFonts();
        this.currentPage = pageProvider.createPage();
    }

    protected abstract void loadFonts() throws IOException;

    protected PDType0Font loadFont(String fontPath) throws IOException {
        return FontUtils.loadFont(this.getDocument(), fontPath);
    }

    protected PDDocument getDocument() {
        return this.document;
    }

    public void drawTitle(String title, PDFont font, int fontSize, float tableWidth, float height, String alignment, float freeSpaceForPageBreak, boolean drawHeaderMargin) throws IOException {
        this.drawTitle(title, font, fontSize, tableWidth, height, alignment, freeSpaceForPageBreak, null, drawHeaderMargin);
    }

    public void drawTitle(String title, PDFont font, int fontSize, float tableWidth, float height, String alignment, float freeSpaceForPageBreak, WrappingFunction wrappingFunction, boolean drawHeaderMargin) throws IOException {
        this.ensureStreamIsOpen();
        if (this.isEndOfPage(freeSpaceForPageBreak)) {
            this.tableContentStream.close();
            this.pageBreak();
        }
        if (title == null) {
            this.yStart -= height;
        } else {
            PDPageContentStream articleTitle = this.createPdPageContentStream();
            Paragraph paragraph = new Paragraph(title, font, fontSize, tableWidth, HorizontalAlignment.get(alignment), wrappingFunction);
            paragraph.setDrawDebug(this.drawDebug);
            this.yStart = paragraph.write(articleTitle, this.margin, this.yStart);
            if (paragraph.getHeight() < height) {
                this.yStart -= height - paragraph.getHeight();
            }
            articleTitle.close();
            if (this.drawDebug) {
                PDStreamUtils.rect(this.tableContentStream, this.margin, this.yStart, this.width, this.headerBottomMargin, Color.CYAN);
            }
        }
        if (drawHeaderMargin) {
            this.yStart -= this.headerBottomMargin;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public Row<T> createRow(float height) {
        Row row = new Row(this, height);
        this.rows.add(row);
        return row;
    }

    public Row<T> createRow(List<Cell<T>> cells, float height) {
        Row<T> row = new Row<T>(this, cells, height);
        this.rows.add(row);
        return row;
    }

    public float draw() throws IOException {
        this.ensureStreamIsOpen();
        for (Row<T> row : this.rows) {
            if (this.header.contains(row) && this.isEndOfPage(this.getMinimumHeight())) {
                this.pageBreak();
            }
            this.drawRow(row);
        }
        this.endTable();
        return this.yStart;
    }

    private void drawRow(Row<T> row) throws IOException {
        if (row.getBookmark() != null) {
            PDPageXYZDestination bookmarkDestination = new PDPageXYZDestination();
            bookmarkDestination.setPage(this.currentPage);
            bookmarkDestination.setTop((int)this.yStart);
            row.getBookmark().setDestination((PDDestination)bookmarkDestination);
            this.addBookmark(row.getBookmark());
        }
        this.removeTopBorders = true;
        if (this.isEndOfPage(row)) {
            this.endTable();
            this.pageBreak();
            if (!this.header.isEmpty()) {
                for (Row<T> headerRow : this.header) {
                    this.drawRow(headerRow);
                }
                this.removeTopBorders = true;
            } else {
                this.removeTopBorders = false;
            }
        }
        if (row == this.rows.get(0)) {
            this.removeTopBorders = false;
        }
        if (this.removeTopBorders) {
            row.removeTopBorders();
        }
        if (this.drawLines) {
            this.drawVerticalLines(row);
        }
        if (this.drawContent) {
            this.drawCellContent(row);
        }
    }

    private T createNewPage() {
        if (this.pageProvider != null) {
            return this.pageProvider.createPage();
        }
        return this.createPage();
    }

    @Deprecated
    protected T createPage() {
        throw new IllegalStateException("You either have to provide a " + PageProvider.class.getCanonicalName() + " or override this method");
    }

    private PDPageContentStream createPdPageContentStream() throws IOException {
        return new PDPageContentStream(this.getDocument(), this.getCurrentPage(), true, true);
    }

    private void drawCellContent(Row<T> row) throws IOException {
        float cursorX = this.margin;
        for (Cell<T> cell : row.getCells()) {
            float cursorY;
            float cellStartX = cursorX;
            if (cell instanceof ImageCell) {
                ImageCell imageCell = (ImageCell)cell;
                cursorY = this.yStart - cell.getTopPadding() - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth());
                switch (cell.getValign()) {
                    case TOP: {
                        break;
                    }
                    case MIDDLE: {
                        cursorY -= cell.getVerticalFreeSpace() / 2.0f;
                        break;
                    }
                    case BOTTOM: {
                        cursorY -= cell.getVerticalFreeSpace();
                    }
                }
                cursorX += cell.getLeftPadding() + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth());
                switch (cell.getAlign()) {
                    case CENTER: {
                        cursorX += cell.getHorizontalFreeSpace() / 2.0f;
                        break;
                    }
                    case LEFT: {
                        break;
                    }
                    case RIGHT: {
                        cursorX += cell.getHorizontalFreeSpace();
                    }
                }
                imageCell.getImage().draw(this.document, this.tableContentStream, cursorX, cursorY);
            } else {
                if (cell.getFont() == null) {
                    throw new IllegalArgumentException("Font is null on Cell=" + cell.getText());
                }
                this.tableContentStream.setFont(cell.getFont(), cell.getFontSize());
                if (cell.isTextRotated()) {
                    cursorY = this.yStart - cell.getInnerHeight() - cell.getTopPadding() - (cell.getTopBorder() != null ? cell.getTopBorder().getWidth() : 0.0f);
                    switch (cell.getAlign()) {
                        case CENTER: {
                            cursorY += cell.getVerticalFreeSpace() / 2.0f;
                            break;
                        }
                        case LEFT: {
                            break;
                        }
                        case RIGHT: {
                            cursorY += cell.getVerticalFreeSpace();
                        }
                    }
                    cursorX += cell.getLeftPadding() + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()) + FontUtils.getHeight(cell.getFont(), cell.getFontSize()) + FontUtils.getDescent(cell.getFont(), cell.getFontSize());
                    switch (cell.getValign()) {
                        case TOP: {
                            break;
                        }
                        case MIDDLE: {
                            cursorX += cell.getHorizontalFreeSpace() / 2.0f;
                            break;
                        }
                        case BOTTOM: {
                            cursorX += cell.getHorizontalFreeSpace();
                        }
                    }
                } else {
                    cursorY = this.yStart - cell.getTopPadding() - FontUtils.getHeight(cell.getFont(), cell.getFontSize()) - FontUtils.getDescent(cell.getFont(), cell.getFontSize()) - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth());
                    cursorX += cell.getLeftPadding() + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth());
                    switch (cell.getAlign()) {
                        case CENTER: {
                            cursorX += cell.getHorizontalFreeSpace() / 2.0f;
                            break;
                        }
                        case LEFT: {
                            break;
                        }
                        case RIGHT: {
                            cursorX += cell.getHorizontalFreeSpace();
                        }
                    }
                    switch (cell.getValign()) {
                        case TOP: {
                            break;
                        }
                        case MIDDLE: {
                            cursorY -= cell.getVerticalFreeSpace() / 2.0f;
                            break;
                        }
                        case BOTTOM: {
                            cursorY -= cell.getVerticalFreeSpace();
                        }
                    }
                }
                float lineStartX = cursorX;
                float lineStartY = cursorY;
                this.tableContentStream.setNonStrokingColor(cell.getTextColor());
                float tw = 0.0f;
                for (String line : cell.getParagraph().getLines()) {
                    float freeSpaceWithinLine;
                    line = line.trim();
                    tw = Math.max(tw, cell.getFont().getStringWidth(line));
                    tw = tw / 1000.0f * cell.getFontSize();
                    if (cell.isTextRotated()) {
                        cursorY = lineStartY;
                        freeSpaceWithinLine = cell.getInnerHeight() - cell.getVerticalFreeSpace() - tw;
                        switch (cell.getAlign()) {
                            case CENTER: {
                                cursorY += freeSpaceWithinLine / 2.0f;
                                break;
                            }
                            case LEFT: {
                                break;
                            }
                            case RIGHT: {
                                cursorY += freeSpaceWithinLine;
                            }
                        }
                    } else {
                        cursorX = lineStartX;
                        freeSpaceWithinLine = cell.getInnerWidth() - cell.getHorizontalFreeSpace() - tw;
                        switch (cell.getAlign()) {
                            case CENTER: {
                                cursorX += freeSpaceWithinLine / 2.0f;
                                break;
                            }
                            case LEFT: {
                                break;
                            }
                            case RIGHT: {
                                cursorX += freeSpaceWithinLine;
                            }
                        }
                    }
                    this.tableContentStream.beginText();
                    if (cell.isTextRotated()) {
                        AffineTransform transform = AffineTransform.getTranslateInstance(cursorX, cursorY);
                        transform.concatenate(AffineTransform.getRotateInstance(1.5707963267948966));
                        transform.concatenate(AffineTransform.getTranslateInstance(-cursorX, -cursorY));
                        this.tableContentStream.setTextMatrix(new Matrix(transform));
                        this.tableContentStream.newLineAtOffset(cursorX, cursorY);
                        this.tableContentStream.setFont(cell.getFont(), cell.getFontSize());
                        this.tableContentStream.showText(line);
                    } else {
                        this.tableContentStream.newLineAtOffset(cursorX, cursorY);
                        this.tableContentStream.showText(line);
                    }
                    this.tableContentStream.endText();
                    this.tableContentStream.closePath();
                    if (cell.isTextRotated()) {
                        cursorX += cell.getParagraph().getFontHeight();
                        continue;
                    }
                    cursorY -= cell.getParagraph().getFontHeight();
                }
            }
            cursorX = cellStartX + cell.getWidth();
        }
        this.yStart -= row.getHeight();
    }

    private void drawVerticalLines(Row<T> row) throws IOException {
        float xStart = this.margin;
        float xEnd = row.xEnd();
        Iterator<Cell<T>> cellIterator = row.getCells().iterator();
        while (cellIterator.hasNext()) {
            Cell<T> cell = cellIterator.next();
            this.fillCellColor(cell, this.yStart, xStart, cellIterator);
            this.drawCellBorders(row, cell, xStart, xEnd);
            xStart += this.getWidth(cell, cellIterator);
        }
    }

    private void drawCellBorders(Row<T> row, Cell<T> cell, float xStart, float xEnd) throws IOException {
        LineStyle leftBorder;
        LineStyle bottomBorder;
        LineStyle rightBorder;
        float yEnd = this.yStart - row.getHeight();
        LineStyle topBorder = cell.getTopBorder();
        if (topBorder != null) {
            float y = this.yStart - topBorder.getWidth() / 2.0f;
            this.drawLine(xStart, y, xStart + cell.getWidth(), y, topBorder);
        }
        if ((rightBorder = cell.getRightBorder()) != null) {
            float x = xStart + cell.getWidth() - rightBorder.getWidth() / 2.0f;
            this.drawLine(x, this.yStart - (topBorder == null ? 0.0f : topBorder.getWidth()), x, yEnd, rightBorder);
        }
        if ((bottomBorder = cell.getBottomBorder()) != null) {
            float y = yEnd + bottomBorder.getWidth() / 2.0f;
            this.drawLine(xStart, y, xStart + cell.getWidth() - (rightBorder == null ? 0.0f : rightBorder.getWidth()), y, bottomBorder);
        }
        if ((leftBorder = cell.getLeftBorder()) != null) {
            float x = xStart + leftBorder.getWidth() / 2.0f;
            this.drawLine(x, this.yStart, x, yEnd + (bottomBorder == null ? 0.0f : bottomBorder.getWidth()), leftBorder);
        }
    }

    private void drawLine(float xStart, float yStart, float xEnd, float yEnd, LineStyle border) throws IOException {
        PDStreamUtils.setLineStyles(this.tableContentStream, border);
        this.tableContentStream.moveTo(xStart, yStart);
        this.tableContentStream.lineTo(xEnd, yEnd);
        this.tableContentStream.stroke();
        this.tableContentStream.closePath();
    }

    private void fillCellColor(Cell<T> cell, float yStart, float xStart, Iterator<Cell<T>> cellIterator) throws IOException {
        if (cell.getFillColor() != null) {
            this.tableContentStream.setNonStrokingColor(cell.getFillColor());
            float height = cell.getHeight() - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth());
            float cellWidth = this.getWidth(cell, cellIterator);
            this.tableContentStream.addRect(xStart, yStart -= cell.getHeight(), cellWidth, height);
            this.tableContentStream.fill();
            this.tableContentStream.closePath();
            this.tableContentStream.setNonStrokingColor(Color.BLACK);
        }
    }

    private float getWidth(Cell<T> cell, Iterator<Cell<T>> cellIterator) {
        float width = cellIterator.hasNext() ? cell.getWidth() : cell.getExtraWidth();
        return width;
    }

    private void ensureStreamIsOpen() throws IOException {
        if (this.tableContentStream == null) {
            this.tableContentStream = this.createPdPageContentStream();
        }
    }

    private void endTable() throws IOException {
        this.tableContentStream.close();
    }

    public T getCurrentPage() {
        Preconditions.checkNotNull(this.currentPage, (Object)"No current page defined.");
        return this.currentPage;
    }

    private boolean isEndOfPage(Row<T> row) {
        boolean isEndOfPage;
        float currentY = this.yStart - row.getHeight();
        boolean bl = isEndOfPage = currentY <= this.pageBottomMargin;
        if (isEndOfPage) {
            this.setTableIsBroken(true);
        }
        return isEndOfPage;
    }

    private boolean isEndOfPage(float freeSpaceForPageBreak) {
        boolean isEndOfPage;
        float currentY = this.yStart - freeSpaceForPageBreak;
        boolean bl = isEndOfPage = currentY <= this.pageBottomMargin;
        if (isEndOfPage) {
            this.setTableIsBroken(true);
        }
        return isEndOfPage;
    }

    private void pageBreak() throws IOException {
        this.tableContentStream.close();
        this.yStart = this.yStartNewPage - this.pageTopMargin;
        this.currentPage = this.createNewPage();
        this.tableContentStream = this.createPdPageContentStream();
    }

    private void addBookmark(PDOutlineItem bookmark) {
        if (this.bookmarks == null) {
            this.bookmarks = new ArrayList<PDOutlineItem>();
        }
        this.bookmarks.add(bookmark);
    }

    public List<PDOutlineItem> getBookmarks() {
        return this.bookmarks;
    }

    @Deprecated
    public void setHeader(Row<T> header) {
        this.header.clear();
        this.addHeaderRow(header);
    }

    public float getHeaderAndDataHeight() {
        float height = 0.0f;
        for (Row<T> row : this.rows) {
            height += row.getHeight();
        }
        return height;
    }

    public float getMinimumHeight() {
        float height = 0.0f;
        int firstDataRowIndex = 0;
        if (!this.header.isEmpty()) {
            for (Row<T> headerRow : this.header) {
                height += headerRow.getHeight();
                ++firstDataRowIndex;
            }
        }
        if (this.rows.size() > firstDataRowIndex) {
            height += this.rows.get(firstDataRowIndex).getHeight();
        }
        return height;
    }

    public void addHeaderRow(Row<T> row) {
        this.header.add(row);
        row.setHeaderRow(true);
    }

    public Row<T> getHeader() {
        if (this.header == null) {
            throw new IllegalArgumentException("Header Row not set on table");
        }
        return this.header.get(this.header.size() - 1);
    }

    public float getMargin() {
        return this.margin;
    }

    protected void setYStart(float yStart) {
        this.yStart = yStart;
    }

    public boolean isDrawDebug() {
        return this.drawDebug;
    }

    public void setDrawDebug(boolean drawDebug) {
        this.drawDebug = drawDebug;
    }

    public boolean tableIsBroken() {
        return this.tableIsBroken;
    }

    public void setTableIsBroken(boolean tableIsBroken) {
        this.tableIsBroken = tableIsBroken;
    }
}

