/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.image;

import be.quodlibet.boxable.utils.ImageUtils;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class Image {
    private final BufferedImage image;
    private float width;
    private float height;

    public Image(BufferedImage image) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public void draw(PDDocument doc, PDPageContentStream stream, float x, float y) throws IOException {
        PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)this.image);
        stream.drawImage(imageXObject, x, y - this.height, this.width, this.height);
    }

    public Image scale(float width) {
        float factorWidth = width / this.width;
        return this.scale(width, this.height * factorWidth);
    }

    public Image scale(float width, float height) {
        Dimension imageDim = new Dimension(this.image.getWidth(), this.image.getHeight());
        Dimension newImageDim = new Dimension((int)width, (int)height);
        Dimension scaledImageDim = ImageUtils.getScaledDimension(imageDim, newImageDim);
        this.width = scaledImageDim.width;
        this.height = scaledImageDim.height;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }
}

