/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.line;

import java.awt.Color;

public class LineStyle {
    private final Color color;
    private final float width;
    private float[] dashArray;
    private float dashPhase;

    public LineStyle(Color color, float width) {
        this.color = color;
        this.width = width;
    }

    public static LineStyle produceDotted(Color color, int width) {
        LineStyle line = new LineStyle(color, width);
        line.dashArray = new float[]{1.0f};
        line.dashPhase = 0.0f;
        return line;
    }

    public static LineStyle produceDashed(Color color, int width) {
        return LineStyle.produceDashed(color, width, new float[]{5.0f}, 0.0f);
    }

    public static LineStyle produceDashed(Color color, int width, float[] dashArray, float dashPhase) {
        LineStyle line = new LineStyle(color, width);
        line.dashArray = dashArray;
        line.dashPhase = dashPhase;
        return line;
    }

    public Color getColor() {
        return this.color;
    }

    public float getWidth() {
        return this.width;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }
}

