/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.utils;

import be.quodlibet.boxable.image.Image;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    private ImageUtils() {
    }

    public static Image readImage(File imageFile) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(imageFile);
        return new Image(bufferedImage);
    }

    public static Dimension getScaledDimension(Dimension imgDim, Dimension boundary) {
        int imgWidth = imgDim.width;
        int imgHeight = imgDim.height;
        int boundWidth = boundary.width;
        int boundHeight = boundary.height;
        int newImgWidth = imgWidth;
        int newImgHeight = imgHeight;
        if (imgWidth > boundWidth) {
            newImgWidth = boundWidth;
            newImgHeight = newImgWidth * imgHeight / imgWidth;
        }
        if (newImgHeight > boundHeight) {
            newImgHeight = boundHeight;
            newImgWidth = newImgHeight * imgWidth / imgHeight;
        }
        return new Dimension(newImgWidth, newImgHeight);
    }
}

