/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.ImageCell;
import be.quodlibet.boxable.Table;
import be.quodlibet.boxable.VerticalAlignment;
import be.quodlibet.boxable.image.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public class Row<T extends PDPage> {
    private final Table<T> table;
    PDOutlineItem bookmark;
    List<Cell<T>> cells;
    private boolean headerRow = false;
    float height;
    private float lineSpacing = 1.0f;

    Row(Table<T> table, List<Cell<T>> cells, float height) {
        this.table = table;
        this.cells = cells;
        this.height = height;
    }

    Row(Table<T> table, float height) {
        this.table = table;
        this.cells = new ArrayList<Cell<T>>();
        this.height = height;
    }

    public Cell<T> createCell(float width, String value) {
        Cell cell = new Cell(this, width, value, true);
        if (this.headerRow) {
            cell.setHeaderCell(true);
        }
        this.setBorders(cell, this.cells.isEmpty());
        cell.setLineSpacing(this.lineSpacing);
        this.cells.add(cell);
        return cell;
    }

    public ImageCell<T> createImageCell(float width, Image img) {
        ImageCell cell = new ImageCell(this, width, img, true);
        this.setBorders(cell, this.cells.isEmpty());
        this.cells.add(cell);
        return cell;
    }

    public Cell<T> createImageCell(float width, Image img, HorizontalAlignment align, VerticalAlignment valign) {
        ImageCell cell = new ImageCell(this, width, img, true, align, valign);
        this.setBorders(cell, this.cells.isEmpty());
        this.cells.add(cell);
        return cell;
    }

    public Cell<T> createCell(float width, String value, HorizontalAlignment align, VerticalAlignment valign) {
        Cell cell = new Cell(this, width, value, true, align, valign);
        if (this.headerRow) {
            cell.setHeaderCell(true);
        }
        this.setBorders(cell, this.cells.isEmpty());
        cell.setLineSpacing(this.lineSpacing);
        this.cells.add(cell);
        return cell;
    }

    public Cell<T> createCell(String value) {
        float headerCellWidth = this.table.getHeader().getCells().get(this.cells.size()).getWidth();
        Cell cell = new Cell(this, headerCellWidth, value, false);
        this.setBorders(cell, this.cells.isEmpty());
        this.cells.add(cell);
        return cell;
    }

    private void setBorders(Cell<T> cell, boolean leftBorder) {
        if (!leftBorder) {
            cell.setLeftBorderStyle(null);
        }
    }

    void removeTopBorders() {
        for (Cell<T> cell : this.cells) {
            cell.setTopBorderStyle(null);
        }
    }

    public float getHeight() {
        float maxheight = 0.0f;
        for (Cell<T> cell : this.cells) {
            float cellHeight = cell.getCellHeight();
            if (!(cellHeight > maxheight)) continue;
            maxheight = cellHeight;
        }
        if (maxheight > this.height) {
            this.height = maxheight;
        }
        return this.height;
    }

    public float getLineHeight() throws IOException {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public List<Cell<T>> getCells() {
        return this.cells;
    }

    public int getColCount() {
        return this.cells.size();
    }

    public void setCells(List<Cell<T>> cells) {
        this.cells = cells;
    }

    public float getWidth() {
        return this.table.getWidth();
    }

    public PDOutlineItem getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(PDOutlineItem bookmark) {
        this.bookmark = bookmark;
    }

    protected float getLastCellExtraWidth() {
        float cellWidth = 0.0f;
        for (Cell<T> cell : this.cells) {
            cellWidth += cell.getWidth();
        }
        float lastCellExtraWidth = this.getWidth() - cellWidth;
        return lastCellExtraWidth;
    }

    public float xEnd() {
        return this.table.getMargin() + this.getWidth();
    }

    public boolean isHeaderRow() {
        return this.headerRow;
    }

    public void setHeaderRow(boolean headerRow) {
        this.headerRow = headerRow;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }
}

