/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.text;

import be.quodlibet.boxable.text.Token;
import be.quodlibet.boxable.text.TokenType;
import be.quodlibet.boxable.text.WrappingFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public final class Tokenizer {
    private Tokenizer() {
    }

    public static List<Token> tokenize(String text, WrappingFunction wrappingFunction) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (text != null) {
            String[] split = wrappingFunction.getLines(text);
            int textIndex = text.length();
            Stack<Integer> possibleWrapPoints = new Stack<Integer>();
            possibleWrapPoints.push(textIndex);
            for (int i = split.length - 1; i > 0; --i) {
                int splitLength = split[i].length();
                possibleWrapPoints.push(textIndex - splitLength);
                textIndex -= splitLength;
            }
            StringBuilder sb = new StringBuilder();
            Integer currentWrapPoint = (Integer)possibleWrapPoints.pop();
            block4: for (textIndex = 0; textIndex < text.length(); ++textIndex) {
                if (textIndex == currentWrapPoint) {
                    if (sb.length() > 0) {
                        tokens.add(new Token(TokenType.TEXT, sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    tokens.add(new Token(TokenType.POSSIBLE_WRAP_POINT, "" + textIndex));
                    currentWrapPoint = (Integer)possibleWrapPoints.pop();
                }
                char c = text.charAt(textIndex);
                switch (c) {
                    case '<': {
                        char lookahead4;
                        char lookahead3;
                        boolean consumed = false;
                        if (textIndex >= text.length() - 2) continue block4;
                        char lookahead1 = text.charAt(textIndex + 1);
                        char lookahead2 = text.charAt(textIndex + 2);
                        if ('i' == lookahead1 && '>' == lookahead2) {
                            if (sb.length() > 0) {
                                tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                sb.delete(0, sb.length());
                            }
                            tokens.add(new Token(TokenType.OPEN_TAG, "i"));
                            textIndex += 2;
                            consumed = true;
                        } else if ('b' == lookahead1 && '>' == lookahead2) {
                            if (sb.length() > 0) {
                                tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                sb.delete(0, sb.length());
                            }
                            tokens.add(new Token(TokenType.OPEN_TAG, "b"));
                            textIndex += 2;
                            consumed = true;
                        } else if ('b' == lookahead1 && 'r' == lookahead2) {
                            if (textIndex < text.length() - 3) {
                                lookahead3 = text.charAt(textIndex + 3);
                                if (lookahead3 == '>') {
                                    if (sb.length() > 0) {
                                        tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(new Token(TokenType.WRAP_POINT, "br"));
                                    textIndex += 3;
                                    consumed = true;
                                } else if (textIndex < text.length() - 4) {
                                    lookahead4 = text.charAt(textIndex + 4);
                                    if (lookahead3 == '/' && lookahead4 == '>') {
                                        if (sb.length() > 0) {
                                            tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(new Token(TokenType.WRAP_POINT, "br"));
                                        textIndex += 4;
                                        consumed = true;
                                    } else if (textIndex < text.length() - 5) {
                                        char lookahead5 = text.charAt(textIndex + 5);
                                        if (lookahead3 == ' ' && lookahead4 == '/' && lookahead5 == '>') {
                                            if (sb.length() > 0) {
                                                tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                                sb.delete(0, sb.length());
                                            }
                                            tokens.add(new Token(TokenType.WRAP_POINT, "br"));
                                            textIndex += 5;
                                            consumed = true;
                                        }
                                    }
                                }
                            }
                        } else if ('p' == lookahead1 && '>' == lookahead2) {
                            if (sb.length() > 0) {
                                tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                sb.delete(0, sb.length());
                            }
                            tokens.add(new Token(TokenType.WRAP_POINT, "p"));
                            textIndex += 2;
                            consumed = true;
                        } else if ('o' == lookahead1 && 'l' == lookahead2) {
                            if (textIndex < text.length() - 3 && (lookahead3 = text.charAt(textIndex + 3)) == '>') {
                                if (sb.length() > 0) {
                                    tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                    sb.delete(0, sb.length());
                                }
                                tokens.add(new Token(TokenType.OPEN_TAG, "ol"));
                                textIndex += 3;
                                consumed = true;
                            }
                        } else if ('u' == lookahead1 && 'l' == lookahead2) {
                            if (textIndex < text.length() - 3 && (lookahead3 = text.charAt(textIndex + 3)) == '>') {
                                if (sb.length() > 0) {
                                    tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                    sb.delete(0, sb.length());
                                }
                                tokens.add(new Token(TokenType.OPEN_TAG, "ul"));
                                textIndex += 3;
                                consumed = true;
                            }
                        } else if ('l' == lookahead1 && 'i' == lookahead2) {
                            if (textIndex < text.length() - 3 && (lookahead3 = text.charAt(textIndex + 3)) == '>') {
                                if (sb.length() > 0) {
                                    tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                    sb.delete(0, sb.length());
                                }
                                tokens.add(new Token(TokenType.WRAP_POINT, "li"));
                                textIndex += 3;
                                consumed = true;
                            }
                        } else if ('/' == lookahead1) {
                            if (textIndex < text.length() - 3 && '>' == (lookahead3 = text.charAt(textIndex + 3))) {
                                if ('i' == lookahead2) {
                                    if (sb.length() > 0) {
                                        tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(new Token(TokenType.CLOSE_TAG, "i"));
                                    textIndex += 3;
                                    consumed = true;
                                } else if ('b' == lookahead2) {
                                    if (sb.length() > 0) {
                                        tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(new Token(TokenType.CLOSE_TAG, "b"));
                                    textIndex += 3;
                                    consumed = true;
                                } else if ('p' == lookahead2) {
                                    if (sb.length() > 0) {
                                        tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(new Token(TokenType.CLOSE_TAG, "p"));
                                    textIndex += 3;
                                    consumed = true;
                                }
                            }
                            if (textIndex < text.length() - 4) {
                                lookahead3 = text.charAt(textIndex + 3);
                                lookahead4 = text.charAt(textIndex + 4);
                                if ('l' == lookahead3) {
                                    if ('o' == lookahead2 && '>' == lookahead4) {
                                        if (sb.length() > 0) {
                                            tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(new Token(TokenType.CLOSE_TAG, "ol"));
                                        textIndex += 4;
                                        consumed = true;
                                    } else if ('u' == lookahead2 && '>' == lookahead4) {
                                        if (sb.length() > 0) {
                                            tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(new Token(TokenType.CLOSE_TAG, "ul"));
                                        textIndex += 4;
                                        consumed = true;
                                    }
                                } else if ('l' == lookahead2 && 'i' == lookahead3 && '>' == lookahead4) {
                                    if (sb.length() > 0) {
                                        tokens.add(new Token(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(new Token(TokenType.CLOSE_TAG, "li"));
                                    textIndex += 4;
                                    consumed = true;
                                }
                            }
                        }
                        if (consumed) continue block4;
                        sb.append('<');
                        continue block4;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            if (sb.length() > 0) {
                tokens.add(new Token(TokenType.TEXT, sb.toString()));
                sb.delete(0, sb.length());
            }
            tokens.add(new Token(TokenType.POSSIBLE_WRAP_POINT, "" + textIndex));
            return tokens;
        }
        return Collections.emptyList();
    }
}

