/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.ImageCell;
import be.quodlibet.boxable.Paragraph;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.TableCell;
import be.quodlibet.boxable.line.LineStyle;
import be.quodlibet.boxable.page.PageProvider;
import be.quodlibet.boxable.text.Token;
import be.quodlibet.boxable.text.WrappingFunction;
import be.quodlibet.boxable.utils.FontUtils;
import be.quodlibet.boxable.utils.PDStreamUtils;
import be.quodlibet.boxable.utils.PageContentStreamOptimized;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public abstract class Table<T extends PDPage> {
    public final PDDocument document;
    private float margin;
    private T currentPage;
    private PageContentStreamOptimized tableContentStream;
    private List<PDOutlineItem> bookmarks;
    private List<Row<T>> header = new ArrayList<Row<T>>();
    private List<Row<T>> rows = new ArrayList<Row<T>>();
    private final float yStartNewPage;
    private float yStart;
    private final float width;
    private final boolean drawLines;
    private final boolean drawContent;
    private float headerBottomMargin = 4.0f;
    private float lineSpacing = 1.0f;
    private boolean tableIsBroken = false;
    private boolean tableStartedAtNewPage = false;
    private boolean removeTopBorders = false;
    private boolean removeAllBorders = false;
    private PageProvider<T> pageProvider;
    private final float pageTopMargin;
    private final float pageBottomMargin;
    private boolean drawDebug;

    @Deprecated
    public Table(float yStart, float yStartNewPage, float pageBottomMargin, float width, float margin, PDDocument document, T currentPage, boolean drawLines, boolean drawContent) throws IOException {
        this(yStart, yStartNewPage, 0.0f, pageBottomMargin, width, margin, document, currentPage, drawLines, drawContent, null);
    }

    @Deprecated
    public Table(float yStartNewPage, float pageBottomMargin, float width, float margin, PDDocument document, boolean drawLines, boolean drawContent) throws IOException {
        this(yStartNewPage, 0.0f, pageBottomMargin, width, margin, document, drawLines, drawContent, null);
    }

    public Table(float yStart, float yStartNewPage, float pageTopMargin, float pageBottomMargin, float width, float margin, PDDocument document, T currentPage, boolean drawLines, boolean drawContent, PageProvider<T> pageProvider) throws IOException {
        this.pageTopMargin = pageTopMargin;
        this.document = document;
        this.drawLines = drawLines;
        this.drawContent = drawContent;
        this.yStartNewPage = yStartNewPage;
        this.margin = margin;
        this.width = width;
        this.yStart = yStart;
        this.pageBottomMargin = pageBottomMargin;
        this.currentPage = currentPage;
        this.pageProvider = pageProvider;
        this.loadFonts();
    }

    public Table(float yStartNewPage, float pageTopMargin, float pageBottomMargin, float width, float margin, PDDocument document, boolean drawLines, boolean drawContent, PageProvider<T> pageProvider) throws IOException {
        this.pageTopMargin = pageTopMargin;
        this.document = document;
        this.drawLines = drawLines;
        this.drawContent = drawContent;
        this.yStartNewPage = yStartNewPage;
        this.margin = margin;
        this.width = width;
        this.pageProvider = pageProvider;
        this.pageBottomMargin = pageBottomMargin;
        this.loadFonts();
        this.currentPage = pageProvider.nextPage();
    }

    protected abstract void loadFonts() throws IOException;

    protected PDType0Font loadFont(String fontPath) throws IOException {
        return FontUtils.loadFont(this.getDocument(), fontPath);
    }

    protected PDDocument getDocument() {
        return this.document;
    }

    public void drawTitle(String title, PDFont font, int fontSize, float tableWidth, float height, String alignment, float freeSpaceForPageBreak, boolean drawHeaderMargin) throws IOException {
        this.drawTitle(title, font, fontSize, tableWidth, height, alignment, freeSpaceForPageBreak, null, drawHeaderMargin);
    }

    public void drawTitle(String title, PDFont font, int fontSize, float tableWidth, float height, String alignment, float freeSpaceForPageBreak, WrappingFunction wrappingFunction, boolean drawHeaderMargin) throws IOException {
        this.ensureStreamIsOpen();
        if (this.isEndOfPage(freeSpaceForPageBreak)) {
            this.tableContentStream.close();
            this.pageBreak();
            this.tableStartedAtNewPage = true;
        }
        if (title == null) {
            this.yStart -= height;
        } else {
            PageContentStreamOptimized articleTitle = this.createPdPageContentStream();
            Paragraph paragraph = new Paragraph(title, font, fontSize, tableWidth, HorizontalAlignment.get(alignment), wrappingFunction);
            paragraph.setDrawDebug(this.drawDebug);
            this.yStart = paragraph.write(articleTitle, this.margin, this.yStart);
            if (paragraph.getHeight() < height) {
                this.yStart -= height - paragraph.getHeight();
            }
            articleTitle.close();
            if (this.drawDebug) {
                PDStreamUtils.rect(this.tableContentStream, this.margin, this.yStart, this.width, this.headerBottomMargin, Color.CYAN);
            }
        }
        if (drawHeaderMargin) {
            this.yStart -= this.headerBottomMargin;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public Row<T> createRow(float height) {
        Row row = new Row(this, height);
        row.setLineSpacing(this.lineSpacing);
        this.rows.add(row);
        return row;
    }

    public Row<T> createRow(List<Cell<T>> cells, float height) {
        Row<T> row = new Row<T>(this, cells, height);
        row.setLineSpacing(this.lineSpacing);
        this.rows.add(row);
        return row;
    }

    public float draw() throws IOException {
        this.ensureStreamIsOpen();
        for (Row<T> row : this.rows) {
            if (this.header.contains(row) && this.isEndOfPage(this.getMinimumHeight())) {
                this.pageBreak();
                this.tableStartedAtNewPage = true;
            }
            this.drawRow(row);
        }
        this.endTable();
        return this.yStart;
    }

    private void drawRow(Row<T> row) throws IOException {
        float rowHeight = row.getHeight();
        if (row != this.header && row != this.rows.get(0) && !this.isEndOfPage(rowHeight)) {
            row.removeTopBorders();
        }
        if (row.getBookmark() != null) {
            PDPageXYZDestination bookmarkDestination = new PDPageXYZDestination();
            bookmarkDestination.setPage(this.currentPage);
            bookmarkDestination.setTop((int)this.yStart);
            row.getBookmark().setDestination((PDDestination)bookmarkDestination);
            this.addBookmark(row.getBookmark());
        }
        this.removeTopBorders = true;
        if (this.allBordersRemoved()) {
            row.removeAllBorders();
        }
        if (this.isEndOfPage(rowHeight) && !this.header.contains(row)) {
            this.endTable();
            this.pageBreak();
            if (!this.header.isEmpty()) {
                for (Row<T> headerRow : this.header) {
                    this.drawRow(headerRow);
                }
                this.removeTopBorders = true;
            } else {
                this.removeTopBorders = false;
            }
        }
        if (row == this.rows.get(0)) {
            this.removeTopBorders = false;
        }
        if (this.removeTopBorders) {
            row.removeTopBorders();
        }
        if (row == this.rows.get(0)) {
            this.removeTopBorders = false;
        }
        if (this.removeTopBorders) {
            row.removeTopBorders();
        }
        if (this.drawLines) {
            this.drawVerticalLines(row, rowHeight);
        }
        if (this.drawContent) {
            this.drawCellContent(row, rowHeight);
        }
    }

    private T createNewPage() {
        if (this.pageProvider != null) {
            return this.pageProvider.nextPage();
        }
        return this.createPage();
    }

    @Deprecated
    protected T createPage() {
        throw new IllegalStateException("You either have to provide a " + PageProvider.class.getCanonicalName() + " or override this method");
    }

    private PageContentStreamOptimized createPdPageContentStream() throws IOException {
        return new PageContentStreamOptimized(new PDPageContentStream(this.getDocument(), this.getCurrentPage(), PDPageContentStream.AppendMode.APPEND, true));
    }

    private void drawCellContent(Row<T> row, float rowHeight) throws IOException {
        float cursorX = this.margin;
        for (Cell<T> cell : row.getCells()) {
            float cursorY;
            float cellStartX = cursorX;
            if (cell instanceof ImageCell) {
                ImageCell imageCell = (ImageCell)cell;
                cursorY = this.yStart - cell.getTopPadding() - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth());
                switch (cell.getValign()) {
                    case TOP: {
                        break;
                    }
                    case MIDDLE: {
                        cursorY -= cell.getVerticalFreeSpace() / 2.0f;
                        break;
                    }
                    case BOTTOM: {
                        cursorY -= cell.getVerticalFreeSpace();
                    }
                }
                cursorX += cell.getLeftPadding() + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth());
                switch (cell.getAlign()) {
                    case CENTER: {
                        cursorX += cell.getHorizontalFreeSpace() / 2.0f;
                        break;
                    }
                    case LEFT: {
                        break;
                    }
                    case RIGHT: {
                        cursorX += cell.getHorizontalFreeSpace();
                    }
                }
                imageCell.getImage().draw(this.document, this.tableContentStream, cursorX, cursorY);
            } else if (cell instanceof TableCell) {
                TableCell tableCell = (TableCell)cell;
                cursorY = this.yStart - cell.getTopPadding() - (cell.getTopBorder() != null ? cell.getTopBorder().getWidth() : 0.0f);
                switch (cell.getValign()) {
                    case TOP: {
                        break;
                    }
                    case MIDDLE: {
                        cursorY -= cell.getVerticalFreeSpace() / 2.0f;
                        break;
                    }
                    case BOTTOM: {
                        cursorY -= cell.getVerticalFreeSpace();
                    }
                }
                tableCell.setXPosition(cursorX += cell.getLeftPadding() + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()));
                tableCell.setYPosition(cursorY);
                this.tableContentStream.endText();
                tableCell.draw((PDPage)this.currentPage);
            } else {
                if (cell.getFont() == null) {
                    throw new IllegalArgumentException("Font is null on Cell=" + cell.getText());
                }
                if (cell.isTextRotated()) {
                    cursorY = this.yStart - cell.getInnerHeight() - cell.getTopPadding() - (cell.getTopBorder() != null ? cell.getTopBorder().getWidth() : 0.0f);
                    switch (cell.getAlign()) {
                        case CENTER: {
                            cursorY += cell.getVerticalFreeSpace() / 2.0f;
                            break;
                        }
                        case LEFT: {
                            break;
                        }
                        case RIGHT: {
                            cursorY += cell.getVerticalFreeSpace();
                        }
                    }
                    cursorX += cell.getLeftPadding() + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()) + FontUtils.getHeight(cell.getFont(), cell.getFontSize()) + FontUtils.getDescent(cell.getFont(), cell.getFontSize());
                    switch (cell.getValign()) {
                        case TOP: {
                            break;
                        }
                        case MIDDLE: {
                            cursorX += cell.getHorizontalFreeSpace() / 2.0f;
                            break;
                        }
                        case BOTTOM: {
                            cursorX += cell.getHorizontalFreeSpace();
                        }
                    }
                    cell.getParagraph().getLines();
                } else {
                    cursorY = this.yStart - cell.getTopPadding() - FontUtils.getHeight(cell.getFont(), cell.getFontSize()) - FontUtils.getDescent(cell.getFont(), cell.getFontSize()) - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth());
                    if (this.drawDebug) {
                        PDStreamUtils.rect(this.tableContentStream, cursorX + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()), this.yStart - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth()), cell.getWidth() - (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()) - (cell.getRightBorder() == null ? 0.0f : cell.getRightBorder().getWidth()), cell.getTopPadding(), Color.RED);
                        PDStreamUtils.rect(this.tableContentStream, cursorX + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()), this.yStart - cell.getHeight() + (cell.getBottomBorder() == null ? 0.0f : cell.getBottomBorder().getWidth()) + cell.getBottomPadding(), cell.getWidth() - (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()) - (cell.getRightBorder() == null ? 0.0f : cell.getRightBorder().getWidth()), cell.getBottomPadding(), Color.RED);
                        PDStreamUtils.rect(this.tableContentStream, cursorX + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth()), this.yStart - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth()), cell.getLeftPadding(), cell.getHeight() - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth()) - (cell.getBottomBorder() == null ? 0.0f : cell.getBottomBorder().getWidth()), Color.RED);
                        PDStreamUtils.rect(this.tableContentStream, cursorX + cell.getWidth() - (cell.getRightBorder() == null ? 0.0f : cell.getRightBorder().getWidth()), this.yStart - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth()), -cell.getRightPadding(), cell.getHeight() - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth()) - (cell.getBottomBorder() == null ? 0.0f : cell.getBottomBorder().getWidth()), Color.RED);
                    }
                    cursorX += cell.getLeftPadding() + (cell.getLeftBorder() == null ? 0.0f : cell.getLeftBorder().getWidth());
                    switch (cell.getAlign()) {
                        case CENTER: {
                            cursorX += cell.getHorizontalFreeSpace() / 2.0f;
                            break;
                        }
                        case LEFT: {
                            break;
                        }
                        case RIGHT: {
                            cursorX += cell.getHorizontalFreeSpace();
                        }
                    }
                    switch (cell.getValign()) {
                        case TOP: {
                            break;
                        }
                        case MIDDLE: {
                            cursorY -= cell.getVerticalFreeSpace() / 2.0f;
                            break;
                        }
                        case BOTTOM: {
                            cursorY -= cell.getVerticalFreeSpace();
                        }
                    }
                }
                float lineStartX = cursorX;
                float lineStartY = cursorY;
                this.tableContentStream.setNonStrokingColor(cell.getTextColor());
                int italicCounter = 0;
                int boldCounter = 0;
                this.tableContentStream.setRotated(cell.isTextRotated());
                for (Map.Entry<Integer, List<Token>> entry : cell.getParagraph().getMapLineTokens().entrySet()) {
                    float freeSpaceWithinLine = cell.getParagraph().getMaxLineWidth() - cell.getParagraph().getLineWidth(entry.getKey());
                    if (cell.isTextRotated()) {
                        cursorY = lineStartY;
                        switch (cell.getAlign()) {
                            case CENTER: {
                                cursorY += freeSpaceWithinLine / 2.0f;
                                break;
                            }
                            case LEFT: {
                                break;
                            }
                            case RIGHT: {
                                cursorY += freeSpaceWithinLine;
                            }
                        }
                    } else {
                        cursorX = lineStartX;
                        switch (cell.getAlign()) {
                            case CENTER: {
                                cursorX += freeSpaceWithinLine / 2.0f;
                                break;
                            }
                            case LEFT: {
                                break;
                            }
                            case RIGHT: {
                                cursorX += freeSpaceWithinLine;
                            }
                        }
                    }
                    PDFont currentFont = cell.getParagraph().getFont(false, false);
                    for (Token token : entry.getValue()) {
                        switch (token.getType()) {
                            case OPEN_TAG: {
                                if ("b".equals(token.getData())) {
                                    ++boldCounter;
                                    break;
                                }
                                if (!"i".equals(token.getData())) break;
                                ++italicCounter;
                                break;
                            }
                            case CLOSE_TAG: {
                                if ("b".equals(token.getData())) {
                                    boldCounter = Math.max(boldCounter - 1, 0);
                                    break;
                                }
                                if (!"i".equals(token.getData())) break;
                                italicCounter = Math.max(italicCounter - 1, 0);
                                break;
                            }
                            case PADDING: {
                                cursorX += Float.parseFloat(token.getData());
                                break;
                            }
                            case ORDERING: {
                                currentFont = cell.getParagraph().getFont(boldCounter > 0, italicCounter > 0);
                                this.tableContentStream.setFont(currentFont, cell.getFontSize());
                                if (cell.isTextRotated()) {
                                    this.tableContentStream.newLineAt(cursorX, cursorY);
                                    this.tableContentStream.showText(token.getData());
                                    cursorY += token.getWidth(currentFont) / 1000.0f * cell.getFontSize();
                                    break;
                                }
                                this.tableContentStream.newLineAt(cursorX, cursorY);
                                this.tableContentStream.showText(token.getData());
                                cursorX += token.getWidth(currentFont) / 1000.0f * cell.getFontSize();
                                break;
                            }
                            case BULLET: {
                                float widthOfSpace = currentFont.getSpaceWidth();
                                float halfHeight = FontUtils.getHeight(currentFont, cell.getFontSize()) / 2.0f;
                                if (cell.isTextRotated()) {
                                    PDStreamUtils.rect(this.tableContentStream, cursorX + halfHeight, cursorY, token.getWidth(currentFont) / 1000.0f * cell.getFontSize(), widthOfSpace / 1000.0f * cell.getFontSize(), cell.getTextColor());
                                    cursorY += 2.0f * widthOfSpace / 1000.0f * cell.getFontSize();
                                    break;
                                }
                                PDStreamUtils.rect(this.tableContentStream, cursorX, cursorY + halfHeight, token.getWidth(currentFont) / 1000.0f * cell.getFontSize(), widthOfSpace / 1000.0f * cell.getFontSize(), cell.getTextColor());
                                cursorX += 2.0f * widthOfSpace / 1000.0f * cell.getFontSize();
                                break;
                            }
                            case TEXT: {
                                currentFont = cell.getParagraph().getFont(boldCounter > 0, italicCounter > 0);
                                this.tableContentStream.setFont(currentFont, cell.getFontSize());
                                if (cell.isTextRotated()) {
                                    this.tableContentStream.newLineAt(cursorX, cursorY);
                                    this.tableContentStream.showText(token.getData());
                                    cursorY += token.getWidth(currentFont) / 1000.0f * cell.getFontSize();
                                    break;
                                }
                                try {
                                    this.tableContentStream.newLineAt(cursorX, cursorY);
                                    this.tableContentStream.showText(token.getData());
                                    cursorX += token.getWidth(currentFont) / 1000.0f * cell.getFontSize();
                                    break;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (cell.isTextRotated()) {
                        cursorX += cell.getParagraph().getFontHeight() * cell.getLineSpacing();
                        continue;
                    }
                    cursorY -= cell.getParagraph().getFontHeight() * cell.getLineSpacing();
                }
            }
            cursorX = cellStartX + cell.getWidth();
        }
        this.yStart -= rowHeight;
    }

    private void drawVerticalLines(Row<T> row, float rowHeight) throws IOException {
        float xStart = this.margin;
        Iterator<Cell<T>> cellIterator = row.getCells().iterator();
        while (cellIterator.hasNext()) {
            Cell<T> cell = cellIterator.next();
            float cellWidth = cellIterator.hasNext() ? cell.getWidth() : this.width - (xStart - this.margin);
            this.fillCellColor(cell, this.yStart, xStart, rowHeight, cellWidth);
            this.drawCellBorders(rowHeight, cell, xStart);
            xStart += cellWidth;
        }
    }

    private void drawCellBorders(float rowHeight, Cell<T> cell, float xStart) throws IOException {
        LineStyle leftBorder;
        LineStyle bottomBorder;
        LineStyle rightBorder;
        float yEnd = this.yStart - rowHeight;
        LineStyle topBorder = cell.getTopBorder();
        if (topBorder != null) {
            float y = this.yStart - topBorder.getWidth() / 2.0f;
            this.drawLine(xStart, y, xStart + cell.getWidth(), y, topBorder);
        }
        if ((rightBorder = cell.getRightBorder()) != null) {
            float x = xStart + cell.getWidth() - rightBorder.getWidth() / 2.0f;
            this.drawLine(x, this.yStart - (topBorder == null ? 0.0f : topBorder.getWidth()), x, yEnd, rightBorder);
        }
        if ((bottomBorder = cell.getBottomBorder()) != null) {
            float y = yEnd + bottomBorder.getWidth() / 2.0f;
            this.drawLine(xStart, y, xStart + cell.getWidth() - (rightBorder == null ? 0.0f : rightBorder.getWidth()), y, bottomBorder);
        }
        if ((leftBorder = cell.getLeftBorder()) != null) {
            float x = xStart + leftBorder.getWidth() / 2.0f;
            this.drawLine(x, this.yStart, x, yEnd + (bottomBorder == null ? 0.0f : bottomBorder.getWidth()), leftBorder);
        }
    }

    private void drawLine(float xStart, float yStart, float xEnd, float yEnd, LineStyle border) throws IOException {
        PDStreamUtils.setLineStyles(this.tableContentStream, border);
        this.tableContentStream.moveTo(xStart, yStart);
        this.tableContentStream.lineTo(xEnd, yEnd);
        this.tableContentStream.stroke();
    }

    private void fillCellColor(Cell<T> cell, float yStart, float xStart, float rowHeight, float cellWidth) throws IOException {
        if (cell.getFillColor() != null) {
            this.tableContentStream.setNonStrokingColor(cell.getFillColor());
            float height = rowHeight - (cell.getTopBorder() == null ? 0.0f : cell.getTopBorder().getWidth());
            this.tableContentStream.addRect(xStart, yStart -= rowHeight, cellWidth, height);
            this.tableContentStream.fill();
        }
    }

    private void ensureStreamIsOpen() throws IOException {
        if (this.tableContentStream == null) {
            this.tableContentStream = this.createPdPageContentStream();
        }
    }

    private void endTable() throws IOException {
        this.tableContentStream.close();
    }

    public T getCurrentPage() {
        if (this.currentPage == null) {
            throw new NullPointerException("No current page defined.");
        }
        return this.currentPage;
    }

    private boolean isEndOfPage(float freeSpaceForPageBreak) {
        boolean isEndOfPage;
        float currentY = this.yStart - freeSpaceForPageBreak;
        boolean bl = isEndOfPage = currentY <= this.pageBottomMargin;
        if (isEndOfPage) {
            this.setTableIsBroken(true);
        }
        return isEndOfPage;
    }

    private void pageBreak() throws IOException {
        this.tableContentStream.close();
        this.yStart = this.yStartNewPage - this.pageTopMargin;
        this.currentPage = this.createNewPage();
        this.tableContentStream = this.createPdPageContentStream();
    }

    private void addBookmark(PDOutlineItem bookmark) {
        if (this.bookmarks == null) {
            this.bookmarks = new ArrayList<PDOutlineItem>();
        }
        this.bookmarks.add(bookmark);
    }

    public List<PDOutlineItem> getBookmarks() {
        return this.bookmarks;
    }

    @Deprecated
    public void setHeader(Row<T> header) {
        this.header.clear();
        this.addHeaderRow(header);
    }

    public float getHeaderAndDataHeight() {
        float height = 0.0f;
        for (Row<T> row : this.rows) {
            height += row.getHeight();
        }
        return height;
    }

    public float getMinimumHeight() {
        float height = 0.0f;
        int firstDataRowIndex = 0;
        if (!this.header.isEmpty()) {
            for (Row<T> headerRow : this.header) {
                height += headerRow.getHeight();
                ++firstDataRowIndex;
            }
        }
        if (this.rows.size() > firstDataRowIndex) {
            height += this.rows.get(firstDataRowIndex).getHeight();
        }
        return height;
    }

    public void addHeaderRow(Row<T> row) {
        this.header.add(row);
        row.setHeaderRow(true);
    }

    public Row<T> getHeader() {
        if (this.header == null) {
            throw new IllegalArgumentException("Header Row not set on table");
        }
        return this.header.get(this.header.size() - 1);
    }

    public float getMargin() {
        return this.margin;
    }

    protected void setYStart(float yStart) {
        this.yStart = yStart;
    }

    public boolean isDrawDebug() {
        return this.drawDebug;
    }

    public void setDrawDebug(boolean drawDebug) {
        this.drawDebug = drawDebug;
    }

    public boolean tableIsBroken() {
        return this.tableIsBroken;
    }

    public void setTableIsBroken(boolean tableIsBroken) {
        this.tableIsBroken = tableIsBroken;
    }

    public List<Row<T>> getRows() {
        return this.rows;
    }

    public boolean tableStartedAtNewPage() {
        return this.tableStartedAtNewPage;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public boolean allBordersRemoved() {
        return this.removeAllBorders;
    }

    public void removeAllBorders(boolean removeAllBorders) {
        this.removeAllBorders = removeAllBorders;
    }
}

