/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.harmony;

import com.digitaldan.harmony.HarmonyClientListener;
import com.digitaldan.harmony.config.Action;
import com.digitaldan.harmony.config.Activity;
import com.digitaldan.harmony.config.ControlGroup;
import com.digitaldan.harmony.config.Device;
import com.digitaldan.harmony.config.Discovery;
import com.digitaldan.harmony.config.Function;
import com.digitaldan.harmony.config.HarmonyConfig;
import com.digitaldan.harmony.config.Ping;
import com.digitaldan.harmony.messages.ActivityFinishedMessage;
import com.digitaldan.harmony.messages.ConfigMessage;
import com.digitaldan.harmony.messages.DigestMessage;
import com.digitaldan.harmony.messages.DiscoveryMessage;
import com.digitaldan.harmony.messages.ErrorResponseMessage;
import com.digitaldan.harmony.messages.GetCurrentActivityMessage;
import com.digitaldan.harmony.messages.HoldActionMessage;
import com.digitaldan.harmony.messages.Message;
import com.digitaldan.harmony.messages.MessageDeserializer;
import com.digitaldan.harmony.messages.PingMessage;
import com.digitaldan.harmony.messages.RequestMessage;
import com.digitaldan.harmony.messages.ResponseMessage;
import com.digitaldan.harmony.messages.StartActivityMessage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarmonyClient {
    private static final int ONE_MB = 0x100000;
    private final Logger logger = LoggerFactory.getLogger(HarmonyClient.class);
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Message.class, (Object)new MessageDeserializer()).create();
    private final Map<String, CompletableFuture<ResponseMessage>> responseFutures = new HashMap<String, CompletableFuture<ResponseMessage>>();
    private final Set<HarmonyClientListener> listeners = new HashSet<HarmonyClientListener>();
    private WebSocketClient client;
    private Session session;
    private HarmonyConfig cachedConfig;
    private Activity currentActivity;
    private long connectedTime = System.currentTimeMillis();
    private HttpClient httpClient;
    private ScheduledExecutorService timeoutService;

    public HarmonyClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.timeoutService = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HarmonyClientListener listener) {
        Set<HarmonyClientListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
        if (this.currentActivity != null) {
            listener.activityStarted(this.currentActivity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HarmonyClientListener listener) {
        Set<HarmonyClientListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public void connect(String host) throws IOException {
        Discovery discovery;
        if (this.session != null && this.session.isOpen()) {
            throw new IOException("Can not call connect on already connected session");
        }
        if (!this.httpClient.isStarted()) {
            try {
                this.httpClient.start();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        if ((discovery = this.getDiscoveryFromHost(host)) == null) {
            throw new IOException(String.format("Could not discover host %s", host));
        }
        this.connectWebsocket(host, discovery.getActiveRemoteId());
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.session.close();
        }
    }

    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    public Discovery getDiscoveryFromHost(String host) throws IOException {
        URI uri;
        try {
            uri = new URI(String.format("http://%s:8088", host));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        DiscoveryMessage.DiscoveryRequestMessage drm = new DiscoveryMessage.DiscoveryRequestMessage();
        Request request = this.httpClient.POST(uri);
        this.logger.trace("Sending {}", (Object)drm.toJSON());
        request.content((ContentProvider)new StringContentProvider(drm.toJSON()), "application/json");
        request.header(HttpHeader.ORIGIN, "http://sl.dhg.myharmony.com");
        request.header(HttpHeader.ACCEPT, "text/plain");
        try {
            ContentResponse response = request.send();
            String res = new String(response.getContent());
            this.logger.trace("Discovery response for hos {} : {}", (Object)host, (Object)res);
            DiscoveryMessage.DiscoveryResponseMessage dr = DiscoveryMessage.DiscoveryResponseMessage.fromJSON(res);
            if (dr == null) {
                throw new IOException("Could not serialize discovery response");
            }
            return dr.getDiscovery();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException(e.getMessage());
        }
    }

    public CompletableFuture<Ping> sendPing() {
        CompletableFuture<Ping> future = new CompletableFuture<Ping>();
        ((CompletableFuture)this.sendMessage(new PingMessage.PingRequestMessage()).thenAccept(m -> future.complete(((PingMessage.PingResponseMessage)m).getPing()))).exceptionally(e -> {
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    public CompletableFuture<Activity> getCurrentActivity() {
        CompletableFuture<Activity> future = new CompletableFuture<Activity>();
        if (this.currentActivity == null) {
            this.sendMessage(new GetCurrentActivityMessage.GetCurrentActivityRequestMessage()).thenAccept(m -> {
                int activityId = ((GetCurrentActivityMessage.GetCurrentActivityResponseMessage)m).getActivityId();
                this.currentActivity = this.cachedConfig.getActivityById(activityId);
                future.complete(this.currentActivity);
            });
        } else {
            future.complete(this.currentActivity);
        }
        return future;
    }

    public CompletableFuture<?> startActivity(int activityId) throws IllegalArgumentException {
        if (this.cachedConfig != null) {
            if (this.cachedConfig.getActivityById(activityId) == null) {
                throw new IllegalArgumentException(String.format("Unknown activity '%d'", activityId));
            }
            return this.sendMessage(new StartActivityMessage.StartActivityRequestMessage(activityId, System.currentTimeMillis() - this.connectedTime));
        }
        return null;
    }

    public CompletableFuture<?> startActivityByName(String label) throws IllegalArgumentException {
        if (this.cachedConfig != null) {
            Activity activity = this.cachedConfig.getActivityByName(label);
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Unknown activity '%s'", label));
            }
            return this.sendMessage(new StartActivityMessage.StartActivityRequestMessage(activity.getId(), System.currentTimeMillis() - this.connectedTime));
        }
        return null;
    }

    public CompletableFuture<?> pressButtonCurrentActivity(String buttonName) {
        return this.pressButtonCurrentActivity(buttonName, 200);
    }

    public CompletableFuture<?> pressButtonCurrentActivity(String buttonName, int timeMillis) {
        CompletableFuture future = new CompletableFuture();
        this.getCurrentActivity().thenAccept(currentActivity -> {
            String activityLabel = currentActivity.getLabel();
            for (Activity activity : this.cachedConfig.getActivities()) {
                if (!activity.getLabel().equalsIgnoreCase(activityLabel)) continue;
                for (ControlGroup controlGroup : activity.getControlGroup()) {
                    for (Function function : controlGroup.getFunction()) {
                        if (!function.getName().equalsIgnoreCase(buttonName) && !function.getLabel().equalsIgnoreCase(buttonName)) continue;
                        Action action = (Action)this.gson.fromJson(function.getAction(), Action.class);
                        this.pressButton(action.getDeviceId(), action.getCommand(), timeMillis).thenAccept(mm -> future.complete(null));
                        return;
                    }
                }
            }
            if (!future.isDone()) {
                future.completeExceptionally(new Exception("Could not find device in activity for button press"));
            }
        });
        return future;
    }

    public CompletableFuture<?> pressButton(int deviceId, String button, int timeMillis) {
        CompletableFuture future = new CompletableFuture();
        this.sendNoReplyMessage(new HoldActionMessage.HoldActionRequestMessage(deviceId, button, HoldActionMessage.HoldStatus.PRESS, System.currentTimeMillis() - this.connectedTime)).thenAccept(m -> {
            try {
                Thread.sleep(timeMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.sendNoReplyMessage(new HoldActionMessage.HoldActionRequestMessage(deviceId, button, HoldActionMessage.HoldStatus.RELEASE, System.currentTimeMillis() - this.connectedTime)).thenAccept(mm -> future.complete(null));
        });
        try {
            Thread.sleep(timeMillis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return future;
    }

    public CompletableFuture<?> pressButton(int deviceId, String button) {
        return this.pressButton(deviceId, button, 200);
    }

    public CompletableFuture<?> pressButton(String deviceName, String button) {
        Device device = this.cachedConfig.getDeviceByName(deviceName);
        if (device == null) {
            throw new IllegalArgumentException(String.format("Unknown device '%s'", deviceName));
        }
        return this.pressButton(device.getId(), button);
    }

    public CompletableFuture<?> pressButton(String deviceName, String button, int pressTime) {
        Device device = this.cachedConfig.getDeviceByName(deviceName);
        if (device == null) {
            throw new IllegalArgumentException(String.format("Unknown device '%s'", deviceName));
        }
        return this.pressButton(device.getId(), button, pressTime);
    }

    public CompletableFuture<HarmonyConfig> getConfig() {
        CompletableFuture<HarmonyConfig> future = new CompletableFuture<HarmonyConfig>();
        if (this.cachedConfig != null) {
            future.complete(this.cachedConfig);
        } else {
            this.sendMessage(new ConfigMessage.ConfigRequestMessage()).thenAccept(m -> {
                this.cachedConfig = ((ConfigMessage.ConfigResponseMessage)m).getHarmonyConfig();
                future.complete(this.cachedConfig);
            });
        }
        return future;
    }

    private ScheduledFuture<?> scheduleTimeout(String msgId) {
        return this.timeoutService.schedule(() -> {
            CompletableFuture<ResponseMessage> f = this.responseFutures.remove(msgId);
            if (f != null) {
                f.completeExceptionally(new Exception("response timeout"));
            }
        }, 2L, TimeUnit.MINUTES);
    }

    private CompletableFuture<ResponseMessage> sendMessage(final RequestMessage message) {
        final CompletableFuture<ResponseMessage> future = new CompletableFuture<ResponseMessage>();
        if (!this.isConnected()) {
            future.completeExceptionally(new IOException("Not Connected"));
            return future;
        }
        final String id = message.getId();
        String json = message.toJson();
        this.logger.debug("Sending: {}", (Object)json);
        this.session.getRemote().sendString(json, new WriteCallback(){

            public void writeSuccess() {
                HarmonyClient.this.logger.trace("writeSuccess for id {}", (Object)id);
                HarmonyClient.this.responseFutures.put(id, future);
                HarmonyClient.this.scheduleTimeout(message.getId());
            }

            public void writeFailed(Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    private CompletableFuture<ResponseMessage> sendNoReplyMessage(final RequestMessage message) {
        if (!this.isConnected()) {
            return null;
        }
        final CompletableFuture<ResponseMessage> future = new CompletableFuture<ResponseMessage>();
        String json = message.toJson();
        this.logger.debug("Sending: {}", (Object)json);
        this.session.getRemote().sendString(json, new WriteCallback(){

            public void writeSuccess() {
                HarmonyClient.this.logger.trace("writeSuccess for message {}", (Object)message.getId());
                future.complete(null);
            }

            public void writeFailed(Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    private void connectWebsocket(String host, String hubId) throws IOException {
        URI uri;
        try {
            uri = new URI(String.format("ws://%s:8088/?domain=svcs.myharmony.com&hubId=%s", host, hubId));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        this.client = new WebSocketClient(this.httpClient);
        this.client.getPolicy().setMaxTextMessageSize(0x100000);
        try {
            this.client.start();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.logger.error("Could not start web socket connection to hub {}", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        this.client.connect((Object)new MyWebSocketListener(), uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hubDisconected(String reason) {
        this.session.close();
        this.logger.debug("notifyClose {} {}", (Object)reason);
        Object object = this.listeners;
        synchronized (object) {
            for (HarmonyClientListener listener : this.listeners) {
                if (listener == null) continue;
                listener.hubDisconnected(reason);
            }
        }
        object = this.responseFutures;
        synchronized (object) {
            Iterator<Map.Entry<String, CompletableFuture<ResponseMessage>>> responseIter = this.responseFutures.entrySet().iterator();
            while (responseIter.hasNext()) {
                responseIter.next().getValue().completeExceptionally(new IOException("Connection Closed"));
                responseIter.remove();
            }
        }
    }

    private class MyWebSocketListener
    implements WebSocketListener {
        private MyWebSocketListener() {
        }

        public void onWebSocketClose(int code, String reason) {
            HarmonyClient.this.logger.debug("onWebSocketClose {} {}", (Object)code, (Object)reason);
            HarmonyClient.this.hubDisconected(reason);
        }

        public void onWebSocketConnect(Session wssession) {
            HarmonyClient.this.logger.debug("onWebSocketConnect {}", (Object)wssession);
            HarmonyClient.this.connectedTime = System.currentTimeMillis();
            HarmonyClient.this.session = wssession;
            HarmonyClient.this.getConfig().thenAccept(m -> {
                Set set = HarmonyClient.this.listeners;
                synchronized (set) {
                    for (HarmonyClientListener listener : HarmonyClient.this.listeners) {
                        if (listener == null) continue;
                        listener.hubConnected();
                    }
                }
            });
            HarmonyClient.this.getCurrentActivity();
        }

        public void onWebSocketError(Throwable error) {
            HarmonyClient.this.logger.debug("onWebSocketError", error);
            HarmonyClient.this.hubDisconected(error.getMessage());
        }

        public void onWebSocketBinary(byte[] data, int offset, int len) {
            HarmonyClient.this.logger.trace("onWebSocketBinary {} {} {}", new Object[]{data, offset, len});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWebSocketText(String message) {
            CompletableFuture future;
            ResponseMessage rm;
            HarmonyClient.this.logger.trace("onWebSocketText {}", (Object)message);
            Message m = (Message)HarmonyClient.this.gson.fromJson(message, Message.class);
            if (m == null) {
                return;
            }
            if (m instanceof ResponseMessage) {
                rm = (ResponseMessage)m;
                HarmonyClient.this.logger.trace("Looking for future for ID {}", (Object)rm.getId());
                future = (CompletableFuture)HarmonyClient.this.responseFutures.remove(rm.getId());
                if (future != null) {
                    HarmonyClient.this.logger.trace("Calling for future for ID {}", (Object)rm.getId());
                    future.complete(rm);
                }
            }
            if (m instanceof ErrorResponseMessage) {
                rm = (ResponseMessage)m;
                HarmonyClient.this.logger.trace("Error Response: Looking for future for ID {}", (Object)rm.getId());
                future = (CompletableFuture)HarmonyClient.this.responseFutures.remove(rm.getId());
                if (future != null) {
                    HarmonyClient.this.logger.trace("Error Response:  Calling for future for ID {}", (Object)rm.getId());
                    future.completeExceptionally(new Exception(String.format("Error Code %d : %s", rm.getCode(), rm.getMsg())));
                }
            }
            if (m instanceof ActivityFinishedMessage && HarmonyClient.this.cachedConfig != null) {
                ActivityFinishedMessage af = (ActivityFinishedMessage)m;
                HarmonyClient.this.logger.debug("ActivityFinishedMessage {}", (Object)af.getActivityFinished().getActivityId());
                Activity activity = HarmonyClient.this.cachedConfig.getActivityById(af.getActivityFinished().getActivityId());
                if (HarmonyClient.this.currentActivity != activity) {
                    HarmonyClient.this.currentActivity = activity;
                    Set set = HarmonyClient.this.listeners;
                    synchronized (set) {
                        for (HarmonyClientListener listener : HarmonyClient.this.listeners) {
                            if (listener == null) continue;
                            listener.activityStarted(HarmonyClient.this.currentActivity);
                        }
                    }
                }
            }
            if (m instanceof DigestMessage) {
                boolean newStatus = false;
                DigestMessage dm = (DigestMessage)m;
                Activity.Status status = dm.getDigest().getActivityStatus();
                Activity activity = HarmonyClient.this.cachedConfig.getActivityById(dm.getDigest().getActivityId());
                HarmonyClient.this.logger.trace("DigestMessage {}", (Object)activity.getId());
                if (status == Activity.Status.HUB_IS_OFF) {
                    for (Activity act : HarmonyClient.this.cachedConfig.getActivities()) {
                        if (act.getStatus() == status) continue;
                        newStatus = true;
                        act.setStatus(status);
                    }
                } else if (status != Activity.Status.UNKNOWN && status != activity.getStatus()) {
                    newStatus = true;
                    activity.setStatus(status);
                }
                if (newStatus) {
                    Set set = HarmonyClient.this.listeners;
                    synchronized (set) {
                        for (HarmonyClientListener listener : HarmonyClient.this.listeners) {
                            HarmonyClient.this.logger.debug("status listener[{}] notified: {} - {}", new Object[]{listener, activity, status});
                            listener.activityStatusChanged(activity, status);
                        }
                    }
                }
            }
        }
    }
}

