/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.harmony.config;

import com.digitaldan.harmony.config.Activity;
import com.digitaldan.harmony.config.Device;
import com.digitaldan.harmony.config.Global;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HarmonyConfig {
    @SerializedName(value="activity")
    private List<Activity> activities = new ArrayList<Activity>();
    @SerializedName(value="device")
    private List<Device> devices = new ArrayList<Device>();
    private Map<String, String> content = new HashMap<String, String>();
    private Global global;

    public String toJson() {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return gson.toJson((Object)this);
    }

    public Map<Integer, String> getDeviceLabels() {
        HashMap<Integer, String> results = new HashMap<Integer, String>();
        for (Device device : this.devices) {
            results.put(device.getId(), device.getLabel());
        }
        return results;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<Activity> activity) {
        this.activities = activity;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(List<Device> device) {
        this.devices = device;
    }

    public Map<String, String> getContent() {
        return this.content;
    }

    public void setContent(Map<String, String> content) {
        this.content = content;
    }

    public Global getGlobal() {
        return this.global;
    }

    public void setGlobal(Global global) {
        this.global = global;
    }

    public Activity getActivityById(int result) {
        for (Activity activity : this.activities) {
            if (activity.getId() != result) continue;
            return activity;
        }
        return null;
    }

    public Activity getActivityByName(String label) {
        for (Activity activity : this.activities) {
            if (!activity.getLabel().equals(label)) continue;
            return activity;
        }
        return null;
    }

    public Device getDeviceByName(String label) {
        for (Device device : this.devices) {
            if (!device.getLabel().equals(label)) continue;
            return device;
        }
        return null;
    }

    public Device getDeviceById(int id) {
        for (Device device : this.devices) {
            if (device.getId() != id) continue;
            return device;
        }
        return null;
    }
}

