/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.harmony.messages;

import com.digitaldan.harmony.messages.ActivityFinishedMessage;
import com.digitaldan.harmony.messages.ConfigMessage;
import com.digitaldan.harmony.messages.DigestMessage;
import com.digitaldan.harmony.messages.ErrorResponseMessage;
import com.digitaldan.harmony.messages.GetCurrentActivityMessage;
import com.digitaldan.harmony.messages.Message;
import com.digitaldan.harmony.messages.PingMessage;
import com.digitaldan.harmony.messages.StartActivityMessage;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeserializer
implements JsonDeserializer<Message> {
    private final Logger logger = LoggerFactory.getLogger(MessageDeserializer.class);
    private static HashMap<String, Class<?>> responseHandlers = new HashMap();

    public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement mime = jsonObject.get("cmd");
        if (mime == null) {
            mime = jsonObject.get("type");
        }
        if (mime != null) {
            Class<?> clazz = responseHandlers.get(mime.getAsString());
            if (clazz != null) {
                this.logger.trace("Calling fromJsonElement");
                return (Message)context.deserialize((JsonElement)jsonObject, clazz);
            }
            this.logger.debug("Unknown message type {}", (Object)mime);
            return null;
        }
        JsonElement code = jsonObject.get("code");
        if (code != null && code.getAsInt() >= 400) {
            return (Message)context.deserialize((JsonElement)jsonObject, ErrorResponseMessage.class);
        }
        return null;
    }

    static {
        responseHandlers.put("vnd.logitech.harmony/vnd.logitech.harmony.engine?config", ConfigMessage.ConfigResponseMessage.class);
        responseHandlers.put("vnd.logitech.harmony/vnd.logitech.harmony.engine?getCurrentActivity", GetCurrentActivityMessage.GetCurrentActivityResponseMessage.class);
        responseHandlers.put("vnd.logitech.connect/vnd.logitech.ping", PingMessage.PingResponseMessage.class);
        responseHandlers.put("harmony.activityengine?runactivity", StartActivityMessage.StartActivityResponseMethod.class);
        responseHandlers.put("connect.stateDigest?notify", DigestMessage.class);
        responseHandlers.put("harmony.engine?startActivityFinished", ActivityFinishedMessage.class);
    }
}

