/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.harmony.messages;

import com.google.gson.Gson;
import java.util.Map;
import java.util.UUID;

public abstract class RequestMessage {
    String mimeType;
    String id;
    Gson gson = new Gson();

    public RequestMessage(String mimeType) {
        this.mimeType = mimeType;
        this.id = UUID.randomUUID().toString();
    }

    public String toJson() {
        return this.gson.toJson((Object)new JsonRequest(this.mimeType, this.id, this.getParams()));
    }

    public String getId() {
        return this.id;
    }

    public abstract Map<String, Object> getParams();

    private class JsonRequest {
        HBus hbus = new HBus();

        public JsonRequest(String mimeType, String id, Map<String, Object> params) {
            this.hbus.cmd = mimeType;
            this.hbus.id = id;
            this.hbus.params = params;
        }

        private class HBus {
            String cmd;
            String id;
            Map<String, Object> params;

            private HBus() {
            }
        }
    }
}

