/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.harmony.shell;

import com.digitaldan.harmony.HarmonyClient;
import com.digitaldan.harmony.HarmonyClientListener;
import com.digitaldan.harmony.config.Activity;
import com.digitaldan.harmony.config.HarmonyConfig;
import com.digitaldan.harmony.shell.ShellCommandWrapper;
import com.martiansoftware.jsap.CommandLineTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
implements HarmonyClientListener {
    private final Logger logger = LoggerFactory.getLogger(App.class);
    private HarmonyClient hc;
    private ScheduledFuture<?> ping;

    public static void main(String[] args) {
        try {
            new App(args[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public App(String host) throws IOException {
        String line;
        try {
            HttpClient httpClient = new HttpClient();
            this.hc = new HarmonyClient(httpClient);
            this.hc.addListener(this);
            this.hc.connect(host);
        }
        catch (Exception e) {
            this.logger.error("error connecting to Hub", (Throwable)e);
            System.exit(-1);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while ((line = br.readLine()) != null && !line.equals("q")) {
            try {
                String[] lineArgs = CommandLineTokenizer.tokenize((String)line);
                if (lineArgs.length == 0) continue;
                ShellCommandWrapper command = new ShellCommandWrapper();
                new CmdLineParser((Object)command).parseArgument(lineArgs);
                command.execute(this.hc);
            }
            catch (CmdLineException e) {
                System.err.println(e.getMessage() + "\nlist devices - lists the configured devices and their id's\nlist activities - lists the configured activities and their id's\nshow activity - shows the current activity\nstart <activity> - starts an activity (takes a string or id)\npress <device> <button> - perform a single button press\nget_config - Dumps the full config json, unformatted\n");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.println("\n");
            }
        }
        this.ping.cancel(true);
        br.close();
        System.exit(0);
    }

    @Override
    public void hubConnected() {
        this.logger.info("hubConnected");
        CompletableFuture<HarmonyConfig> configFuture = this.hc.getConfig();
        configFuture.thenAccept(c -> {
            this.logger.info("CONFIG RECIEVED {}", (Object)c.toJson());
            for (Activity a : c.getActivities()) {
                this.logger.info("Activity {}", (Object)a.getLabel());
            }
        });
        CompletableFuture<Activity> activyFuture = this.hc.getCurrentActivity();
        activyFuture.thenAccept(a -> this.logger.info("ACTIVITY RECIEVED {}", a));
        this.ping = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> this.hc.sendPing().thenAccept(m -> this.logger.info("PONG")), 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void hubDisconnected(String cause) {
        this.logger.info("hubDisconnected {}", (Object)cause);
    }

    @Override
    public void activityStarted(Activity activity) {
        this.logger.info("Activity started {}", (Object)activity.toString());
    }

    @Override
    public void activityStatusChanged(Activity activity, Activity.Status status) {
        this.logger.info("Activity status changed to {}  {}", (Object)status, (Object)activity.toString());
    }
}

