/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII;

import com.digitaldan.jomnilinkII.Message;
import com.digitaldan.jomnilinkII.MessageTypes.Acknowledge;
import com.digitaldan.jomnilinkII.MessageTypes.ActivateKeypadEmergency;
import com.digitaldan.jomnilinkII.MessageTypes.AudioSourceStatus;
import com.digitaldan.jomnilinkII.MessageTypes.CommandMessage;
import com.digitaldan.jomnilinkII.MessageTypes.ConnectedSecurityCommand;
import com.digitaldan.jomnilinkII.MessageTypes.ConnectedSecurityStatus;
import com.digitaldan.jomnilinkII.MessageTypes.EndOfData;
import com.digitaldan.jomnilinkII.MessageTypes.EventLogData;
import com.digitaldan.jomnilinkII.MessageTypes.ExtendedObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.NameData;
import com.digitaldan.jomnilinkII.MessageTypes.NegativeAcknowledge;
import com.digitaldan.jomnilinkII.MessageTypes.Notifications;
import com.digitaldan.jomnilinkII.MessageTypes.ObjectProperties;
import com.digitaldan.jomnilinkII.MessageTypes.ObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ObjectTypeCapacities;
import com.digitaldan.jomnilinkII.MessageTypes.OtherEventNotifications;
import com.digitaldan.jomnilinkII.MessageTypes.ReadEventRecord;
import com.digitaldan.jomnilinkII.MessageTypes.ReadName;
import com.digitaldan.jomnilinkII.MessageTypes.ReqAudioSourceStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqExtendedObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqObjectProperties;
import com.digitaldan.jomnilinkII.MessageTypes.ReqObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqObjectTypeCapacities;
import com.digitaldan.jomnilinkII.MessageTypes.ReqSecurityCodeValidation;
import com.digitaldan.jomnilinkII.MessageTypes.SecurityCodeValidation;
import com.digitaldan.jomnilinkII.MessageTypes.SetTimeCommand;
import com.digitaldan.jomnilinkII.MessageTypes.SystemFeatures;
import com.digitaldan.jomnilinkII.MessageTypes.SystemFormats;
import com.digitaldan.jomnilinkII.MessageTypes.SystemInformation;
import com.digitaldan.jomnilinkII.MessageTypes.SystemStatus;
import com.digitaldan.jomnilinkII.MessageTypes.SystemTroubles;
import com.digitaldan.jomnilinkII.MessageTypes.WriteName;
import com.digitaldan.jomnilinkII.MessageTypes.ZoneReadyStatus;
import com.digitaldan.jomnilinkII.MessageTypes.properties.AccessControlReaderProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.AreaProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.AudioSourceProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.AudioZoneProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.AuxSensorProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.ButtonProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.CodeProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.MessageProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.ThermostatProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.UnitProperties;
import com.digitaldan.jomnilinkII.MessageTypes.properties.ZoneProperties;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AccessControlReaderLockStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AccessControlReaderStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AreaStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AudioZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AuxSensorStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExpansionStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAccessControlReaderLockStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAccessControlReaderStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAreaStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAudioZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAuxSensorStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedExpansionStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedMessageStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedThermostatStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedUnitStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedUserSettingStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.MessageStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.Status;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ThermostatStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.UnitStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.UserSettingStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ZoneStatus;
import com.digitaldan.jomnilinkII.MessageUtils;
import com.digitaldan.jomnilinkII.OmniUnknownMessageTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MessageFactory {
    public static Message fromBytes(byte[] bytes) throws IOException, OmniUnknownMessageTypeException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        int start = in.readUnsignedByte();
        int length = in.readUnsignedByte();
        int type = in.readUnsignedByte();
        int len = length - 1;
        byte[] data = new byte[len];
        in.readFully(data);
        bis = new ByteArrayInputStream(data);
        in = new DataInputStream(bis);
        switch (type) {
            case 1: {
                return MessageFactory.acknowledge();
            }
            case 2: {
                return MessageFactory.negativeAcknowledge();
            }
            case 3: {
                return MessageFactory.endOfData();
            }
            case 23: {
                return MessageFactory.systemInformation(in);
            }
            case 25: {
                return MessageFactory.systemStatus(in, len);
            }
            case 27: {
                return MessageFactory.systemTroubles(in, len);
            }
            case 29: {
                return MessageFactory.systemFeatures(in, len);
            }
            case 41: {
                return MessageFactory.systemFormats(in, len);
            }
            case 31: {
                return MessageFactory.objectTypeCapacities(in, len);
            }
            case 33: {
                return MessageFactory.objectProperties(in, len);
            }
            case 35: {
                return MessageFactory.objectStatus(in, len, false);
            }
            case 59: {
                return MessageFactory.objectStatus(in, len, true);
            }
            case 49: {
                return MessageFactory.audioSourceStatus(in, len);
            }
            case 57: {
                return MessageFactory.zoneReadyStatus(in, len);
            }
            case 55: {
                return MessageFactory.otherEventNotification(in, len);
            }
            case 37: {
                return MessageFactory.eventLogData(in, len);
            }
            case 14: {
                return MessageFactory.nameData(in, len);
            }
            case 39: {
                return MessageFactory.securityCodeValidation(in, len);
            }
        }
        throw new OmniUnknownMessageTypeException(type);
    }

    public static byte[] toBytes(Message msg) throws IOException, OmniUnknownMessageTypeException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(bos);
        os.writeByte(msg.getMessageType());
        switch (msg.getMessageType()) {
            case 11: 
            case 15: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 40: {
                break;
            }
            case 21: {
                os.writeBoolean(((Notifications)msg).isEnabled());
                break;
            }
            case 30: {
                Message m = (ReqObjectTypeCapacities)msg;
                os.writeByte(((ReqObjectTypeCapacities)m).getObjectType());
                break;
            }
            case 32: {
                Message m = (ReqObjectProperties)msg;
                os.writeByte(((ReqObjectProperties)m).getObjectType());
                os.writeShort(((ReqObjectProperties)m).getObjectNumber());
                os.writeByte(((ReqObjectProperties)m).getDirection());
                os.writeByte(((ReqObjectProperties)m).getFilter1());
                os.writeByte(((ReqObjectProperties)m).getFilter2());
                os.writeByte(((ReqObjectProperties)m).getFilter3());
                break;
            }
            case 58: {
                Message m = (ReqExtendedObjectStatus)msg;
                os.writeByte(((ReqExtendedObjectStatus)m).getObjectType());
                os.writeShort(((ReqExtendedObjectStatus)m).getStartObject());
                os.writeShort(((ReqExtendedObjectStatus)m).getEndObject());
                break;
            }
            case 34: {
                Message m = (ReqObjectStatus)msg;
                os.writeByte(((ReqObjectStatus)m).getObjectType());
                os.writeShort(((ReqObjectStatus)m).getStartObject());
                os.writeShort(((ReqObjectStatus)m).getEndObject());
                break;
            }
            case 48: {
                Message m = (ReqAudioSourceStatus)msg;
                os.writeShort(((ReqAudioSourceStatus)m).getSource());
                os.writeByte(((ReqAudioSourceStatus)m).getPosition());
                break;
            }
            case 45: 
            case 56: {
                break;
            }
            case 20: {
                Message m = (CommandMessage)msg;
                os.writeByte(((CommandMessage)m).getCommand());
                os.writeByte(((CommandMessage)m).getParameter1());
                os.writeShort(((CommandMessage)m).getParameter2());
                break;
            }
            case 36: {
                Message m = (ReadEventRecord)msg;
                os.writeShort(((ReadEventRecord)m).getEventNumber());
                os.writeByte(((ReadEventRecord)m).getDirection());
                break;
            }
            case 13: {
                Message m = (ReadName)msg;
                os.writeByte(((ReadName)m).getObjectType());
                os.writeShort(((ReadName)m).getObjectNumber());
                break;
            }
            case 47: {
                Message m = (ConnectedSecurityCommand)msg;
                os.writeByte(((ConnectedSecurityCommand)m).getCommand());
                os.writeByte(((ConnectedSecurityCommand)m).getPartition());
                os.writeByte(((ConnectedSecurityCommand)m).getDigit1());
                os.writeByte(((ConnectedSecurityCommand)m).getDigit2());
                os.writeByte(((ConnectedSecurityCommand)m).getDigit3());
                os.writeByte(((ConnectedSecurityCommand)m).getDigit4());
                os.writeByte(((ConnectedSecurityCommand)m).getDigit5());
                os.writeByte(((ConnectedSecurityCommand)m).getDigit6());
                break;
            }
            case 19: {
                Message m = (SetTimeCommand)msg;
                os.writeByte(((SetTimeCommand)m).getYear());
                os.writeByte(((SetTimeCommand)m).getMonth());
                os.writeByte(((SetTimeCommand)m).getDay());
                os.writeByte(((SetTimeCommand)m).getDayOfWeek());
                os.writeByte(((SetTimeCommand)m).getHour());
                os.writeByte(((SetTimeCommand)m).getMinute());
                os.writeBoolean(((SetTimeCommand)m).isDaylightSavings());
                break;
            }
            case 44: {
                Message m = (ActivateKeypadEmergency)msg;
                os.writeByte(((ActivateKeypadEmergency)m).getArea());
                os.writeByte(((ActivateKeypadEmergency)m).getEmergencyType());
                break;
            }
            case 38: {
                Message m = (ReqSecurityCodeValidation)msg;
                os.writeByte(((ReqSecurityCodeValidation)m).getArea());
                os.writeByte(((ReqSecurityCodeValidation)m).getDigit1());
                os.writeByte(((ReqSecurityCodeValidation)m).getDigit2());
                os.writeByte(((ReqSecurityCodeValidation)m).getDigit3());
                os.writeByte(((ReqSecurityCodeValidation)m).getDigit4());
                break;
            }
            case 12: {
                Message m = (WriteName)msg;
                int t = ((WriteName)m).getObjectType();
                os.writeByte(t);
                os.writeShort(((WriteName)m).getObjectNumber());
                byte[] d = t == 1 || t == 7 || t == 8 ? new byte[15] : new byte[12];
                byte[] s = ((WriteName)m).getName().getBytes();
                int cnt = s.length;
                if (s.length > d.length) {
                    cnt = d.length;
                }
                System.arraycopy(s, 0, d, 0, cnt);
                os.write(d);
                break;
            }
            default: {
                throw new OmniUnknownMessageTypeException(msg.getMessageType());
            }
        }
        byte[] data = bos.toByteArray();
        bos.reset();
        os.writeByte(33);
        os.writeByte(data.length);
        os.write(data);
        byte[] crcBytes = new byte[data.length + 1];
        System.arraycopy(data, 0, crcBytes, 1, data.length);
        crcBytes[0] = (byte)data.length;
        int crc = MessageUtils.crc16(crcBytes);
        os.writeByte((byte)crc);
        os.writeByte((byte)(crc >> 8));
        return bos.toByteArray();
    }

    protected static Acknowledge acknowledge() {
        return Acknowledge.getInstance();
    }

    protected static NegativeAcknowledge negativeAcknowledge() {
        return NegativeAcknowledge.getInstance();
    }

    protected static EndOfData endOfData() {
        return EndOfData.getInstance();
    }

    protected static SystemInformation systemInformation(DataInputStream in) throws IOException {
        int model = in.readUnsignedByte();
        int major = in.readUnsignedByte();
        int minor = in.readUnsignedByte();
        int revision = in.readUnsignedByte();
        byte[] phoneBytes = new byte[15];
        in.readFully(phoneBytes);
        String phone = new String(phoneBytes);
        return SystemInformation.builder().model(model).major(major).minor(minor).revision(revision).phone(phone).build();
    }

    protected static SystemStatus systemStatus(DataInputStream in, int len) throws IOException {
        boolean timeDateValid = in.readBoolean();
        int year = in.readUnsignedByte();
        int month = in.readUnsignedByte();
        int day = in.readUnsignedByte();
        int dayOfWeek = in.readUnsignedByte();
        int hour = in.readUnsignedByte();
        int minute = in.readUnsignedByte();
        int second = in.readUnsignedByte();
        boolean daylightSavings = in.readBoolean();
        int sunriseHour = in.readUnsignedByte();
        int sunriseMinute = in.readUnsignedByte();
        int sunsetHour = in.readUnsignedByte();
        int sunsetMinute = in.readUnsignedByte();
        int batteryReading = in.readUnsignedByte();
        SystemStatus.SystemStatusBuilder builder = SystemStatus.builder().timeDateValid(timeDateValid).year(year).month(month).day(day).dayOfWeek(dayOfWeek).hour(hour).minute(minute).second(second).daylightSavings(daylightSavings).sunriseHour(sunriseHour).sunsetMinute(sunsetMinute).sunsetHour(sunsetHour).sunsetMinute(sunsetMinute).batteryReading(batteryReading);
        for (int i = 16; i < len; i += 2) {
            builder.alarm(in.readUnsignedByte(), in.readUnsignedByte());
        }
        return builder.build();
    }

    protected static SystemTroubles systemTroubles(DataInputStream in, int length) throws IOException {
        SystemTroubles.SystemTroublesBuilder builder = SystemTroubles.builder();
        for (int i = 0; i < length; ++i) {
            builder.trouble(in.readUnsignedByte());
        }
        return builder.build();
    }

    protected static SystemFeatures systemFeatures(DataInputStream in, int length) throws IOException {
        SystemFeatures.SystemFeaturesBuilder builder = SystemFeatures.builder();
        for (int i = 0; i < length; ++i) {
            builder.feature(in.readUnsignedByte());
        }
        return builder.build();
    }

    protected static SystemFormats systemFormats(DataInputStream in, int length) throws IOException {
        int tempFormat = in.readUnsignedByte();
        int timeFormat = in.readUnsignedByte();
        int dateFormat = in.readUnsignedByte();
        return SystemFormats.builder().tempFormat(tempFormat).timeFormat(timeFormat).dateFormat(dateFormat).build();
    }

    protected static ObjectTypeCapacities objectTypeCapacities(DataInputStream in, int length) throws IOException {
        int objectType = in.readUnsignedByte();
        int capacity = in.readUnsignedShort();
        return ObjectTypeCapacities.builder().objectType(objectType).capacity(capacity).build();
    }

    protected static ObjectStatus objectStatus(DataInputStream in, int length, boolean extended) throws IOException {
        Status[] status;
        int statusType = in.readUnsignedByte();
        int recordLength = 0;
        if (extended) {
            recordLength = in.readUnsignedByte();
        }
        switch (statusType) {
            case 1: {
                if (!extended) {
                    status = new ZoneStatus[(length - 1) / 4];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ZoneStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).loop(in.readUnsignedByte()).build();
                    }
                } else {
                    status = new ExtendedZoneStatus[(length - 1) / 4];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedZoneStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).loop(in.readUnsignedByte()).build();
                    }
                }
                break;
            }
            case 2: {
                if (!extended) {
                    status = new UnitStatus[(length - 1) / 5];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = UnitStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).time(in.readUnsignedShort()).build();
                    }
                } else {
                    status = new ExtendedUnitStatus[(length - 1) / 5];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedUnitStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).time(in.readUnsignedShort()).build();
                    }
                }
                break;
            }
            case 5: {
                if (!extended) {
                    status = new AreaStatus[(length - 1) / 6];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = AreaStatus.builder().number(in.readUnsignedShort()).mode(in.readUnsignedByte()).alarms(in.readUnsignedByte()).entryTimer(in.readUnsignedByte()).exitTimer(in.readUnsignedByte()).build();
                    }
                } else {
                    status = new ExtendedAreaStatus[(length - 1) / 6];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedAreaStatus.builder().number(in.readUnsignedShort()).mode(in.readUnsignedByte()).alarms(in.readUnsignedByte()).entryTimer(in.readUnsignedByte()).exitTimer(in.readUnsignedByte()).build();
                    }
                }
                break;
            }
            case 6: {
                if (!extended) {
                    status = new ThermostatStatus[(length - 1) / 9];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ThermostatStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).currentTemperature(in.readUnsignedByte()).heatSetpoint(in.readUnsignedByte()).coolSetpoint(in.readUnsignedByte()).systemMode(in.readUnsignedByte()).fanMode(in.readUnsignedByte()).holdStatus(in.readUnsignedByte()).build();
                    }
                } else {
                    status = new ExtendedThermostatStatus[(length - 1) / 14];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedThermostatStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).currentTemperature(in.readUnsignedByte()).heatSetpoint(in.readUnsignedByte()).coolSetpoint(in.readUnsignedByte()).systemMode(in.readUnsignedByte()).fanMode(in.readUnsignedByte()).holdStatus(in.readUnsignedByte()).currentHumidity(in.readUnsignedByte()).humidifySetpoint(in.readUnsignedByte()).dehumidifySetpoint(in.readUnsignedByte()).outdoorTemperature(in.readUnsignedByte()).extendedStatus(in.readUnsignedByte()).build();
                    }
                }
                break;
            }
            case 7: {
                if (!extended) {
                    status = new MessageStatus[(length - 1) / 3];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = MessageStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).build();
                    }
                } else {
                    status = new ExtendedMessageStatus[(length - 1) / 3];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedMessageStatus.builder().number(in.readUnsignedShort()).status(in.readUnsignedByte()).build();
                    }
                }
                break;
            }
            case 8: {
                if (!extended) {
                    status = new AuxSensorStatus[(length - 1) / 6];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = AuxSensorStatus.builder().number(in.readUnsignedShort()).outputStatus(in.readUnsignedByte()).temperature(in.readUnsignedByte()).heatSetpoint(in.readUnsignedByte()).coolSetpoint(in.readUnsignedByte()).build();
                    }
                } else {
                    status = new ExtendedAuxSensorStatus[(length - 1) / 6];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedAuxSensorStatus.builder().number(in.readUnsignedShort()).outputStatus(in.readUnsignedByte()).temperature(in.readUnsignedByte()).heatSetpoint(in.readUnsignedByte()).coolSetpoint(in.readUnsignedByte()).build();
                    }
                }
                break;
            }
            case 10: {
                if (!extended) {
                    status = new AudioZoneStatus[(length - 1) / 6];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = AudioZoneStatus.builder().number(in.readUnsignedShort()).power(in.readBoolean()).source(in.readUnsignedByte()).volume(in.readUnsignedByte()).mute(in.readBoolean()).build();
                    }
                } else {
                    status = new ExtendedAudioZoneStatus[(length - 1) / 6];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedAudioZoneStatus.builder().number(in.readUnsignedShort()).power(in.readBoolean()).source(in.readUnsignedByte()).volume(in.readUnsignedByte()).mute(in.readBoolean()).build();
                    }
                }
                break;
            }
            case 11: {
                if (!extended) {
                    status = new ExpansionStatus[(length - 1) / 4];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExpansionStatus.builder().number(in.readUnsignedShort()).status(in.readBoolean()).battery(in.readUnsignedByte()).build();
                    }
                } else {
                    status = new ExtendedExpansionStatus[(length - 1) / 4];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedExpansionStatus.builder().number(in.readUnsignedShort()).status(in.readBoolean()).battery(in.readUnsignedByte()).build();
                    }
                }
                break;
            }
            case 13: {
                if (!extended) {
                    status = new UserSettingStatus[(length - 1) / 5];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = UserSettingStatus.builder().number(in.readUnsignedShort()).settingType(in.readUnsignedByte()).settingValue(in.readUnsignedShort()).build();
                    }
                } else {
                    status = new ExtendedUserSettingStatus[(length - 1) / 5];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedUserSettingStatus.builder().number(in.readUnsignedShort()).settingType(in.readUnsignedByte()).settingValue(in.readUnsignedShort()).build();
                    }
                }
                break;
            }
            case 14: {
                if (!extended) {
                    status = new AccessControlReaderStatus[(length - 1) / 4];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = AccessControlReaderStatus.builder().number(in.readUnsignedShort()).granted(!in.readBoolean()).lastUser(in.readUnsignedByte()).build();
                    }
                } else {
                    status = new ExtendedAccessControlReaderStatus[(length - 1) / 4];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedAccessControlReaderStatus.builder().number(in.readUnsignedShort()).granted(!in.readBoolean()).lastUser(in.readUnsignedByte()).build();
                    }
                }
                break;
            }
            case 15: {
                if (!extended) {
                    status = new AccessControlReaderLockStatus[(length - 1) / 5];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = AccessControlReaderLockStatus.builder().number(in.readUnsignedShort()).locked(!in.readBoolean()).timer(in.readUnsignedShort()).build();
                    }
                } else {
                    status = new ExtendedAccessControlReaderLockStatus[(length - 1) / 5];
                    for (int i = 0; i < status.length; ++i) {
                        status[i] = ExtendedAccessControlReaderLockStatus.builder().number(in.readUnsignedShort()).locked(!in.readBoolean()).timer(in.readUnsignedShort()).build();
                    }
                }
                break;
            }
            default: {
                throw new IOException("Unknown status type " + statusType);
            }
        }
        if (extended) {
            return ExtendedObjectStatus.extendedBuilder().statusType(statusType).recordLength(recordLength).statuses(status).build();
        }
        return ObjectStatus.builder().statusType(statusType).statuses(status).build();
    }

    private static String readName(byte[] nameBytes) {
        String name = new String(nameBytes);
        if (name.indexOf(0) >= 0) {
            name = name.substring(0, name.indexOf(0));
        }
        return name;
    }

    protected static ObjectProperties objectProperties(DataInputStream in, int length) throws IOException {
        int objectType = in.readUnsignedByte();
        int number = in.readUnsignedShort();
        byte[] nameShort = new byte[12];
        byte[] nameLong = new byte[15];
        switch (objectType) {
            case 1: {
                int status = in.readUnsignedByte();
                int loop = in.readUnsignedByte();
                int type = in.readUnsignedByte();
                int area = in.readUnsignedByte();
                int options = in.readUnsignedByte();
                in.readFully(nameLong);
                String name = MessageFactory.readName(nameLong);
                return ZoneProperties.builder().number(number).status(status).loop(loop).zoneType(type).area(area).options(options).name(name).build();
            }
            case 2: {
                int state = in.readUnsignedByte();
                int time = in.readUnsignedShort();
                int type = in.readUnsignedByte();
                in.readFully(nameShort);
                String name = MessageFactory.readName(nameShort);
                return UnitProperties.builder().number(number).state(state).time(time).unitType(type).name(name).build();
            }
            case 3: {
                in.readFully(nameShort);
                String name = MessageFactory.readName(nameShort);
                return ButtonProperties.builder().number(number).name(name).build();
            }
            case 4: {
                in.readFully(nameShort);
                String name = MessageFactory.readName(nameShort);
                return CodeProperties.builder().number(number).name(name).build();
            }
            case 5: {
                int mode = in.readUnsignedByte();
                int alarms = in.readUnsignedByte();
                int entryTimer = in.readUnsignedByte();
                int exitTimer = in.readUnsignedByte();
                boolean enabled = in.readBoolean();
                int exitDelay = in.readUnsignedByte();
                int entryDelay = in.readUnsignedByte();
                in.readFully(nameShort);
                String name = MessageFactory.readName(nameShort);
                return AreaProperties.builder().number(number).mode(mode).alarms(alarms).entryTimer(entryTimer).exitTimer(exitTimer).enabled(enabled).exitDelay(exitDelay).entryDelay(entryDelay).name(name).build();
            }
            case 6: {
                int status = in.readUnsignedByte();
                int temperature = in.readUnsignedByte();
                int heatSetpoint = in.readUnsignedByte();
                int coolSetpoint = in.readUnsignedByte();
                int mode = in.readUnsignedByte();
                int fan = in.readUnsignedByte();
                int hold = in.readUnsignedByte();
                int thermostatType = in.readUnsignedByte();
                in.readFully(nameShort);
                String name = MessageFactory.readName(nameShort);
                return ThermostatProperties.builder().number(number).status(status).temperature(temperature).heatSetpoint(heatSetpoint).coolSetpoint(coolSetpoint).mode(mode).fan(fan).hold(hold).thermostatType(thermostatType).name(name).build();
            }
            case 7: {
                in.readFully(nameLong);
                String name = MessageFactory.readName(nameLong);
                return MessageProperties.builder().number(number).name(name).build();
            }
            case 8: {
                int status = in.readUnsignedByte();
                int current = in.readUnsignedByte();
                int lowSetpoint = in.readUnsignedByte();
                int highSetpoint = in.readUnsignedByte();
                int sensorType = in.readUnsignedByte();
                in.readFully(nameLong);
                String name = MessageFactory.readName(nameLong);
                return AuxSensorProperties.builder().number(number).status(status).current(current).lowSetpoint(lowSetpoint).highSetpoint(highSetpoint).sensorType(sensorType).name(name).build();
            }
            case 9: {
                in.readFully(nameShort);
                String name = MessageFactory.readName(nameShort);
                return AudioSourceProperties.builder().number(number).name(name).build();
            }
            case 14: {
                boolean lockStatus = in.readBoolean();
                int unlockTimer = in.readUnsignedShort();
                boolean accessDenied = in.readBoolean();
                byte lastUser = in.readByte();
                in.readFully(nameLong);
                String name = MessageFactory.readName(nameLong);
                return AccessControlReaderProperties.builder().number(number).name(name).accessDenied(accessDenied).lastUser(lastUser).lockStatus(lockStatus).unlockTimer(unlockTimer).build();
            }
            case 10: {
                boolean on = in.readBoolean();
                int source = in.readUnsignedByte();
                int volume = in.readUnsignedByte();
                boolean mute = in.readBoolean();
                in.readFully(nameShort);
                String name = MessageFactory.readName(nameShort);
                return AudioZoneProperties.builder().number(number).on(on).source(source).volume(volume).mute(mute).name(name).build();
            }
        }
        throw new IOException("Unknown property type " + objectType);
    }

    protected static AudioSourceStatus audioSourceStatus(DataInputStream in, int length) throws IOException {
        int srcNumber = in.readUnsignedShort();
        int seqNumber = in.readUnsignedByte();
        int pos = in.readUnsignedByte();
        int fieldId = in.readUnsignedByte();
        byte[] data = new byte[length - 5];
        in.readFully(data);
        String sourceData = new String(data);
        return AudioSourceStatus.builder().sourceNumber(srcNumber).sequenceNumber(seqNumber).position(pos).fieldId(fieldId).sourceData(sourceData).build();
    }

    protected static ZoneReadyStatus zoneReadyStatus(DataInputStream in, int length) throws IOException {
        ZoneReadyStatus.ZoneReadyStatusBuilder builder = ZoneReadyStatus.builder();
        for (int i = 0; i < length; ++i) {
            builder.zone(in.readUnsignedByte());
        }
        return builder.build();
    }

    protected static ConnectedSecurityStatus connectedSecurityStatus(DataInputStream in, int length) throws IOException {
        int[] parts = new int[length];
        ConnectedSecurityStatus.ConnectedSecurityStatusBuilder builder = ConnectedSecurityStatus.builder();
        for (int i = 0; i < length / 2; ++i) {
            ConnectedSecurityStatus.Partition partition = new ConnectedSecurityStatus.Partition(in.readUnsignedByte(), in.readUnsignedByte());
            builder.partition(partition);
        }
        return builder.build();
    }

    protected static OtherEventNotifications otherEventNotification(DataInputStream in, int length) throws IOException {
        OtherEventNotifications.OtherEventNotificationsBuilder builder = OtherEventNotifications.builder();
        for (int i = 0; i < length / 2; ++i) {
            builder.notification(in.readUnsignedShort());
        }
        return builder.build();
    }

    protected static EventLogData eventLogData(DataInputStream in, int length) throws IOException {
        int eventNumber = in.readUnsignedShort();
        boolean timeDataValid = in.readBoolean();
        int month = in.readUnsignedByte();
        int day = in.readUnsignedByte();
        int hour = in.readUnsignedByte();
        int minute = in.readUnsignedByte();
        int eventType = in.readUnsignedByte();
        int parameter1 = in.readUnsignedByte();
        int parameter2 = in.readUnsignedShort();
        return EventLogData.builder().eventNumber(eventNumber).timeDataValid(timeDataValid).month(month).day(day).hour(hour).minute(minute).eventType(eventType).parameter1(parameter1).parameter2(parameter2).build();
    }

    protected static NameData nameData(DataInputStream in, int length) throws IOException {
        int objectType = in.readUnsignedByte();
        int objectNumber = in.readUnsignedShort();
        byte[] data = new byte[length - 3];
        in.readFully(data);
        String name = new String(data);
        return NameData.builder().objectType(objectType).objectNumber(objectNumber).name(name).build();
    }

    protected static SecurityCodeValidation securityCodeValidation(DataInputStream in, int length) throws IOException {
        int code = in.readUnsignedByte();
        int level = in.readUnsignedByte();
        return SecurityCodeValidation.builder().codeNumber(code).authorityLevel(level).build();
    }
}

