/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;

public final class SetTimeCommand
implements Message {
    private final int year;
    private final int month;
    private final int day;
    private final int dayOfWeek;
    private final int hour;
    private final int minute;
    private final boolean daylightSavings;

    @Override
    public int getMessageType() {
        return 19;
    }

    public static SetTimeCommandBuilder builder() {
        return new SetTimeCommandBuilder();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public boolean isDaylightSavings() {
        return this.daylightSavings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetTimeCommand)) {
            return false;
        }
        SetTimeCommand other = (SetTimeCommand)o;
        if (this.getYear() != other.getYear()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getDayOfWeek() != other.getDayOfWeek()) {
            return false;
        }
        if (this.getHour() != other.getHour()) {
            return false;
        }
        if (this.getMinute() != other.getMinute()) {
            return false;
        }
        return this.isDaylightSavings() == other.isDaylightSavings();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYear();
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getDay();
        result = result * 59 + this.getDayOfWeek();
        result = result * 59 + this.getHour();
        result = result * 59 + this.getMinute();
        result = result * 59 + (this.isDaylightSavings() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SetTimeCommand(year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", dayOfWeek=" + this.getDayOfWeek() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", daylightSavings=" + this.isDaylightSavings() + ")";
    }

    private SetTimeCommand(int year, int month, int day, int dayOfWeek, int hour, int minute, boolean daylightSavings) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.dayOfWeek = dayOfWeek;
        this.hour = hour;
        this.minute = minute;
        this.daylightSavings = daylightSavings;
    }

    public static class SetTimeCommandBuilder {
        private int year;
        private int month;
        private int day;
        private int dayOfWeek;
        private int hour;
        private int minute;
        private boolean daylightSavings;

        SetTimeCommandBuilder() {
        }

        public SetTimeCommandBuilder year(int year) {
            this.year = year;
            return this;
        }

        public SetTimeCommandBuilder month(int month) {
            this.month = month;
            return this;
        }

        public SetTimeCommandBuilder day(int day) {
            this.day = day;
            return this;
        }

        public SetTimeCommandBuilder dayOfWeek(int dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public SetTimeCommandBuilder hour(int hour) {
            this.hour = hour;
            return this;
        }

        public SetTimeCommandBuilder minute(int minute) {
            this.minute = minute;
            return this;
        }

        public SetTimeCommandBuilder daylightSavings(boolean daylightSavings) {
            this.daylightSavings = daylightSavings;
            return this;
        }

        public SetTimeCommand build() {
            return new SetTimeCommand(this.year, this.month, this.day, this.dayOfWeek, this.hour, this.minute, this.daylightSavings);
        }

        public String toString() {
            return "SetTimeCommand.SetTimeCommandBuilder(year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", dayOfWeek=" + this.dayOfWeek + ", hour=" + this.hour + ", minute=" + this.minute + ", daylightSavings=" + this.daylightSavings + ")";
        }
    }
}

