/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.statuses;

import com.digitaldan.jomnilinkII.MessageTypes.statuses.Status;

public class AudioZoneStatus
extends Status {
    private final boolean power;
    private final int source;
    private final int volume;
    private final boolean mute;

    private AudioZoneStatus(int number, boolean power, int source, int volume, boolean mute) {
        super(number);
        this.power = power;
        this.source = source;
        this.volume = volume;
        this.mute = mute;
    }

    public static AudioZoneStatusBuilder builder() {
        return new AudioZoneStatusBuilder();
    }

    public boolean isPower() {
        return this.power;
    }

    public int getSource() {
        return this.source;
    }

    public int getVolume() {
        return this.volume;
    }

    public boolean isMute() {
        return this.mute;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioZoneStatus)) {
            return false;
        }
        AudioZoneStatus other = (AudioZoneStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPower() != other.isPower()) {
            return false;
        }
        if (this.getSource() != other.getSource()) {
            return false;
        }
        if (this.getVolume() != other.getVolume()) {
            return false;
        }
        return this.isMute() == other.isMute();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AudioZoneStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPower() ? 79 : 97);
        result = result * 59 + this.getSource();
        result = result * 59 + this.getVolume();
        result = result * 59 + (this.isMute() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "AudioZoneStatus(super=" + super.toString() + ", power=" + this.isPower() + ", source=" + this.getSource() + ", volume=" + this.getVolume() + ", mute=" + this.isMute() + ")";
    }

    public static class AudioZoneStatusBuilder {
        private int number;
        private boolean power;
        private int source;
        private int volume;
        private boolean mute;

        AudioZoneStatusBuilder() {
        }

        public AudioZoneStatusBuilder number(int number) {
            this.number = number;
            return this;
        }

        public AudioZoneStatusBuilder power(boolean power) {
            this.power = power;
            return this;
        }

        public AudioZoneStatusBuilder source(int source) {
            this.source = source;
            return this;
        }

        public AudioZoneStatusBuilder volume(int volume) {
            this.volume = volume;
            return this;
        }

        public AudioZoneStatusBuilder mute(boolean mute) {
            this.mute = mute;
            return this;
        }

        public AudioZoneStatus build() {
            return new AudioZoneStatus(this.number, this.power, this.source, this.volume, this.mute);
        }

        public String toString() {
            return "AudioZoneStatus.AudioZoneStatusBuilder(number=" + this.number + ", power=" + this.power + ", source=" + this.source + ", volume=" + this.volume + ", mute=" + this.mute + ")";
        }
    }
}

