/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.statuses;

import com.digitaldan.jomnilinkII.MessageTypes.statuses.Status;

public class ThermostatStatus
extends Status {
    private final int status;
    private final int currentTemperature;
    private final int heatSetpoint;
    private final int coolSetpoint;
    private final int systemMode;
    private final int fanMode;
    private final int holdStatus;

    private ThermostatStatus(int number, int status, int currentTemperature, int heatSetpoint, int coolSetpoint, int systemMode, int fanMode, int holdStatus) {
        super(number);
        this.status = status;
        this.currentTemperature = currentTemperature;
        this.heatSetpoint = heatSetpoint;
        this.coolSetpoint = coolSetpoint;
        this.systemMode = systemMode;
        this.fanMode = fanMode;
        this.holdStatus = holdStatus;
    }

    public static ThermostatStatusBuilder builder() {
        return new ThermostatStatusBuilder();
    }

    public int getStatus() {
        return this.status;
    }

    public int getCurrentTemperature() {
        return this.currentTemperature;
    }

    public int getHeatSetpoint() {
        return this.heatSetpoint;
    }

    public int getCoolSetpoint() {
        return this.coolSetpoint;
    }

    public int getSystemMode() {
        return this.systemMode;
    }

    public int getFanMode() {
        return this.fanMode;
    }

    public int getHoldStatus() {
        return this.holdStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThermostatStatus)) {
            return false;
        }
        ThermostatStatus other = (ThermostatStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.getCurrentTemperature() != other.getCurrentTemperature()) {
            return false;
        }
        if (this.getHeatSetpoint() != other.getHeatSetpoint()) {
            return false;
        }
        if (this.getCoolSetpoint() != other.getCoolSetpoint()) {
            return false;
        }
        if (this.getSystemMode() != other.getSystemMode()) {
            return false;
        }
        if (this.getFanMode() != other.getFanMode()) {
            return false;
        }
        return this.getHoldStatus() == other.getHoldStatus();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ThermostatStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getStatus();
        result = result * 59 + this.getCurrentTemperature();
        result = result * 59 + this.getHeatSetpoint();
        result = result * 59 + this.getCoolSetpoint();
        result = result * 59 + this.getSystemMode();
        result = result * 59 + this.getFanMode();
        result = result * 59 + this.getHoldStatus();
        return result;
    }

    @Override
    public String toString() {
        return "ThermostatStatus(super=" + super.toString() + ", status=" + this.getStatus() + ", currentTemperature=" + this.getCurrentTemperature() + ", heatSetpoint=" + this.getHeatSetpoint() + ", coolSetpoint=" + this.getCoolSetpoint() + ", systemMode=" + this.getSystemMode() + ", fanMode=" + this.getFanMode() + ", holdStatus=" + this.getHoldStatus() + ")";
    }

    public static class ThermostatStatusBuilder {
        private int number;
        private int status;
        private int currentTemperature;
        private int heatSetpoint;
        private int coolSetpoint;
        private int systemMode;
        private int fanMode;
        private int holdStatus;

        ThermostatStatusBuilder() {
        }

        public ThermostatStatusBuilder number(int number) {
            this.number = number;
            return this;
        }

        public ThermostatStatusBuilder status(int status) {
            this.status = status;
            return this;
        }

        public ThermostatStatusBuilder currentTemperature(int currentTemperature) {
            this.currentTemperature = currentTemperature;
            return this;
        }

        public ThermostatStatusBuilder heatSetpoint(int heatSetpoint) {
            this.heatSetpoint = heatSetpoint;
            return this;
        }

        public ThermostatStatusBuilder coolSetpoint(int coolSetpoint) {
            this.coolSetpoint = coolSetpoint;
            return this;
        }

        public ThermostatStatusBuilder systemMode(int systemMode) {
            this.systemMode = systemMode;
            return this;
        }

        public ThermostatStatusBuilder fanMode(int fanMode) {
            this.fanMode = fanMode;
            return this;
        }

        public ThermostatStatusBuilder holdStatus(int holdStatus) {
            this.holdStatus = holdStatus;
            return this;
        }

        public ThermostatStatus build() {
            return new ThermostatStatus(this.number, this.status, this.currentTemperature, this.heatSetpoint, this.coolSetpoint, this.systemMode, this.fanMode, this.holdStatus);
        }

        public String toString() {
            return "ThermostatStatus.ThermostatStatusBuilder(number=" + this.number + ", status=" + this.status + ", currentTemperature=" + this.currentTemperature + ", heatSetpoint=" + this.heatSetpoint + ", coolSetpoint=" + this.coolSetpoint + ", systemMode=" + this.systemMode + ", fanMode=" + this.fanMode + ", holdStatus=" + this.holdStatus + ")";
        }
    }
}

