/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes.systemevents;

import com.digitaldan.jomnilinkII.MessageTypes.systemevents.SystemEventType;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SystemEvent {
    private static final Logger logger = LoggerFactory.getLogger(SystemEvent.class);
    protected final int event;
    protected final SystemEventType type;

    protected SystemEvent(int event, SystemEventType type) {
        this.event = event;
        this.type = type;
    }

    public int getEvent() {
        return this.event;
    }

    public SystemEventType getType() {
        return this.type;
    }

    public static SystemEvent fromEvent(int number) {
        SystemEventType st = SystemEventType.fromInt(number);
        if (st != null) {
            try {
                return (SystemEvent)st.getSystemEventClass().getDeclaredConstructor(Integer.TYPE).newInstance(number);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.warn("Could not create SystemEvent from number " + number, (Throwable)e);
            }
        }
        return null;
    }
}

