/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII;

import com.digitaldan.jomnilinkII.Aes;
import com.digitaldan.jomnilinkII.DisconnectListener;
import com.digitaldan.jomnilinkII.Message;
import com.digitaldan.jomnilinkII.MessageFactory;
import com.digitaldan.jomnilinkII.MessageTypes.ActivateKeypadEmergency;
import com.digitaldan.jomnilinkII.MessageTypes.CommandMessage;
import com.digitaldan.jomnilinkII.MessageTypes.ConnectedSecurityCommand;
import com.digitaldan.jomnilinkII.MessageTypes.ConnectedSecurityStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ExtendedObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.Notifications;
import com.digitaldan.jomnilinkII.MessageTypes.ObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ObjectTypeCapacities;
import com.digitaldan.jomnilinkII.MessageTypes.OtherEventNotifications;
import com.digitaldan.jomnilinkII.MessageTypes.ReadEventRecord;
import com.digitaldan.jomnilinkII.MessageTypes.ReadName;
import com.digitaldan.jomnilinkII.MessageTypes.ReqAudioSourceStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqConnectedSecurityStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqExtendedObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqObjectProperties;
import com.digitaldan.jomnilinkII.MessageTypes.ReqObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqObjectTypeCapacities;
import com.digitaldan.jomnilinkII.MessageTypes.ReqSecurityCodeValidation;
import com.digitaldan.jomnilinkII.MessageTypes.ReqSystemFeatures;
import com.digitaldan.jomnilinkII.MessageTypes.ReqSystemFormats;
import com.digitaldan.jomnilinkII.MessageTypes.ReqSystemInformation;
import com.digitaldan.jomnilinkII.MessageTypes.ReqSystemStatus;
import com.digitaldan.jomnilinkII.MessageTypes.ReqSystemTroubles;
import com.digitaldan.jomnilinkII.MessageTypes.ReqZoneReadyStatus;
import com.digitaldan.jomnilinkII.MessageTypes.SecurityCodeValidation;
import com.digitaldan.jomnilinkII.MessageTypes.SetTimeCommand;
import com.digitaldan.jomnilinkII.MessageTypes.SystemFeatures;
import com.digitaldan.jomnilinkII.MessageTypes.SystemFormats;
import com.digitaldan.jomnilinkII.MessageTypes.SystemInformation;
import com.digitaldan.jomnilinkII.MessageTypes.SystemStatus;
import com.digitaldan.jomnilinkII.MessageTypes.SystemTroubles;
import com.digitaldan.jomnilinkII.MessageTypes.WriteName;
import com.digitaldan.jomnilinkII.MessageTypes.ZoneReadyStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AccessControlReaderLockStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AccessControlReaderStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AreaStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AudioZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AuxSensorStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExpansionStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAccessControlReaderLockStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAccessControlReaderStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAreaStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAudioZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAuxSensorStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedExpansionStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedMessageStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedThermostatStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedUnitStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedUserSettingStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.MessageStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.Status;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ThermostatStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.UnitStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.UserSettingStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.SystemEvent;
import com.digitaldan.jomnilinkII.NotificationListener;
import com.digitaldan.jomnilinkII.OmniInvalidResponseException;
import com.digitaldan.jomnilinkII.OmniNotConnectedException;
import com.digitaldan.jomnilinkII.OmniUnknownMessageTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private static int PACKET_TYPE_CLIENT_REQUEST_NEW_SESSION = 1;
    private static int PACKET_TYPE_CONTROLLER_ACKNOWLEDGE_NEW_SESSION = 2;
    private static int PACKET_TYPE_CLIENT_REQUEST_SECURE_CONNECTION = 3;
    private static int PACKET_TYPE_CONTROLLER_ACKNOWLEDGE_SECURE_CONNECTION = 4;
    private static int PACKET_TYPE_CLIENT_SESSION_TERMINATED = 5;
    private static int PACKET_TYPE_CONTROLLER_SESSION_TERMINATED = 6;
    private static int PACKET_TYPE_CONTROLLER_CANNOT_START_NEW_SESSION = 7;
    private static int PACKET_TYPE_OMNI_LINK_MESSAGE = 32;
    public static int MAX_PACKET_SIZE = 255;
    public static int OMNI_TO = 300000;
    public static int PING_TO = OMNI_TO - 60000;
    public boolean debug;
    private boolean connected;
    private boolean ping = true;
    private long lastTXMessageTime;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private int tx;
    private int rx;
    private Aes aes;
    private Object writeLock = new Object();
    private Exception lastException = null;
    private final BlockingQueue<Message> notifications = new LinkedBlockingQueue<Message>();
    private final List<NotificationListener> notificationListeners;
    private final List<DisconnectListener> disconnectListeners;
    private final BlockingQueue<OmniPacket> responses = new LinkedBlockingQueue<OmniPacket>();
    private ConnectionWatchdog watchdog;

    public Connection(String address, int port, String key) throws Exception, IOException, UnknownHostException {
        int i;
        this.notificationListeners = new CopyOnWriteArrayList<NotificationListener>();
        this.disconnectListeners = new CopyOnWriteArrayList<DisconnectListener>();
        byte[] _key = Connection.hexStringToByteArray(key.replaceAll("\\W", ""));
        this.socket = new Socket(address, port);
        this.is = this.socket.getInputStream();
        this.os = this.socket.getOutputStream();
        this.socket.setSoTimeout(OMNI_TO);
        this.tx = 1;
        this.rx = 1;
        this.sendBytes(new OmniPacket(PACKET_TYPE_CLIENT_REQUEST_NEW_SESSION, null));
        OmniPacket rec = this.readBytes();
        if (rec.type() != PACKET_TYPE_CONTROLLER_ACKNOWLEDGE_NEW_SESSION) {
            throw new Exception("Controller not accepting new connections");
        }
        byte[] data = rec.data();
        int version = (data[0] << 8) + (data[1] << 0);
        logger.debug("Controller version {}", (Object)version);
        byte[] sessionid = new byte[5];
        System.arraycopy(data, 2, sessionid, 0, 5);
        for (i = 0; i < 5; ++i) {
            int n = i + 11;
            _key[n] = (byte)(_key[n] ^ sessionid[i]);
        }
        this.aes = new Aes(_key);
        this.sendBytesEncrypted(new OmniPacket(PACKET_TYPE_CLIENT_REQUEST_SECURE_CONNECTION, sessionid));
        rec = this.readBytesEncrypted();
        if (rec.type() != PACKET_TYPE_CONTROLLER_ACKNOWLEDGE_SECURE_CONNECTION) {
            throw new Exception("Could not establish secure connection");
        }
        data = rec.data();
        for (i = 0; i < 5; ++i) {
            logger.trace("Data {} mine {} controllers {}" + data[i], new Object[]{i, sessionid[i], data[i]});
            if (data[i] == sessionid[i]) continue;
            throw new IOException("Controller returned wrong sessioid");
        }
        this.connected = true;
        this.lastTXMessageTime = System.currentTimeMillis();
        this.setName("OmniReaderThread");
        this.start();
        Thread notificationHandlerThread = new Thread(new NotificationHandler(this.notifications, this.notificationListeners));
        notificationHandlerThread.setName("NotificationHandlerThread");
        notificationHandlerThread.start();
        ConnectionWatchdog watchdog = new ConnectionWatchdog();
        watchdog.setName("ConnectionWatchdogThread");
        watchdog.start();
    }

    public void disconnect() {
        this.connected = false;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.notifications.offer(NotificationHandler.POISON);
    }

    public boolean connected() {
        return this.connected;
    }

    public Exception lastError() {
        return this.lastException;
    }

    public boolean autoPingOmni() {
        return this.ping;
    }

    public void autoPingOmni(boolean ping) {
        this.ping = ping;
    }

    public void addNotificationListener(NotificationListener listener) {
        this.notificationListeners.add(listener);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.notificationListeners.remove(listener);
    }

    public void addDisconnectListener(DisconnectListener listener) {
        this.disconnectListeners.add(listener);
    }

    public void removeDisconnectListener(DisconnectListener listener) {
        this.disconnectListeners.remove(listener);
    }

    public Message sendAndReceive(Message message) throws IOException, OmniNotConnectedException, OmniUnknownMessageTypeException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                if (!this.connected) {
                    throw new OmniNotConnectedException(this.lastError());
                }
                this.sendBytesEncrypted(new OmniPacket(PACKET_TYPE_OMNI_LINK_MESSAGE, MessageFactory.toBytes(message)));
                OmniPacket omniPacket = this.responses.poll(30L, TimeUnit.SECONDS);
                if (omniPacket == null) {
                    throw new IOException("Response not returned from Omni within 30 seconds");
                }
                if (!this.connected) {
                    throw new OmniNotConnectedException(this.lastError());
                }
                this.lastTXMessageTime = System.currentTimeMillis();
                return MessageFactory.fromBytes(omniPacket.data());
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Override
    public void run() {
        while (this.connected) {
            try {
                OmniPacket omniPacket = this.readBytesEncryptedExtended();
                if (omniPacket.seq() == 0 && omniPacket.type() == PACKET_TYPE_OMNI_LINK_MESSAGE) {
                    this.notifications.put(MessageFactory.fromBytes(omniPacket.data()));
                    logger.debug("run: NOTIFICATION: Added message with type {}", (Object)omniPacket.type);
                    continue;
                }
                if (omniPacket.type() == PACKET_TYPE_OMNI_LINK_MESSAGE) {
                    this.responses.put(omniPacket);
                    continue;
                }
                throw new IOException("Non omnilink message");
            }
            catch (OmniUnknownMessageTypeException e) {
                logger.debug("run: Uknown Messgage type {}  Continuing", (Object)e.getUnknowMessageType());
            }
            catch (Exception e) {
                this.disconnect();
                this.lastException = e;
                this.notifyDisconnectHandlers(this.lastException);
            }
        }
        logger.debug("run: not connected, thread exiting");
    }

    private void sendBytesEncrypted(OmniPacket p) throws IOException {
        byte[] encData;
        int i;
        logger.trace("TX: {}", (Object)this.bytesToString(p.data()));
        int txlength = p.data().length + 15 & 0xFFFFFFF0;
        byte[] paddedData = new byte[txlength];
        System.arraycopy(p.data(), 0, paddedData, 0, p.data().length);
        for (i = p.data().length; i < txlength; ++i) {
            paddedData[i] = 0;
        }
        for (i = 0; i < txlength / 16; ++i) {
            int n = 0 + 16 * i;
            paddedData[n] = (byte)(paddedData[n] ^ this.tx >> 8 & 0xFF);
            int n2 = 1 + 16 * i;
            paddedData[n2] = (byte)(paddedData[n2] ^ this.tx & 0xFF);
        }
        try {
            encData = this.aes.encrypt(paddedData);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.sendBytes(new OmniPacket(p.type(), encData));
    }

    private void sendBytes(OmniPacket p) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeShort(this.tx);
        dout.writeByte(p.type());
        dout.writeByte(0);
        if (p.data() != null) {
            dout.write(p.data());
        }
        this.os.write(bout.toByteArray());
        this.os.flush();
        ++this.tx;
        if (this.tx >= 65535) {
            this.tx = 1;
        }
    }

    private OmniPacket readBytesEncrypted() throws IOException, SocketTimeoutException {
        OmniPacket p = this.readBytes();
        logger.trace("Enc Dec " + this.bytesToString(p.data()));
        if (p.data().length == 0) {
            return p;
        }
        byte[] decData = this.aes.decrypt(p.data());
        for (int i = 0; i < decData.length / 16; ++i) {
            int n = 0 + 16 * i;
            decData[n] = (byte)(decData[n] ^ p.seq >> 8 & 0xFF);
            int n2 = 1 + 16 * i;
            decData[n2] = (byte)(decData[n2] ^ p.seq & 0xFF);
        }
        logger.trace("Data Dec {}", (Object)this.bytesToString(decData));
        return new OmniPacket(p.seq, p.type(), decData);
    }

    private OmniPacket readBytesEncryptedExtended() throws IOException, SocketTimeoutException {
        DataInputStream dis = new DataInputStream(this.is);
        logger.trace("Bytes available for reading: {}", (Object)this.is.available());
        int seq = dis.readUnsignedShort();
        int type = dis.readUnsignedByte();
        int reserved = dis.readUnsignedByte();
        byte[] encData = new byte[16];
        dis.readFully(encData);
        byte[] decData = this.aes.decrypt(encData);
        decData[0] = (byte)(decData[0] ^ seq >> 8 & 0xFF);
        decData[1] = (byte)(decData[1] ^ seq & 0xFF);
        if (type != PACKET_TYPE_OMNI_LINK_MESSAGE) {
            logger.trace("NON OMNI LINK PACKET: {} RX Bytes: {}", (Object)type, (Object)this.bytesToString(decData));
            return new OmniPacket(seq, type, decData);
        }
        int start = decData[0] & 0xFF;
        int length = decData[1] & 0xFF;
        if (start != 33) {
            logger.debug("invalid start char ({})", (Object)start);
        }
        if (length < 0) {
            throw new IOException("invalid message length (" + length + ")");
        }
        logger.trace("Omni message Length {}", (Object)length);
        int readLength = ((length + 3) / 16 + 1) * 16 - 16;
        logger.trace("Additional bytes to read {}", (Object)readLength);
        if (readLength > 0) {
            byte[] decData2 = new byte[decData.length + readLength];
            encData = new byte[readLength];
            System.arraycopy(decData, 0, decData2, 0, decData.length);
            dis.readFully(encData);
            this.aes.decrypt(encData, 0, readLength, decData2, decData.length);
            for (int i = 1; i < decData2.length / 16; ++i) {
                int n = 0 + 16 * i;
                decData2[n] = (byte)(decData2[n] ^ seq >> 8 & 0xFF);
                int n2 = 1 + 16 * i;
                decData2[n2] = (byte)(decData2[n2] ^ seq & 0xFF);
            }
            decData = decData2;
        }
        logger.trace("RX: {} Data still available after read {}", (Object)this.bytesToString(decData), (Object)this.is.available());
        return new OmniPacket(seq, type, decData);
    }

    private OmniPacket readBytes() throws IOException, SocketTimeoutException {
        byte[] data = new byte[MAX_PACKET_SIZE];
        int cnt = this.is.read(data);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        int seq = dis.readUnsignedShort();
        int type = dis.readUnsignedByte();
        int reserved = dis.readUnsignedByte();
        byte[] msgdata = new byte[cnt - 4];
        dis.readFully(msgdata);
        return new OmniPacket(seq, type, msgdata);
    }

    public void enableNotifications() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(Notifications.enable());
        if (msg.getMessageType() != 1) {
            throw new OmniInvalidResponseException(msg);
        }
    }

    public SystemInformation reqSystemInformation() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqSystemInformation.getInstance());
        if (msg.getMessageType() != 23) {
            throw new OmniInvalidResponseException(msg);
        }
        return (SystemInformation)msg;
    }

    public SystemStatus reqSystemStatus() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqSystemStatus.getInstance());
        if (msg.getMessageType() != 25) {
            throw new OmniInvalidResponseException(msg);
        }
        return (SystemStatus)msg;
    }

    public SystemTroubles reqSystemTroubles() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqSystemTroubles.getInstance());
        if (msg.getMessageType() != 27) {
            throw new OmniInvalidResponseException(msg);
        }
        return (SystemTroubles)msg;
    }

    public SystemFeatures reqSystemFeatures() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqSystemFeatures.getInstance());
        if (msg.getMessageType() != 29) {
            throw new OmniInvalidResponseException(msg);
        }
        return (SystemFeatures)msg;
    }

    public SystemFormats reqSystemFormats() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqSystemFormats.getInstance());
        if (msg.getMessageType() != 41) {
            throw new OmniInvalidResponseException(msg);
        }
        return (SystemFormats)msg;
    }

    public ObjectTypeCapacities reqObjectTypeCapacities(int objectType) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqObjectTypeCapacities.builder().objectType(objectType).build());
        if (msg.getMessageType() != 31) {
            throw new OmniInvalidResponseException(msg);
        }
        return (ObjectTypeCapacities)msg;
    }

    public Message reqObjectProperties(int objectType, int objectNum, int direction, int filter1, int filter2, int filter3) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        ReqObjectProperties reqObjectProperties = ReqObjectProperties.builder().objectType(objectType).objectNumber(objectNum).direction(direction).filter1(filter1).filter2(filter2).filter3(filter3).build();
        Message msg = this.sendAndReceive(reqObjectProperties);
        if (msg.getMessageType() != 33 && msg.getMessageType() != 3) {
            throw new OmniInvalidResponseException(msg);
        }
        return msg;
    }

    public ObjectStatus reqObjectStatus(int objectType, int startObject, int endObject) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        return this.reqObjectStatus(objectType, startObject, endObject, false);
    }

    public ExtendedObjectStatus reqExtendedObjectStatus(int objectType, int startObject, int endObject) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        return (ExtendedObjectStatus)this.reqObjectStatus(objectType, startObject, endObject, true);
    }

    public ObjectStatus reqObjectStatus(int objectType, int startObject, int endObject, boolean extended) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        int current;
        Status[] s = null;
        switch (objectType) {
            case 1: {
                if (extended) {
                    s = new ExtendedZoneStatus[endObject - startObject + 1];
                    break;
                }
                s = new ZoneStatus[endObject - startObject + 1];
                break;
            }
            case 2: {
                if (extended) {
                    s = new ExtendedUnitStatus[endObject - startObject + 1];
                    break;
                }
                s = new UnitStatus[endObject - startObject + 1];
                break;
            }
            case 5: {
                if (extended) {
                    s = new ExtendedAreaStatus[endObject - startObject + 1];
                    break;
                }
                s = new AreaStatus[endObject - startObject + 1];
                break;
            }
            case 6: {
                if (extended) {
                    s = new ExtendedThermostatStatus[endObject - startObject + 1];
                    break;
                }
                s = new ThermostatStatus[endObject - startObject + 1];
                break;
            }
            case 7: {
                if (extended) {
                    s = new ExtendedMessageStatus[endObject - startObject + 1];
                    break;
                }
                s = new MessageStatus[endObject - startObject + 1];
                break;
            }
            case 8: {
                if (extended) {
                    s = new ExtendedAuxSensorStatus[endObject - startObject + 1];
                    break;
                }
                s = new AuxSensorStatus[endObject - startObject + 1];
                break;
            }
            case 10: {
                if (extended) {
                    s = new ExtendedAudioZoneStatus[endObject - startObject + 1];
                    break;
                }
                s = new AudioZoneStatus[endObject - startObject + 1];
                break;
            }
            case 11: {
                if (extended) {
                    s = new ExtendedExpansionStatus[endObject - startObject + 1];
                    break;
                }
                s = new ExpansionStatus[endObject - startObject + 1];
                break;
            }
            case 13: {
                if (extended) {
                    s = new ExtendedUserSettingStatus[endObject - startObject + 1];
                    break;
                }
                s = new UserSettingStatus[endObject - startObject + 1];
                break;
            }
            case 14: {
                if (extended) {
                    s = new ExtendedAccessControlReaderStatus[endObject - startObject + 1];
                    break;
                }
                s = new AccessControlReaderStatus[endObject - startObject + 1];
                break;
            }
            case 15: {
                if (extended) {
                    s = new ExtendedAccessControlReaderLockStatus[endObject - startObject + 1];
                    break;
                }
                s = new AccessControlReaderLockStatus[endObject - startObject + 1];
                break;
            }
        }
        int next = current = startObject;
        while (current <= endObject) {
            if ((next += 25) > endObject) {
                next = endObject;
            }
            Message msg = null;
            msg = extended ? this.sendAndReceive(ReqExtendedObjectStatus.builder().objectType(objectType).startObject(current).endObject(next).build()) : this.sendAndReceive(ReqObjectStatus.builder().objectType(objectType).startObject(current).endObject(next).build());
            if (msg.getMessageType() != 35 && msg.getMessageType() != 59) {
                throw new OmniInvalidResponseException(msg);
            }
            System.arraycopy(((ObjectStatus)msg).getStatuses(), 0, s, current - startObject, next - current + 1);
            current = next;
            if (current == endObject) break;
            logger.trace("Current: {}  end: {} ", (Object)current, (Object)endObject);
        }
        return ObjectStatus.builder().statusType(objectType).statuses(s).build();
    }

    public Message reqAudioSourceStatus(int source, int position) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqAudioSourceStatus.builder().source(source).position(position).build());
        if (msg.getMessageType() != 49 && msg.getMessageType() != 3) {
            throw new OmniInvalidResponseException(msg);
        }
        return msg;
    }

    public ZoneReadyStatus reqZoneReadyStatus() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqZoneReadyStatus.getInstance());
        if (msg.getMessageType() != 57) {
            throw new OmniInvalidResponseException(msg);
        }
        return (ZoneReadyStatus)msg;
    }

    public ConnectedSecurityStatus reqConnectedSecurityStatus() throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqConnectedSecurityStatus.getInstance());
        if (msg.getMessageType() != 46) {
            throw new OmniInvalidResponseException(msg);
        }
        return (ConnectedSecurityStatus)msg;
    }

    public Message readEventRecord(int number, int direction) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReadEventRecord.builder().eventNumber(number).direction(direction).build());
        if (msg.getMessageType() != 37 && msg.getMessageType() != 3) {
            throw new OmniInvalidResponseException(msg);
        }
        return msg;
    }

    public Message readName(int objectType, int objectNumber) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReadName.builder().objectType(objectType).objectNumber(objectNumber).build());
        if (msg.getMessageType() != 14 && msg.getMessageType() != 3) {
            throw new OmniInvalidResponseException(msg);
        }
        return msg;
    }

    public void writeName(int objectType, int objectNumber, String name) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(WriteName.builder().objectType(objectType).objectNumber(objectNumber).name(name).build());
        if (msg.getMessageType() != 1) {
            throw new OmniInvalidResponseException(msg);
        }
    }

    public void connectedSecurityCommand(int command, int partition, int digit1, int digit2, int digit3, int digit4, int digit5, int digit6) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        ConnectedSecurityCommand connectedSecurityCommand = ConnectedSecurityCommand.builder().command(command).partition(partition).digit1(digit1).digit2(digit2).digit3(digit3).digit4(digit4).digit5(digit5).digit6(digit6).build();
        Message msg = this.sendAndReceive(connectedSecurityCommand);
        if (msg.getMessageType() != 1) {
            throw new OmniInvalidResponseException(msg);
        }
    }

    public void controllerCommand(int command, int p1, int p2) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(CommandMessage.builder().command(command).parameter1(p1).parameter2(p2).build());
        if (msg.getMessageType() != 1) {
            throw new OmniInvalidResponseException(msg);
        }
    }

    public void setTimeCommand(int year, int month, int day, int dayOfWeek, int hour, int minute, boolean daylightSavings) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(SetTimeCommand.builder().year(year).month(month).day(day).dayOfWeek(dayOfWeek).hour(hour).minute(minute).daylightSavings(daylightSavings).build());
        if (msg.getMessageType() != 1) {
            throw new OmniInvalidResponseException(msg);
        }
    }

    public void activateKeypadEmergency(int area, int emergencyType) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ActivateKeypadEmergency.builder().area(area).emergencyType(emergencyType).build());
        if (msg.getMessageType() != 1) {
            throw new OmniInvalidResponseException(msg);
        }
    }

    public SecurityCodeValidation reqSecurityCodeValidation(int area, int digit1, int digit2, int digit3, int digit4) throws IOException, OmniNotConnectedException, OmniInvalidResponseException, OmniUnknownMessageTypeException {
        Message msg = this.sendAndReceive(ReqSecurityCodeValidation.builder().area(area).digit1(digit1).digit2(digit2).digit3(digit3).digit4(digit4).build());
        if (msg.getMessageType() != 39) {
            throw new OmniInvalidResponseException(msg);
        }
        return (SecurityCodeValidation)msg;
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private String bytesToString(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            buff.append("0x");
            buff.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            buff.append(" ");
        }
        return buff.toString();
    }

    private void notifyDisconnectHandlers(Exception e) {
        for (DisconnectListener l : this.disconnectListeners) {
            l.notConnectedEvent(e);
        }
    }

    private static class NotificationHandler
    implements Runnable {
        public static final Message POISON = new Message(){

            @Override
            public int getMessageType() {
                return 0;
            }
        };
        private final BlockingQueue<Message> notifications;
        private final List<NotificationListener> listeners;
        private boolean alive = true;

        private NotificationHandler(BlockingQueue<Message> notifications, List<NotificationListener> listeners) {
            this.notifications = notifications;
            this.listeners = listeners;
        }

        @Override
        public void run() {
            while (this.alive) {
                try {
                    Message message = this.notifications.take();
                    if (message == POISON) {
                        this.alive = false;
                        continue;
                    }
                    for (NotificationListener listener : this.listeners) {
                        if (message instanceof ObjectStatus) {
                            listener.objectStatusNotification((ObjectStatus)message);
                            continue;
                        }
                        if (message instanceof OtherEventNotifications) {
                            for (int i : ((OtherEventNotifications)message).getNotifications()) {
                                SystemEvent se = SystemEvent.fromEvent(i);
                                if (se == null) continue;
                                listener.systemEventNotification(se);
                            }
                            continue;
                        }
                        logger.debug("Unhandled notficiation message: {}", (Object)message);
                    }
                }
                catch (Throwable t) {
                    logger.error("Notification Handler Caught Exception", t);
                    t.printStackTrace();
                }
            }
        }
    }

    private class ConnectionWatchdog
    extends Thread {
        private ConnectionWatchdog() {
        }

        @Override
        public void run() {
            this.setName("ConnectionWatchdog");
            while (Connection.this.connected) {
                if (Connection.this.ping && System.currentTimeMillis() >= (long)PING_TO + Connection.this.lastTXMessageTime) {
                    logger.debug("Pinging Server");
                    try {
                        Connection.this.reqSystemStatus();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    ConnectionWatchdog.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class OmniPacket {
        private int seq;
        private int type;
        private byte[] data;

        public OmniPacket(int seq, int type, byte[] data) {
            this.seq = seq;
            this.type = type;
            this.data = data;
        }

        public OmniPacket(int type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        public int seq() {
            return this.seq;
        }

        public int type() {
            return this.type;
        }

        public byte[] data() {
            return this.data;
        }
    }
}

