/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;

public final class EventLogData
implements Message {
    private final int eventNumber;
    private final boolean timeDataValid;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int eventType;
    private final int parameter1;
    private final int parameter2;

    @Override
    public int getMessageType() {
        return 37;
    }

    public static EventLogDataBuilder builder() {
        return new EventLogDataBuilder();
    }

    public int getEventNumber() {
        return this.eventNumber;
    }

    public boolean isTimeDataValid() {
        return this.timeDataValid;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getParameter1() {
        return this.parameter1;
    }

    public int getParameter2() {
        return this.parameter2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventLogData)) {
            return false;
        }
        EventLogData other = (EventLogData)o;
        if (this.getEventNumber() != other.getEventNumber()) {
            return false;
        }
        if (this.isTimeDataValid() != other.isTimeDataValid()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getHour() != other.getHour()) {
            return false;
        }
        if (this.getMinute() != other.getMinute()) {
            return false;
        }
        if (this.getEventType() != other.getEventType()) {
            return false;
        }
        if (this.getParameter1() != other.getParameter1()) {
            return false;
        }
        return this.getParameter2() == other.getParameter2();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEventNumber();
        result = result * 59 + (this.isTimeDataValid() ? 79 : 97);
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getDay();
        result = result * 59 + this.getHour();
        result = result * 59 + this.getMinute();
        result = result * 59 + this.getEventType();
        result = result * 59 + this.getParameter1();
        result = result * 59 + this.getParameter2();
        return result;
    }

    public String toString() {
        return "EventLogData(eventNumber=" + this.getEventNumber() + ", timeDataValid=" + this.isTimeDataValid() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", eventType=" + this.getEventType() + ", parameter1=" + this.getParameter1() + ", parameter2=" + this.getParameter2() + ")";
    }

    private EventLogData(int eventNumber, boolean timeDataValid, int month, int day, int hour, int minute, int eventType, int parameter1, int parameter2) {
        this.eventNumber = eventNumber;
        this.timeDataValid = timeDataValid;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.eventType = eventType;
        this.parameter1 = parameter1;
        this.parameter2 = parameter2;
    }

    public static class EventLogDataBuilder {
        private int eventNumber;
        private boolean timeDataValid;
        private int month;
        private int day;
        private int hour;
        private int minute;
        private int eventType;
        private int parameter1;
        private int parameter2;

        EventLogDataBuilder() {
        }

        public EventLogDataBuilder eventNumber(int eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public EventLogDataBuilder timeDataValid(boolean timeDataValid) {
            this.timeDataValid = timeDataValid;
            return this;
        }

        public EventLogDataBuilder month(int month) {
            this.month = month;
            return this;
        }

        public EventLogDataBuilder day(int day) {
            this.day = day;
            return this;
        }

        public EventLogDataBuilder hour(int hour) {
            this.hour = hour;
            return this;
        }

        public EventLogDataBuilder minute(int minute) {
            this.minute = minute;
            return this;
        }

        public EventLogDataBuilder eventType(int eventType) {
            this.eventType = eventType;
            return this;
        }

        public EventLogDataBuilder parameter1(int parameter1) {
            this.parameter1 = parameter1;
            return this;
        }

        public EventLogDataBuilder parameter2(int parameter2) {
            this.parameter2 = parameter2;
            return this;
        }

        public EventLogData build() {
            return new EventLogData(this.eventNumber, this.timeDataValid, this.month, this.day, this.hour, this.minute, this.eventType, this.parameter1, this.parameter2);
        }

        public String toString() {
            return "EventLogData.EventLogDataBuilder(eventNumber=" + this.eventNumber + ", timeDataValid=" + this.timeDataValid + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", eventType=" + this.eventType + ", parameter1=" + this.parameter1 + ", parameter2=" + this.parameter2 + ")";
        }
    }
}

