/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;

public final class ReadEventRecord
implements Message {
    private final int eventNumber;
    private final int direction;

    @Override
    public int getMessageType() {
        return 36;
    }

    public static ReadEventRecordBuilder builder() {
        return new ReadEventRecordBuilder();
    }

    public int getEventNumber() {
        return this.eventNumber;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadEventRecord)) {
            return false;
        }
        ReadEventRecord other = (ReadEventRecord)o;
        if (this.getEventNumber() != other.getEventNumber()) {
            return false;
        }
        return this.getDirection() == other.getDirection();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEventNumber();
        result = result * 59 + this.getDirection();
        return result;
    }

    public String toString() {
        return "ReadEventRecord(eventNumber=" + this.getEventNumber() + ", direction=" + this.getDirection() + ")";
    }

    private ReadEventRecord(int eventNumber, int direction) {
        this.eventNumber = eventNumber;
        this.direction = direction;
    }

    public static class ReadEventRecordBuilder {
        private int eventNumber;
        private int direction;

        ReadEventRecordBuilder() {
        }

        public ReadEventRecordBuilder eventNumber(int eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public ReadEventRecordBuilder direction(int direction) {
            this.direction = direction;
            return this;
        }

        public ReadEventRecord build() {
            return new ReadEventRecord(this.eventNumber, this.direction);
        }

        public String toString() {
            return "ReadEventRecord.ReadEventRecordBuilder(eventNumber=" + this.eventNumber + ", direction=" + this.direction + ")";
        }
    }
}

