/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;
import com.digitaldan.jomnilinkII.MessageTypes.ReqObjectStatus;

public class ReqExtendedObjectStatus
implements Message {
    private final ReqObjectStatus reqObjectStatus;

    private ReqExtendedObjectStatus(int objectType, int startObject, int endObject) {
        this.reqObjectStatus = ReqObjectStatus.builder().objectType(objectType).startObject(startObject).endObject(endObject).build();
    }

    @Override
    public int getMessageType() {
        return 58;
    }

    public static ReqExtendedObjectStatusBuilder builder() {
        return new ReqExtendedObjectStatusBuilder();
    }

    public int getObjectType() {
        return this.reqObjectStatus.getObjectType();
    }

    public int getStartObject() {
        return this.reqObjectStatus.getStartObject();
    }

    public int getEndObject() {
        return this.reqObjectStatus.getEndObject();
    }

    public static class ReqExtendedObjectStatusBuilder {
        private int objectType;
        private int startObject;
        private int endObject;

        ReqExtendedObjectStatusBuilder() {
        }

        public ReqExtendedObjectStatusBuilder objectType(int objectType) {
            this.objectType = objectType;
            return this;
        }

        public ReqExtendedObjectStatusBuilder startObject(int startObject) {
            this.startObject = startObject;
            return this;
        }

        public ReqExtendedObjectStatusBuilder endObject(int endObject) {
            this.endObject = endObject;
            return this;
        }

        public ReqExtendedObjectStatus build() {
            return new ReqExtendedObjectStatus(this.objectType, this.startObject, this.endObject);
        }

        public String toString() {
            return "ReqExtendedObjectStatus.ReqExtendedObjectStatusBuilder(objectType=" + this.objectType + ", startObject=" + this.startObject + ", endObject=" + this.endObject + ")";
        }
    }
}

