/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.MessageTypes;

import com.digitaldan.jomnilinkII.Message;

public final class ReqObjectStatus
implements Message {
    private final int objectType;
    private final int startObject;
    private final int endObject;

    @Override
    public int getMessageType() {
        return 34;
    }

    public static ReqObjectStatusBuilder builder() {
        return new ReqObjectStatusBuilder();
    }

    public int getObjectType() {
        return this.objectType;
    }

    public int getStartObject() {
        return this.startObject;
    }

    public int getEndObject() {
        return this.endObject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReqObjectStatus)) {
            return false;
        }
        ReqObjectStatus other = (ReqObjectStatus)o;
        if (this.getObjectType() != other.getObjectType()) {
            return false;
        }
        if (this.getStartObject() != other.getStartObject()) {
            return false;
        }
        return this.getEndObject() == other.getEndObject();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getObjectType();
        result = result * 59 + this.getStartObject();
        result = result * 59 + this.getEndObject();
        return result;
    }

    public String toString() {
        return "ReqObjectStatus(objectType=" + this.getObjectType() + ", startObject=" + this.getStartObject() + ", endObject=" + this.getEndObject() + ")";
    }

    private ReqObjectStatus(int objectType, int startObject, int endObject) {
        this.objectType = objectType;
        this.startObject = startObject;
        this.endObject = endObject;
    }

    public static class ReqObjectStatusBuilder {
        private int objectType;
        private int startObject;
        private int endObject;

        ReqObjectStatusBuilder() {
        }

        public ReqObjectStatusBuilder objectType(int objectType) {
            this.objectType = objectType;
            return this;
        }

        public ReqObjectStatusBuilder startObject(int startObject) {
            this.startObject = startObject;
            return this;
        }

        public ReqObjectStatusBuilder endObject(int endObject) {
            this.endObject = endObject;
            return this;
        }

        public ReqObjectStatus build() {
            return new ReqObjectStatus(this.objectType, this.startObject, this.endObject);
        }

        public String toString() {
            return "ReqObjectStatus.ReqObjectStatusBuilder(objectType=" + this.objectType + ", startObject=" + this.startObject + ", endObject=" + this.endObject + ")";
        }
    }
}

