/*
 * Decompiled with CFR 0.152.
 */
package com.digitaldan.jomnilinkII.examples;

import com.digitaldan.jomnilinkII.Connection;
import com.digitaldan.jomnilinkII.DisconnectListener;
import com.digitaldan.jomnilinkII.Message;
import com.digitaldan.jomnilinkII.MessageTypes.AudioSourceStatus;
import com.digitaldan.jomnilinkII.MessageTypes.EventLogData;
import com.digitaldan.jomnilinkII.MessageTypes.ObjectProperties;
import com.digitaldan.jomnilinkII.MessageTypes.ObjectStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AccessControlReaderLockStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AccessControlReaderStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AreaStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AudioZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.AuxSensorStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAccessControlReaderLockStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAccessControlReaderStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAreaStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAudioZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedAuxSensorStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedMessageStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedThermostatStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedUnitStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedUserSettingStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ExtendedZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.MessageStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ThermostatStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.UnitStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.UserSettingStatus;
import com.digitaldan.jomnilinkII.MessageTypes.statuses.ZoneStatus;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.ButtonEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.SystemEvent;
import com.digitaldan.jomnilinkII.MessageTypes.systemevents.UPBLinkEvent;
import com.digitaldan.jomnilinkII.NotificationListener;
import com.digitaldan.jomnilinkII.OmniInvalidResponseException;
import com.digitaldan.jomnilinkII.OmniNotConnectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        try {
            int i;
            ObjectStatus status;
            Message m;
            if (args.length != 3) {
                logger.info("Usage:com.digitaldan.jomnilinkII.Main host port encKey");
                System.exit(-1);
            }
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            String key = args[2];
            Connection c = new Connection(host, port, key);
            c.debug = true;
            c.addNotificationListener(new NotificationListener(){

                @Override
                public void objectStatusNotification(ObjectStatus s) {
                    switch (s.getStatusType()) {
                        case 5: {
                            logger.info("STATUS_AREA changed");
                            break;
                        }
                        case 10: {
                            logger.info("STATUS_AUDIO_ZONE changed");
                            break;
                        }
                        case 8: {
                            logger.info("STATUS_AUX changed");
                            break;
                        }
                        case 11: {
                            logger.info("STATUS_EXP changed");
                            break;
                        }
                        case 7: {
                            logger.info("STATUS_MESG changed");
                            break;
                        }
                        case 6: {
                            logger.info("STATUS_THERMO changed");
                            break;
                        }
                        case 2: {
                            logger.info("STATUS_UNIT changed");
                            break;
                        }
                        case 1: {
                            logger.info("STATUS_ZONE changed");
                            break;
                        }
                        default: {
                            logger.info("Unknown type " + s.getStatusType());
                        }
                    }
                    logger.info(s.toString());
                }

                @Override
                public void systemEventNotification(SystemEvent event) {
                    logger.info("Got SystemEvent type {}", (Object)event.getType());
                    switch (event.getType()) {
                        case UPB_LINK: {
                            UPBLinkEvent linkEvent = (UPBLinkEvent)event;
                            logger.info("UPB Link command({}) for link({})", (Object)linkEvent.getLinkCommand(), (Object)linkEvent.getLinkNumber());
                            break;
                        }
                        case BUTTON: {
                            logger.info("ButtonEvent number {}", (Object)((ButtonEvent)event).getButtonNumber());
                            break;
                        }
                        case PHONE_LINE_OFF_HOOK: {
                            logger.info("PHONE_LINE_OFF_HOOK event");
                            break;
                        }
                    }
                }
            });
            c.addDisconnectListener(new DisconnectListener(){

                @Override
                public void notConnectedEvent(Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            });
            c.enableNotifications();
            logger.info(c.reqSystemInformation().toString());
            logger.info(c.reqSystemStatus().toString());
            logger.info(c.reqSystemTroubles().toString());
            logger.info(c.reqSystemFormats().toString());
            logger.info(c.reqSystemFeatures().toString());
            logger.info(c.reqObjectTypeCapacities(1).toString());
            logger.info(c.reqObjectTypeCapacities(2).toString());
            logger.info(c.reqObjectTypeCapacities(3).toString());
            logger.info(c.reqObjectTypeCapacities(4).toString());
            logger.info(c.reqObjectTypeCapacities(5).toString());
            logger.info(c.reqObjectTypeCapacities(6).toString());
            logger.info(c.reqObjectTypeCapacities(7).toString());
            logger.info(c.reqObjectTypeCapacities(9).toString());
            logger.info(c.reqObjectTypeCapacities(10).toString());
            logger.info(c.reqObjectTypeCapacities(11).toString());
            logger.info(c.reqObjectTypeCapacities(12).toString());
            logger.info(c.reqObjectTypeCapacities(13).toString());
            logger.info(c.reqObjectTypeCapacities(14).toString());
            int zoneNum = 0;
            while ((m = c.reqObjectProperties(1, zoneNum, 1, 1, 255, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                zoneNum = ((ObjectProperties)m).getNumber();
            }
            int unitNum = 0;
            while ((m = c.reqObjectProperties(2, unitNum, 1, 1, 255, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                unitNum = ((ObjectProperties)m).getNumber();
            }
            int buttonNum = 0;
            while ((m = c.reqObjectProperties(3, buttonNum, 1, 1, 255, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                buttonNum = ((ObjectProperties)m).getNumber();
            }
            int codeNum = 0;
            while ((m = c.reqObjectProperties(4, codeNum, 1, 1, 255, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                codeNum = ((ObjectProperties)m).getNumber();
            }
            int areaNum = 0;
            while ((m = c.reqObjectProperties(5, areaNum, 1, 0, 0, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                areaNum = ((ObjectProperties)m).getNumber();
            }
            int thermoNum = 0;
            while ((m = c.reqObjectProperties(6, thermoNum, 1, 1, 255, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                thermoNum = ((ObjectProperties)m).getNumber();
            }
            int messageNum = 0;
            while ((m = c.reqObjectProperties(7, messageNum, 1, 1, 255, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                messageNum = ((ObjectProperties)m).getNumber();
            }
            int auxNum = 0;
            while ((m = c.reqObjectProperties(8, auxNum, 1, 1, 255, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                auxNum = ((ObjectProperties)m).getNumber();
            }
            int audioSourceNum = 0;
            while ((m = c.reqObjectProperties(9, audioSourceNum, 1, 1, 0, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                audioSourceNum = ((ObjectProperties)m).getNumber();
            }
            int audioZoneNum = 0;
            while ((m = c.reqObjectProperties(10, audioZoneNum, 1, 1, 0, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                audioZoneNum = ((ObjectProperties)m).getNumber();
            }
            int userSettingNum = 0;
            while ((m = c.reqObjectProperties(13, userSettingNum, 1, 1, 0, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                userSettingNum = ((ObjectProperties)m).getNumber();
            }
            int readerNum = 0;
            while ((m = c.reqObjectProperties(14, readerNum, 1, 1, 0, 0)).getMessageType() == 33) {
                logger.info(m.toString());
                readerNum = ((ObjectProperties)m).getNumber();
            }
            if (zoneNum > 0) {
                status = c.reqObjectStatus(1, 1, zoneNum);
                ZoneStatus[] zones = (ZoneStatus[])status.getStatuses();
                for (int i2 = 0; i2 < zones.length; ++i2) {
                    logger.info(zones[i2].toString());
                }
                status = c.reqObjectStatus(1, 1, zoneNum, true);
                ExtendedZoneStatus[] zonesExt = (ExtendedZoneStatus[])status.getStatuses();
                for (i = 0; i < zonesExt.length; ++i) {
                    logger.info(zonesExt[i].toString());
                }
            }
            if (unitNum > 0) {
                status = c.reqObjectStatus(2, 1, unitNum);
                UnitStatus[] units = (UnitStatus[])status.getStatuses();
                for (int i3 = 0; i3 < units.length; ++i3) {
                    logger.info(units[i3].toString());
                }
                status = c.reqObjectStatus(2, 1, unitNum, true);
                ExtendedUnitStatus[] unitsExt = (ExtendedUnitStatus[])status.getStatuses();
                for (i = 0; i < unitsExt.length; ++i) {
                    logger.info(unitsExt[i].toString());
                }
            }
            if (areaNum > 0) {
                status = c.reqObjectStatus(5, 1, areaNum);
                AreaStatus[] areas = (AreaStatus[])status.getStatuses();
                for (int i4 = 0; i4 < areas.length; ++i4) {
                    logger.info(areas[i4].toString());
                }
                status = c.reqObjectStatus(5, 1, areaNum, true);
                ExtendedAreaStatus[] areasExt = (ExtendedAreaStatus[])status.getStatuses();
                for (i = 0; i < areasExt.length; ++i) {
                    logger.info(areasExt[i].toString());
                }
            }
            if (thermoNum > 0) {
                status = c.reqObjectStatus(6, 1, thermoNum);
                ThermostatStatus[] thermos = (ThermostatStatus[])status.getStatuses();
                for (int i5 = 0; i5 < thermos.length; ++i5) {
                    logger.info(thermos[i5].toString());
                }
                status = c.reqObjectStatus(6, 1, thermoNum, true);
                ExtendedThermostatStatus[] thermosExt = (ExtendedThermostatStatus[])status.getStatuses();
                for (i = 0; i < thermosExt.length; ++i) {
                    logger.info(thermosExt[i].toString());
                }
            }
            if (messageNum > 0) {
                status = c.reqObjectStatus(7, 1, messageNum);
                MessageStatus[] megs = (MessageStatus[])status.getStatuses();
                for (int i6 = 0; i6 < megs.length; ++i6) {
                    logger.info(megs[i6].toString());
                }
                status = c.reqObjectStatus(7, 1, messageNum, true);
                ExtendedMessageStatus[] megsExt = (ExtendedMessageStatus[])status.getStatuses();
                for (i = 0; i < megsExt.length; ++i) {
                    logger.info(megsExt[i].toString());
                }
            }
            if (auxNum > 0) {
                status = c.reqObjectStatus(8, 1, auxNum);
                AuxSensorStatus[] auxs = (AuxSensorStatus[])status.getStatuses();
                for (int i7 = 0; i7 < auxs.length; ++i7) {
                    logger.info(auxs[i7].toString());
                }
                status = c.reqObjectStatus(8, 1, auxNum, true);
                ExtendedAuxSensorStatus[] auxsExt = (ExtendedAuxSensorStatus[])status.getStatuses();
                for (i = 0; i < auxsExt.length; ++i) {
                    logger.info(auxsExt[i].toString());
                }
            }
            if (audioZoneNum > 0) {
                status = c.reqObjectStatus(10, 1, audioZoneNum);
                AudioZoneStatus[] audiozs = (AudioZoneStatus[])status.getStatuses();
                for (int i8 = 0; i8 < audiozs.length; ++i8) {
                    logger.info(audiozs[i8].toString());
                }
                status = c.reqObjectStatus(10, 1, audioZoneNum, true);
                ExtendedAudioZoneStatus[] audiozsExt = (ExtendedAudioZoneStatus[])status.getStatuses();
                for (i = 0; i < audiozsExt.length; ++i) {
                    logger.info(audiozsExt[i].toString());
                }
            }
            if (userSettingNum > 0) {
                status = c.reqObjectStatus(13, 1, userSettingNum);
                UserSettingStatus[] userSettings = (UserSettingStatus[])status.getStatuses();
                for (int i9 = 0; i9 < userSettings.length; ++i9) {
                    logger.info(userSettings[i9].toString());
                }
                status = c.reqObjectStatus(13, 1, userSettingNum, true);
                ExtendedUserSettingStatus[] userSettingsExt = (ExtendedUserSettingStatus[])status.getStatuses();
                for (i = 0; i < userSettingsExt.length; ++i) {
                    logger.info(userSettingsExt[i].toString());
                }
            }
            if (readerNum > 0) {
                status = c.reqObjectStatus(14, 1, readerNum);
                AccessControlReaderStatus[] readers = (AccessControlReaderStatus[])status.getStatuses();
                for (int i10 = 0; i10 < readers.length; ++i10) {
                    logger.info(readers[i10].toString());
                }
                status = c.reqObjectStatus(14, 1, readerNum, true);
                ExtendedAccessControlReaderStatus[] readersExt = (ExtendedAccessControlReaderStatus[])status.getStatuses();
                for (i = 0; i < readersExt.length; ++i) {
                    logger.info(readersExt[i].toString());
                }
                status = c.reqObjectStatus(15, 1, readerNum);
                AccessControlReaderLockStatus[] locks = (AccessControlReaderLockStatus[])status.getStatuses();
                for (int i11 = 0; i11 < locks.length; ++i11) {
                    logger.info(locks[i11].toString());
                }
                status = c.reqObjectStatus(15, 1, readerNum, true);
                ExtendedAccessControlReaderLockStatus[] locksExt = (ExtendedAccessControlReaderLockStatus[])status.getStatuses();
                for (int i12 = 0; i12 < locksExt.length; ++i12) {
                    logger.info(locksExt[i12].toString());
                }
            }
            for (int as = 1; as < audioSourceNum; ++as) {
                int pos = 0;
                while ((m = c.reqAudioSourceStatus(as, pos)).getMessageType() == 49) {
                    AudioSourceStatus a = (AudioSourceStatus)m;
                    logger.info(a.toString());
                    pos = a.getPosition();
                }
            }
            int num = 0;
            for (int count = 0; (m = c.readEventRecord(num, 1)).getMessageType() == 37 && count < 10; ++count) {
                EventLogData e = (EventLogData)m;
                logger.info(e.toString());
                num = e.getEventNumber();
            }
            logger.info(c.readName(2, 0).toString());
            logger.info(c.reqSecurityCodeValidation(1, 1, 2, 3, 4).toString());
            logger.info("All Done, OmniConnection thread now running");
        }
        catch (OmniInvalidResponseException e) {
            logger.error("Invalid Response", (Throwable)e);
            System.exit(-1);
        }
        catch (OmniNotConnectedException e) {
            logger.error("Error connecting", (Throwable)e);
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

