/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events;

import com.github.dikhan.pagerduty.client.events.ApiService;
import com.github.dikhan.pagerduty.client.events.JacksonObjectMapper;
import com.github.dikhan.pagerduty.client.events.domain.EventResult;
import com.github.dikhan.pagerduty.client.events.domain.Incident;
import com.github.dikhan.pagerduty.client.events.exceptions.NotifyEventException;
import com.github.dikhan.pagerduty.client.events.utils.JsonUtils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpApiServiceImpl
implements ApiService {
    private static final Logger log = LoggerFactory.getLogger(HttpApiServiceImpl.class);
    private final String eventApi;

    public HttpApiServiceImpl(String eventApi) {
        this.eventApi = eventApi;
        this.initUnirest();
    }

    private void initUnirest() {
        Unirest.setObjectMapper((ObjectMapper)new JacksonObjectMapper());
    }

    @Override
    public EventResult notifyEvent(Incident incident) throws NotifyEventException {
        try {
            HttpRequestWithBody request = Unirest.post((String)this.eventApi).header("Accept", "application/json");
            request.body((Object)incident);
            HttpResponse jsonResponse = request.asJson();
            log.debug(IOUtils.toString((InputStream)jsonResponse.getRawBody()));
            switch (jsonResponse.getStatus()) {
                case 200: {
                    return EventResult.successEvent(JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "status"), JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "message"), JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "incident_key"));
                }
                case 400: {
                    return EventResult.errorEvent(JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "status"), JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "message"), JsonUtils.getArrayValue((HttpResponse<JsonNode>)jsonResponse, "errors"));
                }
            }
            return EventResult.errorEvent(String.valueOf(jsonResponse.getStatus()), "", IOUtils.toString((InputStream)jsonResponse.getRawBody()));
        }
        catch (UnirestException | IOException e) {
            throw new NotifyEventException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpApiServiceImpl that = (HttpApiServiceImpl)o;
        return !(this.eventApi == null ? that.eventApi != null : !this.eventApi.equals(that.eventApi));
    }

    public int hashCode() {
        return this.eventApi != null ? this.eventApi.hashCode() : 0;
    }
}

