/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events;

import com.github.dikhan.pagerduty.client.events.ApiService;
import com.github.dikhan.pagerduty.client.events.ApiServiceFactory;
import com.github.dikhan.pagerduty.client.events.domain.AcknowledgeIncident;
import com.github.dikhan.pagerduty.client.events.domain.EventResult;
import com.github.dikhan.pagerduty.client.events.domain.Payload;
import com.github.dikhan.pagerduty.client.events.domain.ResolveIncident;
import com.github.dikhan.pagerduty.client.events.domain.Severity;
import com.github.dikhan.pagerduty.client.events.domain.TriggerIncident;
import com.github.dikhan.pagerduty.client.events.exceptions.NotifyEventException;
import java.time.OffsetDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerDutyEventsClient {
    private static final Logger log = LoggerFactory.getLogger(PagerDutyEventsClient.class);
    private final ApiService httpApiServiceImpl;

    protected PagerDutyEventsClient(PagerDutyClientBuilder pagerDutyClientBuilder) {
        String eventApi = pagerDutyClientBuilder.getEventApi();
        this.httpApiServiceImpl = new ApiServiceFactory(eventApi).getDefault();
    }

    public static void main(String[] args) throws NotifyEventException {
        String routingKey = "ROUTING_KEY";
        String dedupKey = "DEDUP_KEY";
        PagerDutyEventsClient pagerDutyEventsClient = PagerDutyEventsClient.create();
        Payload payload = Payload.Builder.newBuilder().setSummary("This is an incident test to test PagerDutyEventsClient").setSource("testing host").setSeverity(Severity.INFO).setTimestamp(OffsetDateTime.now()).build();
        TriggerIncident incident = ((TriggerIncident.TriggerIncidentBuilder)TriggerIncident.TriggerIncidentBuilder.newBuilder(routingKey, payload).setDedupKey(dedupKey)).setClient("client").setClientUrl("https://monitoring.example.com").build();
        pagerDutyEventsClient.trigger(incident);
        AcknowledgeIncident ack = AcknowledgeIncident.AcknowledgeIncidentBuilder.newBuilder(routingKey, dedupKey).build();
        pagerDutyEventsClient.acknowledge(ack);
        ResolveIncident resolve = ResolveIncident.ResolveIncidentBuilder.newBuilder(routingKey, dedupKey).build();
        pagerDutyEventsClient.resolve(resolve);
    }

    public static PagerDutyEventsClient create() {
        return new PagerDutyClientBuilder().build();
    }

    public static PagerDutyEventsClient create(String eventApi) {
        return new PagerDutyClientBuilder().withEventApi(eventApi).build();
    }

    public EventResult trigger(TriggerIncident incident) throws NotifyEventException {
        EventResult eventResult = this.httpApiServiceImpl.notifyEvent(incident);
        log.debug("Event result {}", (Object)eventResult);
        return eventResult;
    }

    public EventResult acknowledge(AcknowledgeIncident ack) throws NotifyEventException {
        EventResult eventResult = this.httpApiServiceImpl.notifyEvent(ack);
        log.debug("Event result {} for acknowledge incident {}", (Object)eventResult, (Object)ack);
        return eventResult;
    }

    public EventResult resolve(ResolveIncident resolve) throws NotifyEventException {
        EventResult eventResult = this.httpApiServiceImpl.notifyEvent(resolve);
        log.debug("Event result {} for resolve incident {}", (Object)eventResult, (Object)resolve);
        return eventResult;
    }

    protected static class PagerDutyClientBuilder {
        private static final String PAGER_DUTY_EVENT_API = "https://events.pagerduty.com/v2/enqueue";
        private String eventApi;

        public PagerDutyClientBuilder withEventApi(String eventApi) {
            this.eventApi = eventApi;
            return this;
        }

        public PagerDutyEventsClient build() {
            if (StringUtils.isBlank((CharSequence)this.eventApi)) {
                this.eventApi = PAGER_DUTY_EVENT_API;
            }
            return new PagerDutyEventsClient(this);
        }

        public String getEventApi() {
            return this.eventApi;
        }
    }
}

