/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dikhan.pagerduty.client.events.domain.EventAction;
import com.github.dikhan.pagerduty.client.events.domain.ImageContext;
import com.github.dikhan.pagerduty.client.events.domain.LinkContext;
import com.github.dikhan.pagerduty.client.events.domain.Payload;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.Builder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Incident {
    @JsonProperty(value="routing_key")
    private final String routingKey;
    @JsonProperty(value="event_action")
    private final EventAction eventAction;
    @JsonProperty(value="dedup_key")
    private final String dedupKey;
    @JsonProperty(value="payload")
    private final Payload payload;
    @JsonProperty(value="images")
    private final List<ImageContext> images;
    @JsonProperty(value="links")
    private final List<LinkContext> links;

    protected Incident(IncidentBuilder builder) {
        this.routingKey = builder.getRoutingKey();
        this.eventAction = builder.getEventAction();
        this.dedupKey = builder.getDedupKey();
        this.payload = builder.getPayload();
        this.images = builder.getImages();
        this.links = builder.getLinks();
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public EventAction getEventAction() {
        return this.eventAction;
    }

    public String getDedupKey() {
        return this.dedupKey;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public List<ImageContext> getImages() {
        return this.images;
    }

    public List<LinkContext> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Incident incident = (Incident)o;
        if (this.routingKey != null ? !this.routingKey.equals(incident.routingKey) : incident.routingKey != null) {
            return false;
        }
        if (this.eventAction != incident.eventAction) {
            return false;
        }
        if (this.dedupKey != null ? !this.dedupKey.equals(incident.dedupKey) : incident.dedupKey != null) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(incident.getPayload()) : incident.getPayload() != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(incident.getImages()) : incident.getImages() != null) {
            return false;
        }
        return !(this.links != null ? !this.links.equals(incident.getLinks()) : incident.getLinks() != null);
    }

    public int hashCode() {
        int result = this.routingKey != null ? this.routingKey.hashCode() : 0;
        result = 31 * result + (this.eventAction != null ? this.eventAction.hashCode() : 0);
        result = 31 * result + (this.dedupKey != null ? this.dedupKey.hashCode() : 0);
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.images != null ? this.images.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    protected static abstract class IncidentBuilder<T extends IncidentBuilder>
    implements Builder {
        protected static final String BLANK_FIELD = "BLANK";
        private final String routingKey;
        private final EventAction eventAction;
        private String dedupKey;
        private Payload payload;
        private List<ImageContext> images;
        private List<LinkContext> links;

        protected IncidentBuilder(String routingKey, EventAction eventAction) {
            if (StringUtils.isBlank((CharSequence)routingKey)) {
                throw new IllegalArgumentException("routingKey must not be null, it is a mandatory param");
            }
            Objects.requireNonNull(eventAction, "eventAction must not be null, it is a mandatory param");
            this.routingKey = routingKey;
            this.eventAction = eventAction;
        }

        public T setDedupKey(String dedupKey) {
            this.dedupKey = dedupKey;
            return (T)this;
        }

        public T setPayload(Payload payload) {
            this.payload = payload;
            return (T)this;
        }

        public Builder setImages(List<ImageContext> images) {
            this.images = images;
            return this;
        }

        public Builder setLinks(List<LinkContext> links) {
            this.links = links;
            return this;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public EventAction getEventAction() {
            return this.eventAction;
        }

        public String getDedupKey() {
            return this.dedupKey;
        }

        public Payload getPayload() {
            return this.payload;
        }

        public List<ImageContext> getImages() {
            return this.images;
        }

        public List<LinkContext> getLinks() {
            return this.links;
        }
    }
}

