/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dikhan.pagerduty.client.events.domain.Severity;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Payload {
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="severity")
    private final Severity severity;
    @JsonProperty(value="timestamp")
    private final String timestamp;
    @JsonProperty(value="component")
    private final String component;
    @JsonProperty(value="group")
    private final String group;
    @JsonProperty(value="class")
    private final String eventClass;
    @JsonProperty(value="custom_details")
    private final String customDetails;

    private Payload(Builder builder) {
        this.summary = builder.getSummary();
        this.source = builder.getSource();
        this.severity = builder.getSeverity();
        this.timestamp = builder.getTimestamp() != null ? builder.getTimestamp().toString() : null;
        this.component = builder.getComponent();
        this.group = builder.getGroup();
        this.eventClass = builder.getEventClass();
        this.customDetails = builder.getCustomDetails();
    }

    public String getSummary() {
        return this.summary;
    }

    public String getSource() {
        return this.source;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getComponent() {
        return this.component;
    }

    public String getGroup() {
        return this.group;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public String getCustomDetails() {
        return this.customDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload payload = (Payload)o;
        if (this.summary != null ? !this.summary.equals(payload.getSummary()) : payload.getSummary() != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(payload.getSource()) : payload.getSource() != null) {
            return false;
        }
        if (this.severity != payload.getSeverity()) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(payload.getTimestamp()) : payload.getTimestamp() != null) {
            return false;
        }
        if (this.component != null ? !this.component.equals(payload.getComponent()) : payload.getComponent() != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(payload.getGroup()) : payload.getGroup() != null) {
            return false;
        }
        if (this.eventClass != null ? !this.eventClass.equals(payload.getEventClass()) : payload.getEventClass() != null) {
            return false;
        }
        return !(this.customDetails != null ? !this.customDetails.equals(payload.getCustomDetails()) : payload.getCustomDetails() != null);
    }

    public int hashCode() {
        int result = this.summary != null ? this.summary.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.severity.hashCode() : 0);
        result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.eventClass != null ? this.eventClass.hashCode() : 0);
        result = 31 * result + (this.customDetails != null ? this.customDetails.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String summary;
        private String source;
        private Severity severity;
        private OffsetDateTime timestamp;
        private String component;
        private String group;
        private String eventClass;
        private String customDetails;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Payload createEmpty() {
            return Builder.newBuilder().setSummary("BLANK").setSource("BLANK").setSeverity(Severity.INFO).build();
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setComponent(String component) {
            this.component = component;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setEventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        public Builder setCustomDetails(String customDetails) {
            this.customDetails = customDetails;
            return this;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getSource() {
            return this.source;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public OffsetDateTime getTimestamp() {
            return this.timestamp;
        }

        public String getComponent() {
            return this.component;
        }

        public String getGroup() {
            return this.group;
        }

        public String getEventClass() {
            return this.eventClass;
        }

        public String getCustomDetails() {
            return this.customDetails;
        }

        public Payload build() {
            Payload payload = new Payload(this);
            if (StringUtils.isBlank((CharSequence)payload.getSummary())) {
                throw new IllegalArgumentException("summary cannot be blank.");
            }
            if (StringUtils.isBlank((CharSequence)payload.getSource())) {
                throw new IllegalArgumentException("source cannot be blank.");
            }
            Objects.requireNonNull(payload.getSeverity(), "severity cannot be null.");
            if (!StringUtils.isBlank((CharSequence)payload.getCustomDetails())) {
                try {
                    JsonParser parser = new JsonParser();
                    parser.parse(payload.getCustomDetails());
                }
                catch (JsonSyntaxException e) {
                    throw new IllegalArgumentException("custom details has to be in valid JSON format.");
                }
            }
            return payload;
        }
    }
}

