/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dikhan.pagerduty.client.events.domain.EventAction;
import com.github.dikhan.pagerduty.client.events.domain.Incident;
import com.github.dikhan.pagerduty.client.events.domain.Payload;
import java.util.Objects;

public class TriggerIncident
extends Incident {
    @JsonProperty(value="client")
    private final String client;
    @JsonProperty(value="client_url")
    private final String clientUrl;

    private TriggerIncident(TriggerIncidentBuilder builder) {
        super(builder);
        this.client = builder.getClient();
        this.clientUrl = builder.getClientUrl();
    }

    public String getClient() {
        return this.client;
    }

    public String getClientUrl() {
        return this.clientUrl;
    }

    public static class TriggerIncidentBuilder
    extends Incident.IncidentBuilder<TriggerIncidentBuilder> {
        private String client;
        private String clientUrl;

        private TriggerIncidentBuilder(String routingKey, Payload payload) {
            super(routingKey, EventAction.TRIGGER);
            this.setPayload(payload);
        }

        public static TriggerIncidentBuilder newBuilder(String routingKey, Payload payload) {
            return new TriggerIncidentBuilder(routingKey, payload);
        }

        public TriggerIncidentBuilder setClient(String client) {
            this.client = client;
            return this;
        }

        public TriggerIncidentBuilder setClientUrl(String clientUrl) {
            this.clientUrl = clientUrl;
            return this;
        }

        public String getClient() {
            return this.client;
        }

        public String getClientUrl() {
            return this.clientUrl;
        }

        public TriggerIncident build() {
            TriggerIncident triggerIncident = new TriggerIncident(this);
            Objects.requireNonNull(triggerIncident.getPayload(), "payload must not be null, it is a mandatory param");
            return new TriggerIncident(this);
        }
    }
}

