/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events;

import com.github.dikhan.pagerduty.client.events.ApiService;
import com.github.dikhan.pagerduty.client.events.JacksonObjectMapper;
import com.github.dikhan.pagerduty.client.events.domain.ChangeEvent;
import com.github.dikhan.pagerduty.client.events.domain.EventResult;
import com.github.dikhan.pagerduty.client.events.domain.PagerDutyEvent;
import com.github.dikhan.pagerduty.client.events.exceptions.NotifyEventException;
import com.github.dikhan.pagerduty.client.events.utils.JsonUtils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpApiServiceImpl
implements ApiService {
    private static final Logger log = LoggerFactory.getLogger(HttpApiServiceImpl.class);
    private static final int RATE_LIMIT_STATUS_CODE = 429;
    private static final Map<Integer, long[]> RETRY_WAIT_TIME_MILLISECONDS = new HashMap<Integer, long[]>();
    private final String eventApi;
    private final String changeEventApi;
    private final boolean doRetries;

    public HttpApiServiceImpl(String eventApi, String changeEventApi, boolean doRetries) {
        this.eventApi = eventApi;
        this.changeEventApi = changeEventApi;
        this.doRetries = doRetries;
        this.initUnirest();
    }

    public HttpApiServiceImpl(String eventApi, String changeEventApi, String proxyHost, Integer proxyPort, boolean doRetries) {
        this.eventApi = eventApi;
        this.changeEventApi = changeEventApi;
        this.doRetries = doRetries;
        this.initUnirestWithProxy(proxyHost, proxyPort);
    }

    private void initUnirest() {
        Unirest.setObjectMapper((ObjectMapper)new JacksonObjectMapper());
    }

    private void initUnirestWithProxy(String proxyHost, Integer proxyPort) {
        this.initUnirest();
        Unirest.setProxy((HttpHost)new HttpHost(proxyHost, proxyPort.intValue()));
    }

    @Override
    public EventResult notifyEvent(PagerDutyEvent event) throws NotifyEventException {
        if (event instanceof ChangeEvent) {
            return this.notifyEvent(event, this.changeEventApi, 0);
        }
        return this.notifyEvent(event, this.eventApi, 0);
    }

    private EventResult notifyEvent(PagerDutyEvent event, String api, int retryCount) throws NotifyEventException {
        try {
            HttpRequestWithBody request = Unirest.post((String)api).header("Content-Type", "application/json").header("Accept", "application/json");
            request.body((Object)event);
            HttpResponse jsonResponse = request.asJson();
            if (log.isDebugEnabled()) {
                log.debug(IOUtils.toString((InputStream)jsonResponse.getRawBody()));
                jsonResponse.getRawBody().reset();
            }
            int responseStatus = jsonResponse.getStatus();
            switch (responseStatus) {
                case 200: 
                case 201: 
                case 202: {
                    return EventResult.successEvent(JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "status"), JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "message"), JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "dedup_key"));
                }
                case 400: {
                    return EventResult.errorEvent(JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "status"), JsonUtils.getPropertyValue((HttpResponse<JsonNode>)jsonResponse, "message"), JsonUtils.getArrayValue((HttpResponse<JsonNode>)jsonResponse, "errors"));
                }
                case 429: 
                case 500: {
                    if (this.doRetries) {
                        return this.handleRetries(event, api, retryCount, (HttpResponse<JsonNode>)jsonResponse, responseStatus);
                    }
                    return EventResult.errorEvent(String.valueOf(responseStatus), "", IOUtils.toString((InputStream)jsonResponse.getRawBody()));
                }
            }
            return EventResult.errorEvent(String.valueOf(responseStatus), "", IOUtils.toString((InputStream)jsonResponse.getRawBody()));
        }
        catch (UnirestException | IOException e) {
            throw new NotifyEventException(e);
        }
    }

    private EventResult handleRetries(PagerDutyEvent event, String api, int retryCount, HttpResponse<JsonNode> jsonResponse, int responseStatus) throws IOException, NotifyEventException {
        long[] retryDelays = RETRY_WAIT_TIME_MILLISECONDS.get(responseStatus);
        int maxRetries = retryDelays.length;
        if (retryCount == maxRetries) {
            log.debug("Received a {} response. Exhausted all the possibilities to retry.", (Object)responseStatus);
            return EventResult.errorEvent(String.valueOf(responseStatus), "", IOUtils.toString((InputStream)jsonResponse.getRawBody()));
        }
        log.debug("Received a {} response. Will retry again. ({}/{})", new Object[]{responseStatus, retryCount, maxRetries});
        try {
            Thread.sleep(retryDelays[retryCount]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.notifyEvent(event, api, retryCount + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpApiServiceImpl that = (HttpApiServiceImpl)o;
        return this.doRetries == that.doRetries && Objects.equals(this.eventApi, that.eventApi) && Objects.equals(this.changeEventApi, that.changeEventApi);
    }

    public int hashCode() {
        return Objects.hash(this.eventApi, this.changeEventApi, this.doRetries);
    }

    static {
        RETRY_WAIT_TIME_MILLISECONDS.put(500, new long[]{500L, 1000L, 2000L});
        RETRY_WAIT_TIME_MILLISECONDS.put(429, new long[]{10000L, 25000L, 55000L});
    }
}

