/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dikhan.pagerduty.client.events.domain.ChangeEventPayload;
import com.github.dikhan.pagerduty.client.events.domain.LinkContext;
import com.github.dikhan.pagerduty.client.events.domain.PagerDutyEvent;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.Builder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChangeEvent
implements PagerDutyEvent {
    @JsonProperty(value="routing_key")
    private final String routingKey;
    @JsonProperty(value="payload")
    private final ChangeEventPayload payload;
    @JsonProperty(value="links")
    private final List<LinkContext> links;

    protected ChangeEvent(ChangeEventBuilder builder) {
        this.routingKey = builder.getRoutingKey();
        this.payload = builder.getPayload();
        this.links = builder.getLinks();
    }

    public String toString() {
        return "ChangeEvent { routingKey='" + this.routingKey + "', payload=" + this.payload + ", links=" + this.links + " }";
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public ChangeEventPayload getPayload() {
        return this.payload;
    }

    public List<LinkContext> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEvent changeEvent = (ChangeEvent)o;
        if (!Objects.equals(this.routingKey, changeEvent.routingKey)) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(changeEvent.getPayload()) : changeEvent.getPayload() != null) {
            return false;
        }
        return !(this.links != null ? !this.links.equals(changeEvent.getLinks()) : changeEvent.getLinks() != null);
    }

    public int hashCode() {
        int result = this.routingKey != null ? this.routingKey.hashCode() : 0;
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    public static class ChangeEventBuilder
    implements Builder {
        private final String routingKey;
        private ChangeEventPayload payload;
        private List<LinkContext> links;

        public static ChangeEventBuilder newBuilder(String routingKey, ChangeEventPayload payload) {
            return new ChangeEventBuilder(routingKey, payload);
        }

        protected ChangeEventBuilder(String routingKey) {
            if (StringUtils.isBlank((CharSequence)routingKey)) {
                throw new IllegalArgumentException("routingKey must not be null, it is a mandatory param");
            }
            this.routingKey = routingKey;
        }

        private ChangeEventBuilder(String routingKey, ChangeEventPayload payload) {
            this(routingKey);
            this.setPayload(payload);
        }

        public ChangeEventBuilder setPayload(ChangeEventPayload payload) {
            this.payload = payload;
            return this;
        }

        public ChangeEventBuilder setLinks(List<LinkContext> links) {
            this.links = links;
            return this;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public ChangeEventPayload getPayload() {
            return this.payload;
        }

        public List<LinkContext> getLinks() {
            return this.links;
        }

        public ChangeEvent build() {
            Objects.requireNonNull(this.getPayload(), "payload must not be null, it is a mandatory param");
            return new ChangeEvent(this);
        }
    }
}

