/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events.utils;

import com.github.dikhan.pagerduty.client.events.PagerDutyEventsClient;
import com.github.dikhan.pagerduty.client.events.domain.AcknowledgeIncident;
import com.github.dikhan.pagerduty.client.events.domain.EventResult;
import com.github.dikhan.pagerduty.client.events.domain.Incident;
import com.github.dikhan.pagerduty.client.events.domain.ResolveIncident;
import com.github.dikhan.pagerduty.client.events.domain.TriggerIncident;
import com.github.dikhan.pagerduty.client.events.exceptions.NotifyEventException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakePagerDutyEventsClient
extends PagerDutyEventsClient {
    private static final Logger log = LoggerFactory.getLogger(FakePagerDutyEventsClient.class);
    private final Set<TriggerIncident> openIncidents = new HashSet<TriggerIncident>();
    private final Set<ResolveIncident> resolvedIncidents = new HashSet<ResolveIncident>();
    private final Set<AcknowledgeIncident> acknowledgedIncidents = new HashSet<AcknowledgeIncident>();
    private final Random random = new Random();

    private FakePagerDutyEventsClient(PagerDutyEventsClient.PagerDutyClientBuilder pagerDutyClientBuilder) {
        super(pagerDutyClientBuilder);
    }

    public static FakePagerDutyEventsClient create() {
        return new FakePagerDutyEventsClient(new PagerDutyEventsClient.PagerDutyClientBuilder());
    }

    @Override
    public EventResult trigger(TriggerIncident incident) throws NotifyEventException {
        EventResult eventResult;
        if (StringUtils.isBlank((CharSequence)incident.getDedupKey())) {
            String dedupKey = String.valueOf(this.random.nextLong());
            incident = this.updateTriggerIncidentWithKey(incident, dedupKey);
            eventResult = this.createEventResult(incident);
        } else {
            eventResult = this.createEventResult(incident);
        }
        this.openIncidents.add(incident);
        log.debug("Event result {}", (Object)eventResult);
        return eventResult;
    }

    @Override
    public EventResult acknowledge(AcknowledgeIncident ack) throws NotifyEventException {
        if (StringUtils.isBlank((CharSequence)ack.getRoutingKey()) || StringUtils.isBlank((CharSequence)ack.getDedupKey())) {
            throw new NotifyEventException("routingKey and dedupKey are required parameters to be able to acknowledge an incident");
        }
        this.acknowledgedIncidents.add(ack);
        EventResult eventResult = this.createEventResult(ack);
        log.debug("Event result {} for acknowledge incident {}", (Object)eventResult, (Object)ack);
        return eventResult;
    }

    @Override
    public EventResult resolve(ResolveIncident resolve) throws NotifyEventException {
        if (StringUtils.isBlank((CharSequence)resolve.getRoutingKey()) || StringUtils.isBlank((CharSequence)resolve.getDedupKey())) {
            throw new NotifyEventException("routingKey and dedupKey are required parameters to be able to resolve an incident");
        }
        this.resolvedIncidents.add(resolve);
        EventResult eventResult = this.createEventResult(resolve);
        log.debug("Event result {} for resolve incident {}", (Object)eventResult, (Object)resolve);
        return eventResult;
    }

    public Set<TriggerIncident> openIncidents() {
        Set<String> dedupKeysResolved = this.dedupKeysResolved();
        return this.openIncidents.stream().filter(incident -> !dedupKeysResolved.contains(incident.getDedupKey())).collect(Collectors.toSet());
    }

    public Set<ResolveIncident> resolvedIncidents() {
        return this.resolvedIncidents;
    }

    public Set<AcknowledgeIncident> acknowledgedIncidents() {
        return this.acknowledgedIncidents;
    }

    private EventResult createEventResult(Incident incident) {
        return EventResult.successEvent("success", String.format("Event (%s) processed", incident.getEventAction().getEventType()), incident.getDedupKey());
    }

    public Set<String> dedupKeysResolved() {
        return this.resolvedIncidents.stream().map(Incident::getDedupKey).collect(Collectors.toSet());
    }

    private TriggerIncident updateTriggerIncidentWithKey(TriggerIncident incident, String dedupKey) {
        return ((TriggerIncident.TriggerIncidentBuilder)TriggerIncident.TriggerIncidentBuilder.newBuilder(incident.getRoutingKey(), incident.getPayload()).setDedupKey(dedupKey)).build();
    }
}

