/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class ChangeEventPayload {
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="timestamp")
    private final String timestamp;
    @JsonProperty(value="custom_details")
    private final JSONObject customDetails;

    private ChangeEventPayload(Builder builder) {
        this.summary = builder.getSummary();
        this.source = builder.getSource();
        this.timestamp = builder.getTimestamp() != null ? builder.getTimestamp().toString() : null;
        this.customDetails = builder.getCustomDetails();
    }

    public String toString() {
        return "ChangeEventPayload { summary=" + this.summary + ", source=" + this.source + ", timestamp=" + this.timestamp + ", custom_details=" + this.customDetails + " }";
    }

    public String getSummary() {
        return this.summary;
    }

    public String getSource() {
        return this.source;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Object getCustomDetails() {
        return this.customDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEventPayload payload = (ChangeEventPayload)o;
        if (this.summary != null ? !this.summary.equals(payload.getSummary()) : payload.getSummary() != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(payload.getSource()) : payload.getSource() != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(payload.getTimestamp()) : payload.getTimestamp() != null) {
            return false;
        }
        return !(this.customDetails != null ? !this.customDetails.equals(payload.getCustomDetails()) : payload.getCustomDetails() != null);
    }

    public int hashCode() {
        int result = this.summary != null ? this.summary.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.customDetails != null ? this.customDetails.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String summary;
        private String source;
        private OffsetDateTime timestamp;
        private JSONObject customDetails;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setCustomDetails(JSONObject customDetails) {
            this.customDetails = customDetails;
            return this;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getSource() {
            return this.source;
        }

        public OffsetDateTime getTimestamp() {
            return this.timestamp;
        }

        public JSONObject getCustomDetails() {
            return this.customDetails;
        }

        public ChangeEventPayload build() {
            if (StringUtils.isBlank((CharSequence)this.getSummary())) {
                throw new IllegalArgumentException("summary cannot be blank.");
            }
            return new ChangeEventPayload(this);
        }
    }
}

