/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.index.Messages;
import org.dita.dost.util.DITAOTCollator;

public final class IndexTerm
implements Comparable<IndexTerm> {
    private static Locale termLocale = null;
    private String termName = null;
    private List<IndexTermTarget> targetList = null;
    private String termKey = null;
    private String start = null;
    private String end = null;
    private List<IndexTerm> subTerms = new ArrayList<IndexTerm>(1);
    private String termPrefix = null;
    private static ArrayList<String> rtlLocaleList = null;
    private boolean leaf = true;

    public IndexTerm() {
        this.targetList = new ArrayList<IndexTermTarget>(1);
    }

    public static Locale getTermLocale() {
        return termLocale;
    }

    public static void setTermLocale(Locale locale) {
        termLocale = locale;
    }

    public String getTermName() {
        return this.termName;
    }

    public void setTermName(String name) {
        this.termName = name;
    }

    public String getTermKey() {
        return this.termKey;
    }

    public void setTermKey(String key) {
        this.termKey = key;
    }

    public List<IndexTerm> getSubTerms() {
        return this.subTerms;
    }

    public String getStartAttribute() {
        return this.start;
    }

    public String getEndAttribute() {
        return this.end;
    }

    public void setStartAttribute(String start) {
        this.start = start;
    }

    public void setEndAttribute(String end) {
        this.end = end;
    }

    public void addSubTerm(IndexTerm term) {
        int i = 0;
        int subTermNum = this.subTerms.size();
        if (!"See".equals(term.getTermPrefix()) && !"See also".equals(term.getTermPrefix())) {
            this.leaf = false;
        }
        while (i < subTermNum) {
            IndexTerm subTerm = this.subTerms.get(i);
            if (subTerm.equals(term)) {
                return;
            }
            if (subTerm.getTermFullName().equals(term.getTermFullName()) && subTerm.getTermKey().equals(term.getTermKey())) {
                subTerm.addTargets(term.getTargetList());
                subTerm.addSubTerms(term.getSubTerms());
                return;
            }
            ++i;
        }
        if (i == subTermNum) {
            this.subTerms.add(term);
        }
    }

    public void addSubTerms(List<IndexTerm> terms) {
        int subTermsNum = 0;
        if (terms == null) {
            return;
        }
        subTermsNum = terms.size();
        for (int i = 0; i < subTermsNum; ++i) {
            this.addSubTerm(terms.get(i));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof IndexTerm)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        IndexTerm it = (IndexTerm)o;
        boolean eqTermName = this.termName == it.getTermName() || this.termName != null && this.termName.equals(it.getTermName());
        boolean eqTermPrefix = this.termPrefix == it.getTermPrefix() || this.termPrefix != null && this.termPrefix.equals(it.getTermPrefix());
        boolean eqTermKey = this.termKey == it.getTermKey() || this.termKey != null && this.termKey.equals(it.getTermKey());
        boolean eqTargetList = this.targetList == it.getTargetList() || this.targetList != null && this.targetList.equals(it.getTargetList());
        boolean eqSubTerms = this.subTerms == it.getSubTerms() || this.subTerms != null && this.subTerms.equals(it.getSubTerms());
        return eqTermName && eqTermKey && eqTargetList && eqSubTerms && eqTermPrefix;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.termName.hashCode();
        result = 37 * result + this.termKey.hashCode();
        result = 37 * result + this.targetList.hashCode();
        result = 37 * result + this.subTerms.hashCode();
        return result;
    }

    public void sortSubTerms() {
        int subTermNum = this.subTerms.size();
        if (this.subTerms != null && subTermNum > 0) {
            Collections.sort(this.subTerms);
            for (int i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = this.subTerms.get(i);
                subTerm.sortSubTerms();
            }
        }
    }

    @Override
    public int compareTo(IndexTerm obj) {
        return DITAOTCollator.getInstance(termLocale).compare(this.termKey, obj.getTermKey());
    }

    public List<IndexTermTarget> getTargetList() {
        return this.targetList;
    }

    public void addTarget(IndexTermTarget target) {
        if (!this.targetList.contains(target)) {
            this.targetList.add(target);
        }
    }

    public void addTargets(List<IndexTermTarget> targets) {
        int targetNum = 0;
        if (targets == null) {
            return;
        }
        targetNum = targets.size();
        for (int i = 0; i < targetNum; ++i) {
            this.addTarget(targets.get(i));
        }
    }

    public boolean hasSubTerms() {
        return this.subTerms != null && this.subTerms.size() > 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{Term name: ").append(this.termName);
        buffer.append(", Term key: ").append(this.termKey);
        buffer.append(", Target list: ");
        buffer.append(this.targetList.toString());
        buffer.append(", Sub-terms: ");
        buffer.append(this.subTerms.toString());
        buffer.append("}");
        return buffer.toString();
    }

    public String getTermPrefix() {
        return this.termPrefix;
    }

    public void setTermPrefix(String termPrefix) {
        this.termPrefix = termPrefix;
    }

    public String getTermFullName() {
        if (this.termPrefix == null) {
            return this.termName;
        }
        if (termLocale == null) {
            return this.termPrefix + " " + this.termName;
        }
        if (rtlLocaleList.contains(termLocale.toString())) {
            return this.termName + " " + Messages.getString("IndexTerm." + this.termPrefix.toLowerCase().trim().replace(' ', '-'), termLocale);
        }
        return Messages.getString("IndexTerm." + this.termPrefix.toLowerCase().trim().replace(' ', '-'), termLocale) + " " + this.termName;
    }

    public void updateSubTerm() {
        IndexTerm term;
        if (this.subTerms.size() == 1 && (term = this.subTerms.get(0)).getTermPrefix() != null && "See".equalsIgnoreCase(term.getTermPrefix().trim())) {
            term.setTermPrefix("See also");
        }
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    static {
        rtlLocaleList = new ArrayList(2);
        rtlLocaleList.add("ar_EG");
        rtlLocaleList.add("he_IL");
    }
}

