/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.PipelineFacade;
import org.dita.dost.pipeline.PipelineHashIO;

public final class ExtensibleAntInvoker
extends Task {
    private final PipelineFacade pipeline;
    private final Map<String, String> attrs = new HashMap<String, String>();
    private final ArrayList<Param> pipelineParams;
    private final ArrayList<Module> modules;

    public ExtensibleAntInvoker() {
        this.pipeline = new PipelineFacade();
        this.pipelineParams = new ArrayList();
        this.modules = new ArrayList();
    }

    public void setMessage(String m) {
        this.attrs.put("message", m);
    }

    public void setInputmap(String inputmap) {
        this.attrs.put("inputmap", inputmap);
    }

    public void setTempdir(File tempdir) {
        this.attrs.put("tempDir", tempdir.getAbsolutePath());
    }

    public Param createParam() {
        Param p = new Param();
        this.pipelineParams.add(p);
        return p;
    }

    public void addConfiguredModule(Module m) {
        this.modules.add(m);
    }

    public void execute() throws BuildException {
        if (this.modules.isEmpty()) {
            throw new BuildException("Module must be specified");
        }
        if (this.attrs.get("basedir") == null) {
            this.attrs.put("basedir", this.getProject().getBaseDir().getAbsolutePath());
        }
        for (Param p : this.pipelineParams) {
            if (!p.isValid()) {
                throw new BuildException("Incomplete parameter");
            }
            String ifProperty = p.getIf();
            String unlessProperty = p.getUnless();
            if (ifProperty != null && !this.getProject().getProperties().containsKey(ifProperty) || unlessProperty != null && this.getProject().getProperties().containsKey(unlessProperty)) continue;
            this.attrs.put(p.getName(), p.getValue());
        }
        DITAOTAntLogger logger = new DITAOTAntLogger(this.getProject());
        logger.setTask(this);
        this.pipeline.setLogger(logger);
        try {
            for (Module m : this.modules) {
                PipelineHashIO pipelineInput = new PipelineHashIO();
                for (Map.Entry<String, String> e : this.attrs.entrySet()) {
                    pipelineInput.setAttribute(e.getKey(), e.getValue());
                }
                for (Param p : m.params) {
                    if (!p.isValid()) {
                        throw new BuildException("Incomplete parameter");
                    }
                    String ifProperty = p.getIf();
                    String unlessProperty = p.getUnless();
                    if (ifProperty != null && !this.getProject().getProperties().containsKey(ifProperty) || unlessProperty != null && this.getProject().getProperties().containsKey(unlessProperty)) continue;
                    pipelineInput.setAttribute(p.getName(), p.getValue());
                }
                this.pipeline.execute(m.getImplementation(), (AbstractPipelineInput)pipelineInput);
            }
        }
        catch (DITAOTException e) {
            throw new BuildException("Failed to run pipeline: " + e.getMessage(), (Throwable)e);
        }
    }

    public static class Param {
        private String name;
        private String value;
        private String ifProperty;
        private String unlessProperty;

        public String getName() {
            return this.name;
        }

        public boolean isValid() {
            return this.name != null && this.value != null;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getValue() {
            return this.value;
        }

        public void setExpression(String v) {
            this.value = v;
        }

        public void setValue(String v) {
            this.value = v;
        }

        public void setLocation(File v) {
            this.value = v.getPath();
        }

        public String getIf() {
            return this.ifProperty;
        }

        public void setIf(String p) {
            this.ifProperty = p;
        }

        public String getUnless() {
            return this.unlessProperty;
        }

        public void setUnless(String p) {
            this.unlessProperty = p;
        }
    }

    public static class Module {
        public final List<Param> params = new ArrayList<Param>();
        private Class<? extends AbstractPipelineModule> cls;

        public void setClass(Class<? extends AbstractPipelineModule> cls) {
            this.cls = cls;
        }

        public void addConfiguredParam(Param p) {
            this.params.add(p);
        }

        public Class<? extends AbstractPipelineModule> getImplementation() {
            return this.cls;
        }
    }
}

