/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTLogger;

public final class DITAOTAntLogger
implements DITAOTLogger {
    private final Project project;
    private Task task;
    private Target target;

    public DITAOTAntLogger(Project project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    @Override
    public void logInfo(String msg) {
        this.log(msg, null, 2);
    }

    @Override
    public void logWarn(String msg) {
        this.log(msg, null, 1);
    }

    @Override
    public void logError(String msg) {
        this.log(msg, null, 0);
    }

    @Override
    public void logError(String msg, Throwable t) {
        this.log(msg, t, 0);
    }

    @Override
    public void logDebug(String msg) {
        this.log(msg, null, 3);
    }

    private void log(String msg, Throwable t, int level) {
        if (this.task != null) {
            this.project.log(this.task, msg, level);
        } else if (this.target != null) {
            this.project.log(this.target, msg, level);
        } else {
            this.project.log(msg, level);
        }
    }
}

