/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTFileLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.util.Constants;

public final class DITAOTBuildLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected static final String LINE_SEP = StringUtils.LINE_SEP;
    private final AtomicInteger numOfFatals = new AtomicInteger(0);
    private final AtomicInteger numOfErrors = new AtomicInteger(0);
    private final AtomicInteger numOfWarnings = new AtomicInteger(0);
    private final AtomicInteger numOfInfo = new AtomicInteger(0);
    private final Pattern fatalPattern = Pattern.compile("\\[\\w+F\\]\\[FATAL\\]");
    private final Pattern errorPattern = Pattern.compile("\\[\\w+E\\]\\[ERROR\\]");
    private final Pattern warnPattern = Pattern.compile("\\[\\w+W\\]\\[WARN\\]");
    private final Pattern infoPattern = Pattern.compile("\\[\\w+I\\]\\[INFO\\]");
    private final Pattern debugPattern = Pattern.compile("\\[\\w+D\\]\\[DEBUG\\]");
    private PrintStream err;
    private final DITAOTFileLogger logger;
    private int msgOutputLevel = 0;
    private PrintStream out;
    private long startTime = System.currentTimeMillis();
    private final Set<Throwable> exceptionsCaptured = new HashSet<Throwable>();

    protected static String formatTime(long millis) {
        return DateUtils.formatElapsedTime((long)millis);
    }

    protected static String getBuildFailedMessage() {
        return "BUILD FAILED";
    }

    protected static String getBuildSuccessfulMessage() {
        return "BUILD SUCCESSFUL";
    }

    protected void printMessage(String message, PrintStream stream, int priority) {
        int fixedPriority = priority;
        if (this.fatalPattern.matcher(message).find()) {
            fixedPriority = 0;
            this.numOfFatals.incrementAndGet();
        } else if (this.errorPattern.matcher(message).find()) {
            fixedPriority = 0;
        } else if (this.warnPattern.matcher(message).find()) {
            fixedPriority = 1;
        } else if (this.infoPattern.matcher(message).find()) {
            fixedPriority = 2;
        } else if (this.debugPattern.matcher(message).find()) {
            fixedPriority = 4;
        }
        switch (fixedPriority) {
            case 0: {
                this.numOfErrors.incrementAndGet();
                break;
            }
            case 1: {
                this.numOfWarnings.incrementAndGet();
                if (!message.contains("[WARN]")) {
                    stream.println("Extra warnings counted");
                    this.logger.logInfo("Extra warnings counted");
                    break;
                }
                stream.println("Normal warnings counted");
                this.logger.logInfo("Normal warnings counted");
                break;
            }
            case 2: {
                this.numOfInfo.incrementAndGet();
            }
        }
        if (fixedPriority <= 2) {
            stream.println(message);
        }
    }

    public DITAOTBuildLogger() {
        this.logger = DITAOTFileLogger.getInstance();
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer message = new StringBuffer();
        message.append("Processing ended.");
        message.append(LINE_SEP);
        if (error == null && this.numOfFatals.get() == 0 && this.numOfErrors.get() == 0) {
            message.append(LINE_SEP);
            message.append(DITAOTBuildLogger.getBuildSuccessfulMessage());
        } else {
            message.append(LINE_SEP);
            message.append(DITAOTBuildLogger.getBuildFailedMessage());
            message.append(LINE_SEP);
            if (error != null) {
                message.append(error.toString());
                message.append(LINE_SEP);
                if (3 <= this.msgOutputLevel) {
                    message.append(StringUtils.getStackTrace((Throwable)error));
                }
            }
        }
        message.append(LINE_SEP);
        message.append("Number of Fatals : ").append(this.numOfFatals.get()).append(Constants.LINE_SEPARATOR);
        message.append("Number of Errors : ").append(this.numOfErrors.get()).append(Constants.LINE_SEPARATOR);
        message.append("Number of Warnings : ").append(this.numOfWarnings.get()).append(Constants.LINE_SEPARATOR);
        message.append(LINE_SEP);
        message.append("Total time: ");
        message.append(DITAOTBuildLogger.formatTime(System.currentTimeMillis() - this.startTime));
        String msg = message.toString();
        if (error == null) {
            this.printMessage(msg, this.out, 2);
            this.logger.logInfo(msg);
        } else {
            this.printMessage(msg, this.out, 0);
            this.logger.logError(msg);
        }
        this.logger.closeLogger();
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority > this.msgOutputLevel) {
            return;
        }
        StringBuffer message = new StringBuffer();
        Task eventTask = event.getTask();
        if (eventTask != null) {
            String label = new StringBuffer().append("  [").append(eventTask.getTaskName()).append("] ").toString();
            BufferedReader r = null;
            try {
                boolean first = true;
                r = new BufferedReader(new StringReader(event.getMessage()));
                String line = r.readLine();
                while (line != null) {
                    if (!first) {
                        message.append(StringUtils.LINE_SEP);
                    }
                    first = false;
                    message.append(label).append(line);
                    line = r.readLine();
                }
            }
            catch (IOException e) {
                message.append(label).append(event.getMessage());
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException ioe) {}
            }
        } else {
            message.append(event.getMessage());
        }
        String msg = message.toString();
        this.catchHHCError(msg);
        if (priority != 0) {
            boolean flag = false;
            if (eventTask != null && "xslt".equals(eventTask.getTaskName()) && msg.indexOf("DOTX") == -1) {
                flag = true;
            }
            if (eventTask != null && "fop".equals(eventTask.getTaskName())) {
                flag = true;
            }
            if (!flag) {
                this.printMessage(msg, this.out, priority);
            }
            this.logger.logInfo(msg);
        } else if (eventTask != null && "exec".equals(eventTask.getTaskName()) && msg.indexOf("ERROR") == -1) {
            this.logger.logError(msg);
        } else {
            this.printMessage(msg, this.err, priority);
            this.logger.logError(msg);
        }
    }

    public void setEmacsMode(boolean mode) {
    }

    public void setErrorPrintStream(PrintStream errorPrintStream) {
        this.err = new PrintStream(errorPrintStream, true);
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel && !"".equals(event.getTarget().getName())) {
            String desc = event.getTarget().getDescription();
            String msg = desc + "...";
            if (desc == null || desc.trim().length() == 0) {
                return;
            }
            this.printMessage(msg, this.out, 2);
            this.logger.logInfo(msg);
        }
    }

    public void taskFinished(BuildEvent event) {
        if (event.getException() == null) {
            return;
        }
        Throwable exception = event.getException();
        if (exception instanceof BuildException) {
            BuildException buildEx = (BuildException)exception;
            Throwable innerEx = buildEx.getException();
            if (innerEx != null && innerEx instanceof DITAOTException) {
                DITAOTException ex = (DITAOTException)innerEx;
                if (ex.alreadyCaptured()) {
                    return;
                }
                ex.setCaptured(true);
                MessageBean msgBean = ex.getMessageBean();
                if (msgBean != null) {
                    this.increaseNumOfExceptionByType(msgBean.getType());
                } else {
                    this.increaseNumOfExceptionByType(null);
                }
                return;
            }
            if (!this.chkThrowableAlreadyCaptured((Throwable)buildEx)) {
                this.numOfErrors.incrementAndGet();
                return;
            }
        } else if (!this.chkThrowableAlreadyCaptured(exception)) {
            this.numOfErrors.incrementAndGet();
        }
    }

    public void taskStarted(BuildEvent event) {
    }

    private boolean chkThrowableAlreadyCaptured(Throwable ex) {
        boolean captured = false;
        if (ex == null) {
            return true;
        }
        Throwable parent = ex;
        for (Throwable unknownEx = parent.getCause(); unknownEx != null; unknownEx = unknownEx.getCause()) {
            parent = unknownEx;
            if (!this.exceptionsCaptured.contains(unknownEx) && !(unknownEx instanceof DITAOTException)) continue;
            captured = true;
            return captured;
        }
        if (!captured) {
            this.exceptionsCaptured.add(parent);
        }
        return captured;
    }

    private void catchHHCError(String message) {
        if (message == null) {
            return;
        }
        String upperMessage = message.toUpperCase();
        if (upperMessage.indexOf("HHC") != -1 && upperMessage.indexOf("ERROR:") != -1) {
            this.numOfErrors.incrementAndGet();
        }
    }

    private void increaseNumOfExceptionByType(String msgType) {
        if (msgType == null) {
            this.numOfInfo.incrementAndGet();
        } else {
            String type = msgType.toUpperCase();
            if ("FATAL".equals(type)) {
                this.numOfFatals.incrementAndGet();
            } else if ("ERROR".equals(type)) {
                this.numOfErrors.incrementAndGet();
            } else if ("WARN".equals(type)) {
                this.numOfWarnings.incrementAndGet();
                this.out.println("Extra warnings counted");
                this.logger.logInfo("Extra warnings counted");
            } else if ("INFO".equals(type)) {
                this.numOfInfo.incrementAndGet();
            }
        }
    }
}

