/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Echo;
import org.dita.dost.invoker.ExtensibleAntInvoker;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;

public final class DITAOTEchoTask
extends Echo {
    private String id = null;
    private final ArrayList<ExtensibleAntInvoker.Param> params = new ArrayList();
    private DITAOTLogger logger;

    public void setId(String identifier) {
        this.id = identifier;
    }

    public ExtensibleAntInvoker.Param createParam() {
        ExtensibleAntInvoker.Param p = new ExtensibleAntInvoker.Param();
        this.params.add(p);
        return p;
    }

    public void execute() throws BuildException {
        this.logger = new DITAOTAntLogger(this.getProject());
        MessageBean msgBean = MessageUtils.getInstance().getMessage(this.id, this.readParamValues());
        if (msgBean != null) {
            String type = msgBean.getType();
            if ("ERROR".equals(type)) {
                this.logger.logError(msgBean.toString());
            } else if ("WARN".equals(type)) {
                this.logger.logWarn(msgBean.toString());
            } else if ("INFO".equals(type)) {
                this.logger.logInfo(msgBean.toString());
            } else if ("DEBUG".equals(type)) {
                this.logger.logDebug(msgBean.toString());
            }
        }
    }

    private String[] readParamValues() throws BuildException {
        ArrayList<String> prop = new ArrayList<String>();
        for (ExtensibleAntInvoker.Param p : this.params) {
            if (!p.isValid()) {
                throw new BuildException("Incomplete parameter");
            }
            String ifProperty = p.getIf();
            String unlessProperty = p.getUnless();
            if (ifProperty != null && !this.getProject().getProperties().containsKey(ifProperty) || unlessProperty != null && this.getProject().getProperties().containsKey(unlessProperty)) continue;
            int idx = Integer.parseInt(p.getName()) - 1;
            if (idx >= prop.size()) {
                prop.ensureCapacity(idx + 1);
                while (prop.size() < idx + 1) {
                    prop.add(null);
                }
            }
            prop.set(idx, p.getValue());
        }
        return prop.toArray(new String[prop.size()]);
    }
}

