/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Exit;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.taskdefs.condition.ConditionBase;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.invoker.ExtensibleAntInvoker;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;

public final class DITAOTFailTask
extends Exit {
    private String id = null;
    private final ArrayList<ExtensibleAntInvoker.Param> params = new ArrayList();
    private String message;
    private String ifCondition;
    private String unlessCondition;
    private NestedCondition nestedCondition;
    private Integer status;

    public void setId(String identifier) {
        this.id = identifier;
    }

    public ExtensibleAntInvoker.Param createParam() {
        ExtensibleAntInvoker.Param p = new ExtensibleAntInvoker.Param();
        this.params.add(p);
        return p;
    }

    public void execute() throws BuildException {
        boolean fail;
        boolean bl = this.nestedConditionPresent() ? this.testNestedCondition() : (fail = this.testIfCondition() && this.testUnlessCondition());
        if (!fail) {
            return;
        }
        if (this.id == null) {
            throw new BuildException("id attribute must be specified");
        }
        MessageBean msgBean = MessageUtils.getInstance().getMessage(this.id, this.readParamValues());
        DITAOTAntLogger logger = new DITAOTAntLogger(this.getProject());
        if (msgBean != null) {
            String type = msgBean.getType();
            if ("FATAL".equals(type)) {
                this.setMessage(msgBean.toString());
                try {
                    super.execute();
                }
                catch (BuildException ex) {
                    throw new BuildException(msgBean.toString(), (Throwable)new DITAOTException(msgBean, ex, msgBean.toString()));
                }
            } else if ("ERROR".equals(type)) {
                logger.logError(msgBean.toString());
            } else if ("WARN".equals(type)) {
                logger.logWarn(msgBean.toString());
            } else if ("INFO".equals(type)) {
                logger.logInfo(msgBean.toString());
            } else if ("DEBUG".equals(type)) {
                logger.logDebug(msgBean.toString());
            }
        }
    }

    private String[] readParamValues() throws BuildException {
        ArrayList<String> prop = new ArrayList<String>();
        for (ExtensibleAntInvoker.Param p : this.params) {
            if (!p.isValid()) {
                throw new BuildException("Incomplete parameter");
            }
            String ifProperty = p.getIf();
            String unlessProperty = p.getUnless();
            if (ifProperty != null && !this.getProject().getProperties().containsKey(ifProperty) || unlessProperty != null && this.getProject().getProperties().containsKey(unlessProperty)) continue;
            int idx = Integer.parseInt(p.getName()) - 1;
            if (idx >= prop.size()) {
                prop.ensureCapacity(idx + 1);
                while (prop.size() < idx + 1) {
                    prop.add(null);
                }
            }
            prop.set(idx, p.getValue());
        }
        return prop.toArray(new String[prop.size()]);
    }

    public void setMessage(String value) {
        this.message = value;
    }

    public void setIf(String c) {
        this.ifCondition = c;
    }

    public void setUnless(String c) {
        this.unlessCondition = c;
    }

    public void setStatus(int i) {
        this.status = new Integer(i);
    }

    public void addText(String msg) {
        if (this.message == null) {
            this.message = "";
        }
        this.message = this.message + this.getProject().replaceProperties(msg);
    }

    public ConditionBase createCondition() {
        if (this.nestedCondition != null) {
            throw new BuildException("Only one nested condition is allowed.");
        }
        this.nestedCondition = new NestedCondition();
        return this.nestedCondition;
    }

    private boolean testIfCondition() {
        if (this.ifCondition == null || "".equals(this.ifCondition)) {
            return true;
        }
        return this.getProject().getProperty(this.ifCondition) != null;
    }

    private boolean testUnlessCondition() {
        if (this.unlessCondition == null || "".equals(this.unlessCondition)) {
            return true;
        }
        return this.getProject().getProperty(this.unlessCondition) == null;
    }

    private boolean testNestedCondition() {
        boolean result = this.nestedConditionPresent();
        if (result && this.ifCondition != null || this.unlessCondition != null) {
            throw new BuildException("Nested conditions not permitted in conjunction with if/unless attributes");
        }
        return result && this.nestedCondition.eval();
    }

    private boolean nestedConditionPresent() {
        return this.nestedCondition != null;
    }

    private static class NestedCondition
    extends ConditionBase
    implements Condition {
        private NestedCondition() {
        }

        public boolean eval() {
            if (this.countConditions() != 1) {
                throw new BuildException("A single nested condition is required.");
            }
            return ((Condition)this.getConditions().nextElement()).eval();
        }
    }
}

