/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.DITAOTLogger;

public final class DITAOTFileLogger
implements DITAOTLogger {
    private static DITAOTFileLogger logger;
    private final File tmpLogFile;
    private String logFile;
    private String logDir;
    private final PrintWriter printWriter;

    private DITAOTFileLogger() {
        try {
            this.tmpLogFile = File.createTempFile("ditaot-", ".log");
            this.printWriter = new PrintWriter(new FileOutputStream(this.tmpLogFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized DITAOTFileLogger getInstance() {
        if (logger == null) {
            logger = new DITAOTFileLogger();
        }
        return logger;
    }

    public void closeLogger() {
        DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
        if (logger == null) {
            return;
        }
        this.printWriter.close();
        if (this.logDir != null && this.logFile != null) {
            File log = new File(this.logDir, this.logFile);
            if (log.exists()) {
                log.delete();
            }
            if (this.tmpLogFile.renameTo(log)) {
                StringBuffer buff = new StringBuffer(256);
                buff.append("Log file '").append(this.logFile);
                buff.append("' was generated successfully in directory '");
                buff.append(this.logDir).append("'.");
                javaLogger.logInfo(buff.toString());
                return;
            }
        }
        if (this.tmpLogFile.exists()) {
            this.tmpLogFile.delete();
        }
        javaLogger.logError("Failed to generate log file.");
    }

    public String getLogDir() {
        return this.logDir;
    }

    public void setLogFile(String filename) {
        this.logFile = filename;
    }

    public void setLogDir(String logdir) {
        this.logDir = logdir;
    }

    @Override
    public void logInfo(String msg) {
        this.logMessage(msg);
    }

    @Override
    public void logWarn(String msg) {
        this.logMessage(msg);
    }

    @Override
    public void logError(String msg) {
        this.logMessage(msg);
    }

    @Override
    public void logError(String msg, Throwable t) {
        this.logError(t.getMessage());
        t.printStackTrace(this.printWriter);
    }

    @Override
    public void logDebug(String msg) {
        this.logMessage(msg);
    }

    private void logMessage(String msg) {
        this.printWriter.println(msg);
    }
}

