/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.LogUtils;

public final class DITAOTJavaLogger
implements DITAOTLogger {
    private static boolean debugMode = false;

    public static void enableDebugMode() {
        debugMode = true;
    }

    @Override
    public void logInfo(String msg) {
        System.out.println(msg);
    }

    @Override
    public void logWarn(String msg) {
        LogUtils.increaseNumOfWarnings();
        System.out.println(msg);
    }

    @Override
    public void logError(String msg) {
        LogUtils.increaseNumOfErrors();
        System.err.println(msg);
    }

    @Override
    public void logError(String msg, Throwable t) {
        this.logError(t.toString());
        if (debugMode) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void logDebug(String msg) {
        if (debugMode) {
            System.out.println(msg);
        }
    }
}

