/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTBuildLogger;
import org.dita.dost.log.DITAOTFileLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;

public final class LogConfigTask
extends Task {
    private String logDir = null;
    private String logFile = null;

    public void execute() throws BuildException {
        if (!this.isEnabled()) {
            return;
        }
        DITAOTFileLogger logger = DITAOTFileLogger.getInstance();
        String oldLogDir = logger.getLogDir();
        this.initLogDirectory();
        this.initLogFile();
        if (oldLogDir != null) {
            if (!oldLogDir.equals(this.logDir)) {
                this.logDir = this.getProject().getBaseDir().getAbsolutePath();
            }
            this.logFile = "ditaot_batch.log";
        }
        logger.setLogDir(this.logDir);
        logger.setLogFile(this.logFile);
    }

    private boolean isEnabled() {
        Vector listeners = this.getProject().getBuildListeners();
        for (BuildListener listener : listeners) {
            if (!(listener instanceof DITAOTBuildLogger)) continue;
            return true;
        }
        return false;
    }

    private void initLogDirectory() throws BuildException {
        Project project = this.getProject();
        File dir = null;
        this.logDir = project.getProperty("args.logdir");
        if (this.logDir == null) {
            this.logDir = project.getProperty("output.dir");
        }
        if (this.logDir == null || "".equals(this.logDir)) {
            MessageBean msgBean = MessageUtils.getInstance().getMessage("DOTJ015F", new String[0]);
            String msg = msgBean.toString();
            throw new BuildException(msg, (Throwable)new DITAOTException(msgBean, null, msg));
        }
        if (!new File(this.logDir).isAbsolute()) {
            this.logDir = new File(project.getBaseDir(), this.logDir).getAbsolutePath();
        }
        if (!(dir = new File(this.logDir)).exists() && !dir.mkdirs()) {
            MessageBean msgBean = MessageUtils.getInstance().getMessage("DOTJ016F", this.logDir);
            String msg = msgBean.toString();
            throw new BuildException(msg, (Throwable)new DITAOTException(msgBean, null, msg));
        }
    }

    private void initLogFile() throws BuildException {
        Project project = this.getProject();
        String inputFile = null;
        String rootName = null;
        String transType = null;
        int pos = 0;
        String input = project.getProperty("args.input");
        if (input == null) {
            input = project.getProperty("dita.input");
        }
        if (input == null) {
            MessageBean msgBean = MessageUtils.getInstance().getMessage("DOTJ017F", new String[0]);
            String msg = msgBean.toString();
            throw new BuildException(msg, (Throwable)new DITAOTException(msgBean, null, msg));
        }
        transType = project.getProperty("transtype");
        if (transType == null) {
            transType = "";
        }
        rootName = (pos = (inputFile = new File(input).getName()).indexOf(46)) == -1 ? inputFile : inputFile.substring(0, pos);
        this.logFile = rootName + "_" + transType + ".log";
    }
}

