/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public final class MessageBean {
    public static final String FATAL = "FATAL";
    public static final String ERROR = "ERROR";
    public static final String WARN = "WARN";
    public static final String INFO = "INFO";
    public static final String DEBUG = "DEBUG";
    private final String id;
    private final String type;
    private final String reason;
    private final String response;
    private String srcFile;
    private int srcLine = -1;
    private int srcColumn = -1;

    public MessageBean(String mbId, String mbType, String mbReason, String mbResponse) {
        this.id = mbId;
        this.type = mbType;
        this.reason = mbReason;
        this.response = mbResponse;
    }

    public MessageBean(MessageBean message) {
        this(message.getId(), message.getType(), message.getReason(), message.getResponse());
    }

    public String getId() {
        return this.id;
    }

    public String getReason() {
        return this.reason;
    }

    public String getResponse() {
        return this.response;
    }

    public String getType() {
        return this.type;
    }

    public MessageBean setLocation(Locator locator) {
        if (locator == null) {
            return this;
        }
        MessageBean ret = new MessageBean(this);
        if (locator.getSystemId() != null) {
            URI s;
            try {
                s = new URI(locator.getSystemId());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to parse URI '" + locator.getSystemId() + "': " + e.getMessage(), e);
            }
            ret.srcFile = new File(s).getAbsolutePath();
        }
        ret.srcLine = locator.getLineNumber();
        ret.srcColumn = locator.getColumnNumber();
        return ret;
    }

    public MessageBean setLocation(Attributes atts) {
        int delim;
        int sep;
        String xtrc;
        MessageBean ret = new MessageBean(this);
        String xtrf = atts.getValue("xtrf");
        if (xtrf != null) {
            ret.srcFile = xtrf;
        }
        if ((xtrc = atts.getValue("xtrc")) != null && (sep = xtrc.indexOf(59)) != -1 && (delim = xtrc.indexOf(":", sep + 1)) != -1) {
            ret.srcLine = Integer.parseInt(xtrc.substring(sep + 1, delim));
            ret.srcColumn = Integer.parseInt(xtrc.substring(delim + 1));
        }
        return ret;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(256);
        if (this.srcFile != null) {
            buff.append(this.srcFile);
            if (this.srcLine != -1 && this.srcColumn != -1) {
                buff.append(':').append((Object)this.srcLine).append(':').append((Object)this.srcColumn);
            }
            buff.append(": ");
        }
        buff.append("[").append(this.id).append("]");
        buff.append("[").append(this.type).append("] ");
        buff.append(this.reason);
        if (this.response != null) {
            buff.append(" ").append(this.response);
        }
        return buff.toString();
    }
}

