/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MessageUtils {
    private static final String ELEMENT_MESSAGE = "message";
    private static final String ELEMENT_REASON = "reason";
    private static final String ELEMENT_RESPONSE = "response";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TYPE = "type";
    private static String defaultResource = "resource/messages.xml";
    private final Hashtable<String, MessageBean> hashTable = new Hashtable();
    private final DITAOTLogger logger = new DITAOTJavaLogger();
    private static MessageUtils utils;

    private MessageUtils() {
    }

    public static synchronized MessageUtils getInstance() {
        if (utils == null) {
            utils = new MessageUtils();
            utils.loadDefaultMessages();
        }
        return utils;
    }

    void loadDefaultMessages() {
        InputStream msg = null;
        try {
            msg = new File(defaultResource).exists() ? new FileInputStream(new File(defaultResource)) : this.getClass().getClassLoader().getResourceAsStream(defaultResource);
            if (msg != null) {
                this.loadMessages(msg);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load messages configuration file: " + e.getMessage(), e);
        }
        finally {
            if (msg != null) {
                try {
                    msg.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadMessages(InputStream in) throws Exception {
        Hashtable<String, MessageBean> hashtable = this.hashTable;
        synchronized (hashtable) {
            this.hashTable.clear();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(in);
                Element messages = doc.getDocumentElement();
                NodeList messageList = messages.getElementsByTagName(ELEMENT_MESSAGE);
                int messageListLength = messageList.getLength();
                for (int i = 0; i < messageListLength; ++i) {
                    Element message = (Element)messageList.item(i);
                    Node reason = message.getElementsByTagName(ELEMENT_REASON).item(0);
                    Node response = message.getElementsByTagName(ELEMENT_RESPONSE).item(0);
                    NamedNodeMap attrs = message.getAttributes();
                    MessageBean messageBean = new MessageBean(attrs.getNamedItem(ATTRIBUTE_ID).getNodeValue(), attrs.getNamedItem(ATTRIBUTE_TYPE).getNodeValue(), reason.getFirstChild().getNodeValue(), response.getFirstChild() != null ? response.getFirstChild().getNodeValue() : null);
                    this.hashTable.put(messageBean.getId(), messageBean);
                }
            }
            catch (Exception e) {
                throw new Exception("Failed to read messages configuration file: " + e.getMessage(), e);
            }
        }
    }

    private MessageBean getMessage(String id) {
        if (this.hashTable == null) {
            throw new IllegalStateException("Messages have not been loaded");
        }
        MessageBean hashMessage = this.hashTable.get(id);
        if (hashMessage != null) {
            return new MessageBean(hashMessage);
        }
        this.logger.logWarn("  Can't find message for id: " + id);
        return new MessageBean(id, "", "", "");
    }

    public MessageBean getMessage(String id, String ... params) {
        MessageBean messageBean = this.getMessage(id);
        if (params.length == 0) {
            return messageBean;
        }
        String reason = messageBean.getReason();
        String response = messageBean.getResponse();
        for (int i = 0; i < params.length; ++i) {
            String key = "%" + Integer.toString(i + 1);
            String replacement = params[i];
            reason = StringUtils.replaceAll(reason, key, replacement);
            if (response == null) continue;
            response = StringUtils.replaceAll(response, key, replacement);
        }
        return new MessageBean(messageBean.getId(), messageBean.getType(), reason, response);
    }
}

